/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.application;

import com.linkedin.common.UrnArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Applications
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.application/**Links from an Asset to its Applications*/@Aspect.name=\"applications\"record Applications{/**The Applications attached to an Asset*/@Relationship.`/*`={\"entityTypes\":[\"application\"],\"name\":\"AssociatedWith\"}@Searchable.`/*`={\"addToFilters\":true,\"fieldName\":\"applications\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Application\",\"hasValuesFieldName\":\"hasApplication\"}applications:array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]}", SchemaFormatType.PDL);
    private UrnArray _applicationsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Applications = SCHEMA.getField("applications");

    public Applications() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public Applications(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasApplications() {
        if (this._applicationsField != null) {
            return true;
        }
        return this._map.containsKey("applications");
    }

    public void removeApplications() {
        this._map.remove("applications");
    }

    @Nullable
    public UrnArray getApplications(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getApplications();
            }
            case DEFAULT: 
            case NULL: {
                if (this._applicationsField != null) {
                    return this._applicationsField;
                }
                Object __rawValue = this._map.get("applications");
                this._applicationsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._applicationsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public UrnArray getApplications() {
        if (this._applicationsField != null) {
            return this._applicationsField;
        }
        Object __rawValue = this._map.get("applications");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("applications");
        }
        this._applicationsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._applicationsField;
    }

    public Applications setApplications(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setApplications(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field applications of com.linkedin.application.Applications");
                }
                CheckedUtil.putWithoutChecking(this._map, "applications", value.data());
                this._applicationsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeApplications();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "applications", value.data());
                this._applicationsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "applications", value.data());
                this._applicationsField = value;
            }
        }
        return this;
    }

    public Applications setApplications(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field applications of com.linkedin.application.Applications to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "applications", value.data());
        this._applicationsField = value;
        return this;
    }

    @Override
    public Applications clone() throws CloneNotSupportedException {
        Applications __clone = (Applications)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public Applications copy() throws CloneNotSupportedException {
        Applications __copy = (Applications)super.copy();
        __copy._applicationsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final Applications __objectRef;

        private ChangeListener(Applications reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "applications": {
                    this.__objectRef._applicationsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec applications() {
            return new PathSpec(this.getPathComponents(), "applications");
        }

        public PathSpec applications(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "applications");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withApplications() {
            this.getDataMap().put("applications", 1);
            return this;
        }

        public ProjectionMask withApplications(Integer start, Integer count) {
            this.getDataMap().put("applications", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("applications").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("applications").put("$count", count);
            }
            return this;
        }
    }
}

