/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.structured;

import com.linkedin.data.DataList;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.structured.PrimitivePropertyValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class PrimitivePropertyValueArray
extends WrappingArrayTemplate<PrimitivePropertyValue> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[union[string,double]]", SchemaFormatType.PDL);

    public PrimitivePropertyValueArray() {
        this(new DataList());
    }

    public PrimitivePropertyValueArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public PrimitivePropertyValueArray(Collection<PrimitivePropertyValue> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public PrimitivePropertyValueArray(DataList data) {
        super(data, SCHEMA, PrimitivePropertyValue.class);
    }

    public PrimitivePropertyValueArray(PrimitivePropertyValue first, PrimitivePropertyValue ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public PrimitivePropertyValueArray clone() throws CloneNotSupportedException {
        PrimitivePropertyValueArray __clone = (PrimitivePropertyValueArray)super.clone();
        return __clone;
    }

    @Override
    public PrimitivePropertyValueArray copy() throws CloneNotSupportedException {
        PrimitivePropertyValueArray __copy = (PrimitivePropertyValueArray)super.copy();
        return __copy;
    }

    @Override
    protected PrimitivePropertyValue coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new PrimitivePropertyValue(object);
    }

    public static class ProjectionMask
    extends MaskMap {
        private PrimitivePropertyValue.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<PrimitivePropertyValue.ProjectionMask, PrimitivePropertyValue.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? PrimitivePropertyValue.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PrimitivePropertyValue.Fields items() {
            return new PrimitivePropertyValue.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

