/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.settings.global;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GlobalViewsSettings
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.settings.global/**Settings for DataHub Views feature.*/record GlobalViewsSettings{/**The default View for the instance, or organization.*/@Relationship={\"entityTypes\":[\"dataHubView\"],\"name\":\"viewedWith\"}defaultView:optional{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}", SchemaFormatType.PDL);
    private Urn _defaultViewField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_DefaultView = SCHEMA.getField("defaultView");

    public GlobalViewsSettings() {
        super(new DataMap(2, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public GlobalViewsSettings(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasDefaultView() {
        if (this._defaultViewField != null) {
            return true;
        }
        return this._map.containsKey("defaultView");
    }

    public void removeDefaultView() {
        this._map.remove("defaultView");
    }

    @Nullable
    public Urn getDefaultView(GetMode mode) {
        return this.getDefaultView();
    }

    @Nullable
    public Urn getDefaultView() {
        if (this._defaultViewField != null) {
            return this._defaultViewField;
        }
        Object __rawValue = this._map.get("defaultView");
        this._defaultViewField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._defaultViewField;
    }

    public GlobalViewsSettings setDefaultView(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDefaultView(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDefaultView();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "defaultView", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._defaultViewField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "defaultView", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._defaultViewField = value;
            }
        }
        return this;
    }

    public GlobalViewsSettings setDefaultView(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field defaultView of com.linkedin.settings.global.GlobalViewsSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "defaultView", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._defaultViewField = value;
        return this;
    }

    @Override
    public GlobalViewsSettings clone() throws CloneNotSupportedException {
        GlobalViewsSettings __clone = (GlobalViewsSettings)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public GlobalViewsSettings copy() throws CloneNotSupportedException {
        GlobalViewsSettings __copy = (GlobalViewsSettings)super.copy();
        __copy._defaultViewField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final GlobalViewsSettings __objectRef;

        private ChangeListener(GlobalViewsSettings reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "defaultView": {
                    this.__objectRef._defaultViewField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec defaultView() {
            return new PathSpec(this.getPathComponents(), "defaultView");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withDefaultView() {
            this.getDataMap().put("defaultView", 1);
            return this;
        }
    }
}

