/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.policy;

import com.linkedin.common.UrnArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataHubActorFilter
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.policy/**Information used to filter DataHub actors.*/record DataHubActorFilter{/**A specific set of users to apply the policy to (disjunctive)*/@Searchable.`/*`.fieldType=\"URN\"users:optional array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]/**A specific set of groups to apply the policy to (disjunctive)*/@Searchable.`/*`.fieldType=\"URN\"groups:optional array[com.linkedin.common.Urn]/**Whether the filter should return true for owners of a particular resource.\nOnly applies to policies of type 'Metadata', which have a resource associated with them.*/resourceOwners:boolean=false/**Define type of ownership for the policy*/resourceOwnersTypes:optional array[com.linkedin.common.Urn]/**Whether the filter should apply to all users.*/@Searchable.fieldType=\"BOOLEAN\"allUsers:boolean=false/**Whether the filter should apply to all groups.*/@Searchable.fieldType=\"BOOLEAN\"allGroups:boolean=false/**A specific set of roles to apply the policy to (disjunctive).*/@Relationship.`/*`={\"entityTypes\":[\"dataHubRole\"],\"name\":\"IsAssociatedWithRole\"}@Searchable.`/*`.fieldType=\"URN\"roles:optional array[com.linkedin.common.Urn]}", SchemaFormatType.PDL);
    private UrnArray _usersField = null;
    private UrnArray _groupsField = null;
    private Boolean _resourceOwnersField = null;
    private UrnArray _resourceOwnersTypesField = null;
    private Boolean _allUsersField = null;
    private Boolean _allGroupsField = null;
    private UrnArray _rolesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Users = SCHEMA.getField("users");
    private static final RecordDataSchema.Field FIELD_Groups = SCHEMA.getField("groups");
    private static final RecordDataSchema.Field FIELD_ResourceOwners = SCHEMA.getField("resourceOwners");
    private static final Boolean DEFAULT_ResourceOwners;
    private static final RecordDataSchema.Field FIELD_ResourceOwnersTypes;
    private static final RecordDataSchema.Field FIELD_AllUsers;
    private static final Boolean DEFAULT_AllUsers;
    private static final RecordDataSchema.Field FIELD_AllGroups;
    private static final Boolean DEFAULT_AllGroups;
    private static final RecordDataSchema.Field FIELD_Roles;

    public DataHubActorFilter() {
        super(new DataMap(10, 0.75f), SCHEMA, 6);
        this.addChangeListener(this.__changeListener);
    }

    public DataHubActorFilter(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasUsers() {
        if (this._usersField != null) {
            return true;
        }
        return this._map.containsKey("users");
    }

    public void removeUsers() {
        this._map.remove("users");
    }

    @Nullable
    public UrnArray getUsers(GetMode mode) {
        return this.getUsers();
    }

    @Nullable
    public UrnArray getUsers() {
        if (this._usersField != null) {
            return this._usersField;
        }
        Object __rawValue = this._map.get("users");
        this._usersField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._usersField;
    }

    public DataHubActorFilter setUsers(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUsers(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUsers();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "users", value.data());
                this._usersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "users", value.data());
                this._usersField = value;
            }
        }
        return this;
    }

    public DataHubActorFilter setUsers(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field users of com.linkedin.policy.DataHubActorFilter to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "users", value.data());
        this._usersField = value;
        return this;
    }

    public boolean hasGroups() {
        if (this._groupsField != null) {
            return true;
        }
        return this._map.containsKey("groups");
    }

    public void removeGroups() {
        this._map.remove("groups");
    }

    @Nullable
    public UrnArray getGroups(GetMode mode) {
        return this.getGroups();
    }

    @Nullable
    public UrnArray getGroups() {
        if (this._groupsField != null) {
            return this._groupsField;
        }
        Object __rawValue = this._map.get("groups");
        this._groupsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._groupsField;
    }

    public DataHubActorFilter setGroups(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setGroups(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeGroups();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
                this._groupsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
                this._groupsField = value;
            }
        }
        return this;
    }

    public DataHubActorFilter setGroups(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field groups of com.linkedin.policy.DataHubActorFilter to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
        this._groupsField = value;
        return this;
    }

    public boolean hasResourceOwners() {
        if (this._resourceOwnersField != null) {
            return true;
        }
        return this._map.containsKey("resourceOwners");
    }

    public void removeResourceOwners() {
        this._map.remove("resourceOwners");
    }

    @Nullable
    public Boolean isResourceOwners(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isResourceOwners();
            }
            case NULL: {
                if (this._resourceOwnersField != null) {
                    return this._resourceOwnersField;
                }
                Object __rawValue = this._map.get("resourceOwners");
                this._resourceOwnersField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._resourceOwnersField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isResourceOwners() {
        if (this._resourceOwnersField != null) {
            return this._resourceOwnersField;
        }
        Object __rawValue = this._map.get("resourceOwners");
        if (__rawValue == null) {
            return DEFAULT_ResourceOwners;
        }
        this._resourceOwnersField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._resourceOwnersField;
    }

    public DataHubActorFilter setResourceOwners(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setResourceOwners(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field resourceOwners of com.linkedin.policy.DataHubActorFilter");
                }
                CheckedUtil.putWithoutChecking(this._map, "resourceOwners", value);
                this._resourceOwnersField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeResourceOwners();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "resourceOwners", value);
                this._resourceOwnersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "resourceOwners", value);
                this._resourceOwnersField = value;
            }
        }
        return this;
    }

    public DataHubActorFilter setResourceOwners(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field resourceOwners of com.linkedin.policy.DataHubActorFilter to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "resourceOwners", value);
        this._resourceOwnersField = value;
        return this;
    }

    public DataHubActorFilter setResourceOwners(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "resourceOwners", value);
        this._resourceOwnersField = value;
        return this;
    }

    public boolean hasResourceOwnersTypes() {
        if (this._resourceOwnersTypesField != null) {
            return true;
        }
        return this._map.containsKey("resourceOwnersTypes");
    }

    public void removeResourceOwnersTypes() {
        this._map.remove("resourceOwnersTypes");
    }

    @Nullable
    public UrnArray getResourceOwnersTypes(GetMode mode) {
        return this.getResourceOwnersTypes();
    }

    @Nullable
    public UrnArray getResourceOwnersTypes() {
        if (this._resourceOwnersTypesField != null) {
            return this._resourceOwnersTypesField;
        }
        Object __rawValue = this._map.get("resourceOwnersTypes");
        this._resourceOwnersTypesField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._resourceOwnersTypesField;
    }

    public DataHubActorFilter setResourceOwnersTypes(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setResourceOwnersTypes(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeResourceOwnersTypes();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "resourceOwnersTypes", value.data());
                this._resourceOwnersTypesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "resourceOwnersTypes", value.data());
                this._resourceOwnersTypesField = value;
            }
        }
        return this;
    }

    public DataHubActorFilter setResourceOwnersTypes(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field resourceOwnersTypes of com.linkedin.policy.DataHubActorFilter to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "resourceOwnersTypes", value.data());
        this._resourceOwnersTypesField = value;
        return this;
    }

    public boolean hasAllUsers() {
        if (this._allUsersField != null) {
            return true;
        }
        return this._map.containsKey("allUsers");
    }

    public void removeAllUsers() {
        this._map.remove("allUsers");
    }

    @Nullable
    public Boolean isAllUsers(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isAllUsers();
            }
            case NULL: {
                if (this._allUsersField != null) {
                    return this._allUsersField;
                }
                Object __rawValue = this._map.get("allUsers");
                this._allUsersField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._allUsersField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isAllUsers() {
        if (this._allUsersField != null) {
            return this._allUsersField;
        }
        Object __rawValue = this._map.get("allUsers");
        if (__rawValue == null) {
            return DEFAULT_AllUsers;
        }
        this._allUsersField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._allUsersField;
    }

    public DataHubActorFilter setAllUsers(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAllUsers(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field allUsers of com.linkedin.policy.DataHubActorFilter");
                }
                CheckedUtil.putWithoutChecking(this._map, "allUsers", value);
                this._allUsersField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAllUsers();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "allUsers", value);
                this._allUsersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "allUsers", value);
                this._allUsersField = value;
            }
        }
        return this;
    }

    public DataHubActorFilter setAllUsers(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field allUsers of com.linkedin.policy.DataHubActorFilter to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "allUsers", value);
        this._allUsersField = value;
        return this;
    }

    public DataHubActorFilter setAllUsers(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "allUsers", value);
        this._allUsersField = value;
        return this;
    }

    public boolean hasAllGroups() {
        if (this._allGroupsField != null) {
            return true;
        }
        return this._map.containsKey("allGroups");
    }

    public void removeAllGroups() {
        this._map.remove("allGroups");
    }

    @Nullable
    public Boolean isAllGroups(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isAllGroups();
            }
            case NULL: {
                if (this._allGroupsField != null) {
                    return this._allGroupsField;
                }
                Object __rawValue = this._map.get("allGroups");
                this._allGroupsField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._allGroupsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isAllGroups() {
        if (this._allGroupsField != null) {
            return this._allGroupsField;
        }
        Object __rawValue = this._map.get("allGroups");
        if (__rawValue == null) {
            return DEFAULT_AllGroups;
        }
        this._allGroupsField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._allGroupsField;
    }

    public DataHubActorFilter setAllGroups(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAllGroups(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field allGroups of com.linkedin.policy.DataHubActorFilter");
                }
                CheckedUtil.putWithoutChecking(this._map, "allGroups", value);
                this._allGroupsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAllGroups();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "allGroups", value);
                this._allGroupsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "allGroups", value);
                this._allGroupsField = value;
            }
        }
        return this;
    }

    public DataHubActorFilter setAllGroups(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field allGroups of com.linkedin.policy.DataHubActorFilter to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "allGroups", value);
        this._allGroupsField = value;
        return this;
    }

    public DataHubActorFilter setAllGroups(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "allGroups", value);
        this._allGroupsField = value;
        return this;
    }

    public boolean hasRoles() {
        if (this._rolesField != null) {
            return true;
        }
        return this._map.containsKey("roles");
    }

    public void removeRoles() {
        this._map.remove("roles");
    }

    @Nullable
    public UrnArray getRoles(GetMode mode) {
        return this.getRoles();
    }

    @Nullable
    public UrnArray getRoles() {
        if (this._rolesField != null) {
            return this._rolesField;
        }
        Object __rawValue = this._map.get("roles");
        this._rolesField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._rolesField;
    }

    public DataHubActorFilter setRoles(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRoles(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRoles();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "roles", value.data());
                this._rolesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "roles", value.data());
                this._rolesField = value;
            }
        }
        return this;
    }

    public DataHubActorFilter setRoles(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field roles of com.linkedin.policy.DataHubActorFilter to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "roles", value.data());
        this._rolesField = value;
        return this;
    }

    @Override
    public DataHubActorFilter clone() throws CloneNotSupportedException {
        DataHubActorFilter __clone = (DataHubActorFilter)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataHubActorFilter copy() throws CloneNotSupportedException {
        DataHubActorFilter __copy = (DataHubActorFilter)super.copy();
        __copy._resourceOwnersField = null;
        __copy._resourceOwnersTypesField = null;
        __copy._allUsersField = null;
        __copy._allGroupsField = null;
        __copy._rolesField = null;
        __copy._groupsField = null;
        __copy._usersField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_ResourceOwnersTypes = SCHEMA.getField("resourceOwnersTypes");
        FIELD_AllUsers = SCHEMA.getField("allUsers");
        FIELD_AllGroups = SCHEMA.getField("allGroups");
        FIELD_Roles = SCHEMA.getField("roles");
        DEFAULT_ResourceOwners = DataTemplateUtil.coerceBooleanOutput(FIELD_ResourceOwners.getDefault());
        DEFAULT_AllUsers = DataTemplateUtil.coerceBooleanOutput(FIELD_AllUsers.getDefault());
        DEFAULT_AllGroups = DataTemplateUtil.coerceBooleanOutput(FIELD_AllGroups.getDefault());
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataHubActorFilter __objectRef;

        private ChangeListener(DataHubActorFilter reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "resourceOwners": {
                    this.__objectRef._resourceOwnersField = null;
                    break;
                }
                case "resourceOwnersTypes": {
                    this.__objectRef._resourceOwnersTypesField = null;
                    break;
                }
                case "allUsers": {
                    this.__objectRef._allUsersField = null;
                    break;
                }
                case "allGroups": {
                    this.__objectRef._allGroupsField = null;
                    break;
                }
                case "roles": {
                    this.__objectRef._rolesField = null;
                    break;
                }
                case "groups": {
                    this.__objectRef._groupsField = null;
                    break;
                }
                case "users": {
                    this.__objectRef._usersField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec users() {
            return new PathSpec(this.getPathComponents(), "users");
        }

        public PathSpec users(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "users");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec groups() {
            return new PathSpec(this.getPathComponents(), "groups");
        }

        public PathSpec groups(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "groups");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec resourceOwners() {
            return new PathSpec(this.getPathComponents(), "resourceOwners");
        }

        public PathSpec resourceOwnersTypes() {
            return new PathSpec(this.getPathComponents(), "resourceOwnersTypes");
        }

        public PathSpec resourceOwnersTypes(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "resourceOwnersTypes");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec allUsers() {
            return new PathSpec(this.getPathComponents(), "allUsers");
        }

        public PathSpec allGroups() {
            return new PathSpec(this.getPathComponents(), "allGroups");
        }

        public PathSpec roles() {
            return new PathSpec(this.getPathComponents(), "roles");
        }

        public PathSpec roles(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "roles");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(10);
        }

        public ProjectionMask withUsers() {
            this.getDataMap().put("users", 1);
            return this;
        }

        public ProjectionMask withUsers(Integer start, Integer count) {
            this.getDataMap().put("users", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("users").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("users").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withGroups() {
            this.getDataMap().put("groups", 1);
            return this;
        }

        public ProjectionMask withGroups(Integer start, Integer count) {
            this.getDataMap().put("groups", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("groups").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("groups").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withResourceOwners() {
            this.getDataMap().put("resourceOwners", 1);
            return this;
        }

        public ProjectionMask withResourceOwnersTypes() {
            this.getDataMap().put("resourceOwnersTypes", 1);
            return this;
        }

        public ProjectionMask withResourceOwnersTypes(Integer start, Integer count) {
            this.getDataMap().put("resourceOwnersTypes", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("resourceOwnersTypes").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("resourceOwnersTypes").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withAllUsers() {
            this.getDataMap().put("allUsers", 1);
            return this;
        }

        public ProjectionMask withAllGroups() {
            this.getDataMap().put("allGroups", 1);
            return this;
        }

        public ProjectionMask withRoles() {
            this.getDataMap().put("roles", 1);
            return this;
        }

        public ProjectionMask withRoles(Integer start, Integer count) {
            this.getDataMap().put("roles", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("roles").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("roles").put("$count", count);
            }
            return this;
        }
    }
}

