/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ml.metadata;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.ml.metadata.MLMetric;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class MLMetricArray
extends WrappingArrayTemplate<MLMetric> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.ml.metadata/**Properties associated with an ML Metric*/@Aspect.name=\"mlMetric\"record MLMetric{/**Name of the mlMetric*/name:string/**Documentation of the mlMetric*/description:optional string/**The value of the mlMetric*/value:optional string/**Date when the mlMetric was developed*/createdAt:optional{namespace com.linkedin.common/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long}}}]", SchemaFormatType.PDL);

    public MLMetricArray() {
        this(new DataList());
    }

    public MLMetricArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public MLMetricArray(Collection<MLMetric> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public MLMetricArray(DataList data) {
        super(data, SCHEMA, MLMetric.class);
    }

    public MLMetricArray(MLMetric first, MLMetric ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public MLMetricArray clone() throws CloneNotSupportedException {
        MLMetricArray __clone = (MLMetricArray)super.clone();
        return __clone;
    }

    @Override
    public MLMetricArray copy() throws CloneNotSupportedException {
        MLMetricArray __copy = (MLMetricArray)super.copy();
        return __copy;
    }

    @Override
    protected MLMetric coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new MLMetric(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private MLMetric.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<MLMetric.ProjectionMask, MLMetric.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? MLMetric.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public MLMetric.Fields items() {
            return new MLMetric.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

