/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils.metrics;

import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.AtomicDouble;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricUtils.class);
    public static final String DROPWIZARD_METRIC = "dwizMetric";
    public static final String DROPWIZARD_NAME = "dwizName";
    public static final String KAFKA_MESSAGE_QUEUE_TIME = "kafka.message.queue.time";
    public static final String DATAHUB_REQUEST_HOOK_QUEUE_TIME = "datahub.request.hook.queue.time";
    public static final String DATAHUB_REQUEST_COUNT = "datahub_request_count";
    public static final String CACHE_HIT_ATTR = "cache.hit";
    public static final String BATCH_SIZE_ATTR = "batch.size";
    public static final String QUEUE_ENQUEUED_AT_ATTR = "queue.enqueued_at";
    public static final String QUEUE_DURATION_MS_ATTR = "queue.duration_ms";
    public static final String MESSAGING_SYSTEM = "messaging.system";
    public static final String MESSAGING_DESTINATION = "messaging.destination";
    public static final String MESSAGING_DESTINATION_KIND = "messaging.destination_kind";
    public static final String MESSAGING_OPERATION = "messaging.operation";
    public static final String ERROR_TYPE = "error.type";
    public static final String CHANGE_TYPE = "aspect.change_type";
    public static final String ENTITY_TYPE = "aspect.entity_type";
    public static final String ASPECT_NAME = "aspect.name";
    @Deprecated
    public static final String DELIMITER = "_";
    @NonNull
    private final MeterRegistry registry;
    private static final Map<String, Timer> legacyTimeCache = new ConcurrentHashMap<String, Timer>();
    private static final Map<String, Counter> legacyCounterCache = new ConcurrentHashMap<String, Counter>();
    private static final Map<String, DistributionSummary> legacyHistogramCache = new ConcurrentHashMap<String, DistributionSummary>();
    private static final Map<String, Gauge> legacyGaugeCache = new ConcurrentHashMap<String, Gauge>();
    private static final Map<String, Counter> micrometerCounterCache = new ConcurrentHashMap<String, Counter>();
    private static final Map<String, AtomicDouble> gaugeStates = new ConcurrentHashMap<String, AtomicDouble>();

    public MeterRegistry getRegistry() {
        return this.registry;
    }

    @Deprecated
    public void time(String dropWizardMetricName, long durationNanos) {
        Timer timer = legacyTimeCache.computeIfAbsent(dropWizardMetricName, name -> Timer.builder((String)name).tags(new String[]{DROPWIZARD_METRIC, "true"}).register(this.registry));
        timer.record(durationNanos, TimeUnit.NANOSECONDS);
    }

    @Deprecated
    public void increment(Class<?> klass, String metricName, double increment) {
        String name = MetricRegistry.name(klass, (String[])new String[]{metricName});
        this.increment(name, increment);
    }

    @Deprecated
    public void exceptionIncrement(Class<?> klass, String metricName, Throwable t2) {
        String[] splitClassName = t2.getClass().getName().split("[.]");
        String snakeCase = splitClassName[splitClassName.length - 1].replaceAll("([A-Z][a-z])", "_$1");
        this.increment(klass, metricName, 1.0);
        this.increment(klass, metricName + DELIMITER + snakeCase, 1.0);
    }

    @Deprecated
    public void increment(String metricName, double increment) {
        Counter counter = legacyCounterCache.computeIfAbsent(metricName, name -> Counter.builder((String)MetricRegistry.name((String)name, (String[])new String[0])).tag(DROPWIZARD_METRIC, "true").register(this.registry));
        counter.increment(increment);
    }

    public void incrementMicrometer(String metricName, double increment, String ... tags) {
        String cacheKey = this.createCacheKey(metricName, tags);
        Counter counter = micrometerCounterCache.computeIfAbsent(cacheKey, key -> this.registry.counter(metricName, tags));
        counter.increment(increment);
    }

    private String createCacheKey(String metricName, String ... tags) {
        if (tags.length == 0) {
            return metricName;
        }
        StringBuilder keyBuilder = new StringBuilder(metricName);
        for (int i = 0; i < tags.length; i += 2) {
            if (i + 1 >= tags.length) continue;
            keyBuilder.append("|").append(tags[i]).append("=").append(tags[i + 1]);
        }
        return keyBuilder.toString();
    }

    @Deprecated
    public void setGaugeValue(Class<?> clazz, String metricName, double value) {
        String name = MetricRegistry.name(clazz, (String[])new String[]{metricName});
        AtomicDouble state = gaugeStates.computeIfAbsent(name, k -> new AtomicDouble(0.0));
        legacyGaugeCache.computeIfAbsent(name, key -> Gauge.builder((String)key, (Object)state, AtomicDouble::get).tag(DROPWIZARD_METRIC, "true").register(this.registry));
        state.set(value);
    }

    @Deprecated
    public void histogram(Class<?> clazz, String metricName, long value) {
        String name = MetricRegistry.name(clazz, (String[])new String[]{metricName});
        DistributionSummary summary = legacyHistogramCache.computeIfAbsent(name, key -> DistributionSummary.builder((String)key).tag(DROPWIZARD_METRIC, "true").register(this.registry));
        summary.record((double)value);
    }

    @Deprecated
    public static String name(String name, String ... names) {
        return MetricRegistry.name((String)name, (String[])names);
    }

    @Deprecated
    public static String name(Class<?> clazz, String ... names) {
        return MetricRegistry.name((String)clazz.getName(), (String[])names);
    }

    public static double[] parsePercentiles(String percentilesConfig) {
        if (percentilesConfig == null || percentilesConfig.trim().isEmpty()) {
            return new double[]{0.5, 0.95, 0.99};
        }
        return MetricUtils.commaDelimitedDoubles(percentilesConfig);
    }

    public static double[] parseSLOSeconds(String sloConfig) {
        if (sloConfig == null || sloConfig.trim().isEmpty()) {
            return new double[]{60.0, 300.0, 900.0, 1800.0, 3600.0};
        }
        return MetricUtils.commaDelimitedDoubles(sloConfig);
    }

    private static double[] commaDelimitedDoubles(String value) {
        String[] parts = value.split(",");
        double[] result = new double[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            result[i] = Double.parseDouble(parts[i].trim());
        }
        return result;
    }

    @Generated
    private static MeterRegistry $default$registry() {
        return new CompositeMeterRegistry();
    }

    @Generated
    MetricUtils(@NonNull MeterRegistry registry) {
        if (registry == null) {
            throw new NullPointerException("registry is marked non-null but is null");
        }
        this.registry = registry;
    }

    @Generated
    public static MetricUtilsBuilder builder() {
        return new MetricUtilsBuilder();
    }

    @Generated
    public static class MetricUtilsBuilder {
        @Generated
        private boolean registry$set;
        @Generated
        private MeterRegistry registry$value;

        @Generated
        MetricUtilsBuilder() {
        }

        @Generated
        public MetricUtilsBuilder registry(@NonNull MeterRegistry registry) {
            if (registry == null) {
                throw new NullPointerException("registry is marked non-null but is null");
            }
            this.registry$value = registry;
            this.registry$set = true;
            return this;
        }

        @Generated
        public MetricUtils build() {
            MeterRegistry registry$value = this.registry$value;
            if (!this.registry$set) {
                registry$value = MetricUtils.$default$registry();
            }
            return new MetricUtils(registry$value);
        }

        @Generated
        public String toString() {
            return "MetricUtils.MetricUtilsBuilder(registry$value=" + String.valueOf(this.registry$value) + ")";
        }
    }
}

