/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils;

import com.linkedin.data.template.StringArray;
import com.linkedin.metadata.query.filter.Condition;
import com.linkedin.metadata.query.filter.ConjunctiveCriterion;
import com.linkedin.metadata.query.filter.Criterion;
import com.linkedin.metadata.query.filter.CriterionArray;
import com.linkedin.metadata.query.filter.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriterionUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CriterionUtils.class);

    private CriterionUtils() {
    }

    @Nullable
    public static Filter validateAndConvert(@Nullable Filter inputFilter) {
        if (inputFilter != null) {
            ArrayList invalidCriterion = new ArrayList();
            if (inputFilter.hasCriteria()) {
                invalidCriterion.addAll(inputFilter.getCriteria().stream().filter(criterion -> criterion.hasValue() && !criterion.getValue().isEmpty() || !criterion.hasValue()).collect(Collectors.toList()));
            }
            if (inputFilter.hasOr()) {
                invalidCriterion.addAll(inputFilter.getOr().stream().flatMap(c -> c.getAnd().stream()).filter(criterion -> criterion.hasValue() && !criterion.getValue().isEmpty() || !criterion.hasValue()).collect(Collectors.toList()));
            }
            for (Criterion criterion2 : invalidCriterion) {
                if (criterion2.hasValue()) {
                    if (criterion2.getValue().contains(",") && !criterion2.getValue().startsWith("urn:li:") || criterion2.getValue().contains("),urn:li:")) {
                        throw new IllegalArgumentException("Criterion `value` is deprecated and contains an ambiguous comma. Please use `values`.");
                    }
                    if (criterion2.hasValues() && !criterion2.getValue().equals(criterion2.getValues().get(0))) {
                        throw new IllegalArgumentException("Criterion `value` is deprecated and `values`[0] is populated with a conflicting value.");
                    }
                    if (!criterion2.hasValues()) {
                        log.error("Deprecated use of a filter using Criterion's `value` has been detected and corrected. Please migrate to `values` instead.");
                        criterion2.setValues(new StringArray(criterion2.getValue(), new String[0]));
                    }
                }
                criterion2.setValue("");
            }
        }
        return inputFilter;
    }

    public static Criterion buildExistsCriterion(@Nonnull String field) {
        return CriterionUtils.buildCriterion(field, Condition.EXISTS, (Boolean)false, Collections.emptyList());
    }

    public static Criterion buildNotExistsCriterion(@Nonnull String field) {
        return CriterionUtils.buildCriterion(field, Condition.EXISTS, (Boolean)true, Collections.emptyList());
    }

    public static Criterion buildIsNullCriterion(@Nonnull String field) {
        return CriterionUtils.buildCriterion(field, Condition.IS_NULL, (Boolean)false, Collections.emptyList());
    }

    public static Criterion buildIsNotNullCriterion(@Nonnull String field) {
        return CriterionUtils.buildCriterion(field, Condition.IS_NULL, (Boolean)true, Collections.emptyList());
    }

    public static Criterion buildCriterion(@Nonnull String field, @Nonnull Condition condition, String ... values) {
        return CriterionUtils.buildCriterion(field, condition, null, values == null ? Collections.emptyList() : (Collection)Arrays.stream(values).collect(Collectors.toList()));
    }

    public static Criterion buildCriterion(@Nonnull String field, @Nonnull Condition condition, Collection<String> values) {
        return CriterionUtils.buildCriterion(field, condition, (Boolean)false, values);
    }

    public static Criterion buildCriterion(@Nonnull String field, @Nonnull Condition condition, boolean negated, String ... values) {
        return CriterionUtils.buildCriterion(field, condition, (Boolean)negated, values == null ? Collections.emptyList() : (Collection)Arrays.stream(values).collect(Collectors.toList()));
    }

    public static Criterion buildCriterion(@Nonnull String field, @Nonnull Condition condition, Boolean negated, Collection<String> values) {
        Criterion criterion = new Criterion();
        criterion.setField(field);
        criterion.setCondition(condition);
        criterion.setNegated(negated != null ? negated : false);
        criterion.setValues(values != null ? new StringArray(values) : new StringArray());
        criterion.setValue("");
        return criterion;
    }

    public static ConjunctiveCriterion buildConjunctiveCriterion(Criterion ... criteria) {
        ConjunctiveCriterion conjunctiveCriterion = new ConjunctiveCriterion();
        conjunctiveCriterion.setAnd(new CriterionArray(Arrays.stream(criteria).collect(Collectors.toList())));
        return conjunctiveCriterion;
    }
}

