/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.query;

import com.linkedin.common.UrnArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ListUrnsResult
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.query/**The model for listing a set of entity urns.*/record ListUrnsResult{/**A list of entities returned from the list*/entities:array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]/**Offset of the first entity in the result*/start:int/**Size of each page in the result*/count:int/**The total number of entities directly under searched path*/total:int}", SchemaFormatType.PDL);
    private UrnArray _entitiesField = null;
    private Integer _startField = null;
    private Integer _countField = null;
    private Integer _totalField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Entities = SCHEMA.getField("entities");
    private static final RecordDataSchema.Field FIELD_Start = SCHEMA.getField("start");
    private static final RecordDataSchema.Field FIELD_Count = SCHEMA.getField("count");
    private static final RecordDataSchema.Field FIELD_Total = SCHEMA.getField("total");

    public ListUrnsResult() {
        super(new DataMap(6, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public ListUrnsResult(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasEntities() {
        if (this._entitiesField != null) {
            return true;
        }
        return this._map.containsKey("entities");
    }

    public void removeEntities() {
        this._map.remove("entities");
    }

    @Nullable
    public UrnArray getEntities(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEntities();
            }
            case DEFAULT: 
            case NULL: {
                if (this._entitiesField != null) {
                    return this._entitiesField;
                }
                Object __rawValue = this._map.get("entities");
                this._entitiesField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._entitiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public UrnArray getEntities() {
        if (this._entitiesField != null) {
            return this._entitiesField;
        }
        Object __rawValue = this._map.get("entities");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("entities");
        }
        this._entitiesField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._entitiesField;
    }

    public ListUrnsResult setEntities(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntities(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field entities of com.linkedin.metadata.query.ListUrnsResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
                this._entitiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntities();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
                this._entitiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
                this._entitiesField = value;
            }
        }
        return this;
    }

    public ListUrnsResult setEntities(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entities of com.linkedin.metadata.query.ListUrnsResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
        this._entitiesField = value;
        return this;
    }

    public boolean hasStart() {
        if (this._startField != null) {
            return true;
        }
        return this._map.containsKey("start");
    }

    public void removeStart() {
        this._map.remove("start");
    }

    @Nullable
    public Integer getStart(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getStart();
            }
            case DEFAULT: 
            case NULL: {
                if (this._startField != null) {
                    return this._startField;
                }
                Object __rawValue = this._map.get("start");
                this._startField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._startField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getStart() {
        if (this._startField != null) {
            return this._startField;
        }
        Object __rawValue = this._map.get("start");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("start");
        }
        this._startField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._startField;
    }

    public ListUrnsResult setStart(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStart(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field start of com.linkedin.metadata.query.ListUrnsResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "start", DataTemplateUtil.coerceIntInput(value));
                this._startField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStart();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "start", DataTemplateUtil.coerceIntInput(value));
                this._startField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "start", DataTemplateUtil.coerceIntInput(value));
                this._startField = value;
            }
        }
        return this;
    }

    public ListUrnsResult setStart(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field start of com.linkedin.metadata.query.ListUrnsResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "start", DataTemplateUtil.coerceIntInput(value));
        this._startField = value;
        return this;
    }

    public ListUrnsResult setStart(int value) {
        CheckedUtil.putWithoutChecking(this._map, "start", DataTemplateUtil.coerceIntInput(value));
        this._startField = value;
        return this;
    }

    public boolean hasCount() {
        if (this._countField != null) {
            return true;
        }
        return this._map.containsKey("count");
    }

    public void removeCount() {
        this._map.remove("count");
    }

    @Nullable
    public Integer getCount(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCount();
            }
            case DEFAULT: 
            case NULL: {
                if (this._countField != null) {
                    return this._countField;
                }
                Object __rawValue = this._map.get("count");
                this._countField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._countField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getCount() {
        if (this._countField != null) {
            return this._countField;
        }
        Object __rawValue = this._map.get("count");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("count");
        }
        this._countField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._countField;
    }

    public ListUrnsResult setCount(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field count of com.linkedin.metadata.query.ListUrnsResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "count", DataTemplateUtil.coerceIntInput(value));
                this._countField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "count", DataTemplateUtil.coerceIntInput(value));
                this._countField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "count", DataTemplateUtil.coerceIntInput(value));
                this._countField = value;
            }
        }
        return this;
    }

    public ListUrnsResult setCount(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field count of com.linkedin.metadata.query.ListUrnsResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "count", DataTemplateUtil.coerceIntInput(value));
        this._countField = value;
        return this;
    }

    public ListUrnsResult setCount(int value) {
        CheckedUtil.putWithoutChecking(this._map, "count", DataTemplateUtil.coerceIntInput(value));
        this._countField = value;
        return this;
    }

    public boolean hasTotal() {
        if (this._totalField != null) {
            return true;
        }
        return this._map.containsKey("total");
    }

    public void removeTotal() {
        this._map.remove("total");
    }

    @Nullable
    public Integer getTotal(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTotal();
            }
            case DEFAULT: 
            case NULL: {
                if (this._totalField != null) {
                    return this._totalField;
                }
                Object __rawValue = this._map.get("total");
                this._totalField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._totalField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getTotal() {
        if (this._totalField != null) {
            return this._totalField;
        }
        Object __rawValue = this._map.get("total");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("total");
        }
        this._totalField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._totalField;
    }

    public ListUrnsResult setTotal(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTotal(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field total of com.linkedin.metadata.query.ListUrnsResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "total", DataTemplateUtil.coerceIntInput(value));
                this._totalField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTotal();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "total", DataTemplateUtil.coerceIntInput(value));
                this._totalField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "total", DataTemplateUtil.coerceIntInput(value));
                this._totalField = value;
            }
        }
        return this;
    }

    public ListUrnsResult setTotal(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field total of com.linkedin.metadata.query.ListUrnsResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "total", DataTemplateUtil.coerceIntInput(value));
        this._totalField = value;
        return this;
    }

    public ListUrnsResult setTotal(int value) {
        CheckedUtil.putWithoutChecking(this._map, "total", DataTemplateUtil.coerceIntInput(value));
        this._totalField = value;
        return this;
    }

    @Override
    public ListUrnsResult clone() throws CloneNotSupportedException {
        ListUrnsResult __clone = (ListUrnsResult)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public ListUrnsResult copy() throws CloneNotSupportedException {
        ListUrnsResult __copy = (ListUrnsResult)super.copy();
        __copy._totalField = null;
        __copy._entitiesField = null;
        __copy._startField = null;
        __copy._countField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final ListUrnsResult __objectRef;

        private ChangeListener(ListUrnsResult reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "total": {
                    this.__objectRef._totalField = null;
                    break;
                }
                case "entities": {
                    this.__objectRef._entitiesField = null;
                    break;
                }
                case "start": {
                    this.__objectRef._startField = null;
                    break;
                }
                case "count": {
                    this.__objectRef._countField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec entities() {
            return new PathSpec(this.getPathComponents(), "entities");
        }

        public PathSpec entities(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "entities");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec start() {
            return new PathSpec(this.getPathComponents(), "start");
        }

        public PathSpec count() {
            return new PathSpec(this.getPathComponents(), "count");
        }

        public PathSpec total() {
            return new PathSpec(this.getPathComponents(), "total");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withEntities() {
            this.getDataMap().put("entities", 1);
            return this;
        }

        public ProjectionMask withEntities(Integer start, Integer count) {
            this.getDataMap().put("entities", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("entities").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("entities").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withStart() {
            this.getDataMap().put("start", 1);
            return this;
        }

        public ProjectionMask withCount() {
            this.getDataMap().put("count", 1);
            return this;
        }

        public ProjectionMask withTotal() {
            this.getDataMap().put("total", 1);
            return this;
        }
    }
}

