/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.plugins.validation;

import com.linkedin.common.urn.Urn;
import com.linkedin.metadata.aspect.batch.BatchItem;
import com.linkedin.metadata.aspect.plugins.validation.AspectValidationException;
import com.linkedin.metadata.aspect.plugins.validation.ValidationSubType;
import com.linkedin.util.Pair;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ValidationExceptionCollection
extends HashMap<Pair<Urn, String>, Set<AspectValidationException>> {
    private final Map<ValidationSubType, Set<Integer>> subTypeHashCodes = new HashMap<ValidationSubType, Set<Integer>>();

    public boolean hasFatalExceptions() {
        return this.subTypeHashCodes.keySet().stream().anyMatch(subType -> !ValidationSubType.FILTER.equals(subType));
    }

    public Set<ValidationSubType> getSubTypes() {
        return this.subTypeHashCodes.keySet();
    }

    public static ValidationExceptionCollection newCollection() {
        return new ValidationExceptionCollection();
    }

    public void addException(AspectValidationException exception) {
        super.computeIfAbsent(exception.getAspectGroup(), key -> new HashSet()).add(exception);
        this.subTypeHashCodes.computeIfAbsent(exception.getSubType(), key -> new HashSet()).add(exception.getItem().hashCode());
    }

    public void addException(BatchItem item, String message) {
        this.addException(item, message, null);
    }

    public void addException(BatchItem item, String message, Exception ex) {
        this.addException(AspectValidationException.forItem(item, message, ex));
    }

    public void addAuthException(BatchItem item, String message) {
        this.addException(AspectValidationException.forAuth(item, message));
    }

    public Stream<AspectValidationException> streamAllExceptions() {
        return this.values().stream().flatMap(Collection::stream);
    }

    public <T extends BatchItem> Collection<T> successful(Collection<T> items) {
        return this.streamSuccessful(items.stream()).collect(Collectors.toList());
    }

    public <T extends BatchItem> Stream<T> streamSuccessful(Stream<T> items) {
        return items.filter(i -> this.isSuccessful(i.hashCode()));
    }

    public <T extends BatchItem> Collection<T> exceptions(Collection<T> items) {
        return this.streamExceptions(items.stream()).collect(Collectors.toList());
    }

    public <T extends BatchItem> Stream<T> streamExceptions(Stream<T> items) {
        return items.filter(i -> this.isException(i.hashCode()));
    }

    private boolean isException(int hashCode) {
        return this.subTypeHashCodes.keySet().stream().filter(subType -> !ValidationSubType.FILTER.equals(subType)).anyMatch(subType -> this.subTypeHashCodes.get(subType).contains(hashCode));
    }

    private boolean isSuccessful(int hashCode) {
        return !this.isException(hashCode) && (!this.subTypeHashCodes.containsKey((Object)ValidationSubType.FILTER) || !this.subTypeHashCodes.get((Object)ValidationSubType.FILTER).contains(hashCode));
    }

    @Override
    public String toString() {
        return String.format("ValidationExceptionCollection{%s}", this.entrySet().stream().sorted(Comparator.comparing(p -> ((Pair)p.getKey()).toString())).map(e -> String.format("EntityAspect:%s Exceptions: %s", ((Pair)e.getKey()).toString(), e.getValue())).collect(Collectors.joining("; ")));
    }
}

