/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.plugins.config;

import com.linkedin.metadata.aspect.plugins.config.AspectPluginConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class PluginConfiguration {
    private static final String[] VALIDATOR_PACKAGES = new String[]{"com.linkedin.metadata.aspect.plugins.validation", "com.linkedin.metadata.aspect.validation"};
    private static final String[] HOOK_PACKAGES = new String[]{"com.linkedin.metadata.aspect.plugins.hooks", "com.linkedin.metadata.aspect.hooks"};
    private List<AspectPluginConfig> aspectPayloadValidators = Collections.emptyList();
    private List<AspectPluginConfig> mutationHooks = Collections.emptyList();
    private List<AspectPluginConfig> mclSideEffects = Collections.emptyList();
    private List<AspectPluginConfig> mcpSideEffects = Collections.emptyList();
    public static PluginConfiguration EMPTY = new PluginConfiguration();

    public boolean isEmpty() {
        return this.aspectPayloadValidators.isEmpty() && this.mutationHooks.isEmpty() && this.mclSideEffects.isEmpty() && this.mcpSideEffects.isEmpty();
    }

    public static PluginConfiguration merge(PluginConfiguration a, PluginConfiguration b) {
        return new PluginConfiguration(Stream.concat(a.getAspectPayloadValidators().stream(), b.getAspectPayloadValidators().stream()).collect(Collectors.toList()), Stream.concat(a.getMutationHooks().stream(), b.getMutationHooks().stream()).collect(Collectors.toList()), Stream.concat(a.getMclSideEffects().stream(), b.getMclSideEffects().stream()).collect(Collectors.toList()), Stream.concat(a.getMcpSideEffects().stream(), b.getMcpSideEffects().stream()).collect(Collectors.toList()));
    }

    public Stream<AspectPluginConfig> streamAll() {
        return Stream.concat(Stream.concat(Stream.concat(this.aspectPayloadValidators.stream(), this.mutationHooks.stream()), this.mclSideEffects.stream()), this.mcpSideEffects.stream());
    }

    public List<String> validatorPackages() {
        return this.aspectPayloadValidators.stream().flatMap(cfg -> cfg.getPackageScan() != null ? cfg.getPackageScan().stream() : Arrays.stream(VALIDATOR_PACKAGES)).distinct().collect(Collectors.toList());
    }

    public List<String> mcpSideEffectPackages() {
        return this.mcpSideEffects.stream().flatMap(cfg -> cfg.getPackageScan() != null ? cfg.getPackageScan().stream() : Arrays.stream(HOOK_PACKAGES)).distinct().collect(Collectors.toList());
    }

    public List<String> mclSideEffectPackages() {
        return this.mclSideEffects.stream().flatMap(cfg -> cfg.getPackageScan() != null ? cfg.getPackageScan().stream() : Arrays.stream(HOOK_PACKAGES)).distinct().collect(Collectors.toList());
    }

    public List<String> mutationPackages() {
        return this.mutationHooks.stream().flatMap(cfg -> cfg.getPackageScan() != null ? cfg.getPackageScan().stream() : Arrays.stream(HOOK_PACKAGES)).distinct().collect(Collectors.toList());
    }

    @Generated
    public List<AspectPluginConfig> getAspectPayloadValidators() {
        return this.aspectPayloadValidators;
    }

    @Generated
    public List<AspectPluginConfig> getMutationHooks() {
        return this.mutationHooks;
    }

    @Generated
    public List<AspectPluginConfig> getMclSideEffects() {
        return this.mclSideEffects;
    }

    @Generated
    public List<AspectPluginConfig> getMcpSideEffects() {
        return this.mcpSideEffects;
    }

    @Generated
    public void setAspectPayloadValidators(List<AspectPluginConfig> aspectPayloadValidators) {
        this.aspectPayloadValidators = aspectPayloadValidators;
    }

    @Generated
    public void setMutationHooks(List<AspectPluginConfig> mutationHooks) {
        this.mutationHooks = mutationHooks;
    }

    @Generated
    public void setMclSideEffects(List<AspectPluginConfig> mclSideEffects) {
        this.mclSideEffects = mclSideEffects;
    }

    @Generated
    public void setMcpSideEffects(List<AspectPluginConfig> mcpSideEffects) {
        this.mcpSideEffects = mcpSideEffects;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginConfiguration)) {
            return false;
        }
        PluginConfiguration other = (PluginConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<AspectPluginConfig> this$aspectPayloadValidators = this.getAspectPayloadValidators();
        List<AspectPluginConfig> other$aspectPayloadValidators = other.getAspectPayloadValidators();
        if (this$aspectPayloadValidators == null ? other$aspectPayloadValidators != null : !((Object)this$aspectPayloadValidators).equals(other$aspectPayloadValidators)) {
            return false;
        }
        List<AspectPluginConfig> this$mutationHooks = this.getMutationHooks();
        List<AspectPluginConfig> other$mutationHooks = other.getMutationHooks();
        if (this$mutationHooks == null ? other$mutationHooks != null : !((Object)this$mutationHooks).equals(other$mutationHooks)) {
            return false;
        }
        List<AspectPluginConfig> this$mclSideEffects = this.getMclSideEffects();
        List<AspectPluginConfig> other$mclSideEffects = other.getMclSideEffects();
        if (this$mclSideEffects == null ? other$mclSideEffects != null : !((Object)this$mclSideEffects).equals(other$mclSideEffects)) {
            return false;
        }
        List<AspectPluginConfig> this$mcpSideEffects = this.getMcpSideEffects();
        List<AspectPluginConfig> other$mcpSideEffects = other.getMcpSideEffects();
        return !(this$mcpSideEffects == null ? other$mcpSideEffects != null : !((Object)this$mcpSideEffects).equals(other$mcpSideEffects));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PluginConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<AspectPluginConfig> $aspectPayloadValidators = this.getAspectPayloadValidators();
        result = result * 59 + ($aspectPayloadValidators == null ? 43 : ((Object)$aspectPayloadValidators).hashCode());
        List<AspectPluginConfig> $mutationHooks = this.getMutationHooks();
        result = result * 59 + ($mutationHooks == null ? 43 : ((Object)$mutationHooks).hashCode());
        List<AspectPluginConfig> $mclSideEffects = this.getMclSideEffects();
        result = result * 59 + ($mclSideEffects == null ? 43 : ((Object)$mclSideEffects).hashCode());
        List<AspectPluginConfig> $mcpSideEffects = this.getMcpSideEffects();
        result = result * 59 + ($mcpSideEffects == null ? 43 : ((Object)$mcpSideEffects).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PluginConfiguration(aspectPayloadValidators=" + String.valueOf(this.getAspectPayloadValidators()) + ", mutationHooks=" + String.valueOf(this.getMutationHooks()) + ", mclSideEffects=" + String.valueOf(this.getMclSideEffects()) + ", mcpSideEffects=" + String.valueOf(this.getMcpSideEffects()) + ")";
    }

    @Generated
    public PluginConfiguration(List<AspectPluginConfig> aspectPayloadValidators, List<AspectPluginConfig> mutationHooks, List<AspectPluginConfig> mclSideEffects, List<AspectPluginConfig> mcpSideEffects) {
        this.aspectPayloadValidators = aspectPayloadValidators;
        this.mutationHooks = mutationHooks;
        this.mclSideEffects = mclSideEffects;
        this.mcpSideEffects = mcpSideEffects;
    }

    @Generated
    public PluginConfiguration() {
    }
}

