/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect;

import com.linkedin.common.GlobalTags;
import com.linkedin.common.Status;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.HasTyperefInfo;
import com.linkedin.data.template.TyperefInfo;
import com.linkedin.data.template.UnionTemplate;
import com.linkedin.identity.CorpUserEditableInfo;
import com.linkedin.identity.CorpUserInfo;
import com.linkedin.identity.CorpUserStatus;
import com.linkedin.identity.GroupMembership;
import com.linkedin.metadata.key.CorpUserKey;
import java.util.List;
import java.util.function.Function;

public class CorpUserAspect
extends UnionTemplate
implements HasTyperefInfo {
    private static final UnionDataSchema SCHEMA = (UnionDataSchema)DataTemplateUtil.parseSchema("union[{namespace com.linkedin.metadata.key/**Key for a CorpUser*/@Aspect.name=\"corpUserKey\"record CorpUserKey{/**The name of the AD/LDAP user.*/@Searchable={\"boostScore\":2.0,\"enableAutocomplete\":true,\"fieldName\":\"ldap\",\"fieldType\":\"WORD_GRAM\"}username:string}}{namespace com.linkedin.identity/**Linkedin corp user information*/@Aspect={\"EntityUrns\":[\"com.linkedin.common.CorpuserUrn\"],\"name\":\"corpUserInfo\"}record CorpUserInfo includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{/**Deprecated! Use CorpUserStatus instead. Whether the corpUser is active, ref: https://iwww.corp.linkedin.com/wiki/cf/display/GTSD/Accessing+Active+Directory+via+LDAP+tools*/@Searchable={\"fieldType\":\"BOOLEAN\",\"weightsPerFieldValue\":{\"true\":2.0}}active:boolean/**displayName of this user ,  e.g.  Hang Zhang(DataHQ)*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\",\"queryByDefault\":true}displayName:optional string/**email address of this user*/@Searchable={\"fieldType\":\"KEYWORD\",\"queryByDefault\":true}email:optional{namespace com.linkedin.common,typeref EmailAddress=string}/**title of this user*/@Searchable={\"fieldType\":\"KEYWORD\",\"queryByDefault\":true}title:optional string/**direct manager of this user*/@Relationship={\"entityTypes\":[\"corpuser\"],\"name\":\"ReportsTo\"}@Searchable={\"fieldName\":\"managerLdap\",\"fieldType\":\"URN\",\"queryByDefault\":false}managerUrn:optional{namespace com.linkedin.common/**Corporate user's AD/LDAP login*/@java.class=\"com.linkedin.common.urn.CorpuserUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Corporate user's AD/LDAP login\",\"entityType\":\"corpuser\",\"fields\":[{\"doc\":\"The name of the AD/LDAP user.\",\"maxLength\":20,\"name\":\"username\",\"type\":\"string\"}],\"maxLength\":36,\"name\":\"Corpuser\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:security\"}typeref CorpuserUrn=string}/**department id this user belong to*/departmentId:optional long/**department name this user belong to*/departmentName:optional string/**first name of this user*/firstName:optional string/**last name of this user*/lastName:optional string/**Common name of this user, format is firstName + lastName (split by a whitespace)*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\",\"queryByDefault\":true}fullName:optional string/**two uppercase letters country code. e.g.  US*/countryCode:optional string/**Whether the corpUser is a system user.*/@Searchable={\"fieldType\":\"BOOLEAN\",\"queryByDefault\":false}system:optional boolean=false}}{namespace com.linkedin.identity/**Linkedin corp user information that can be edited from UI*/@Aspect={\"EntityUrns\":[\"com.linkedin.common.CorpuserUrn\"],\"name\":\"corpUserEditableInfo\"}record CorpUserEditableInfo{/**About me section of the user*/aboutMe:optional string/**Teams that the user belongs to e.g. Metadata*/@Searchable.`/*`.fieldType=\"TEXT\"teams:array[string]=[]/**Skills that the user possesses e.g. Machine Learning*/@Searchable.`/*`.fieldType=\"TEXT\"skills:array[string]=[]/**A URL which points to a picture which user wants to set as a profile photo*/pictureLink:{namespace com.linkedin.common@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}=\"assets/platforms/default_avatar.png\"/**DataHub-native display name*/@Searchable={\"boostScore\":10.0,\"fieldType\":\"WORD_GRAM\",\"queryByDefault\":true}displayName:optional string/**DataHub-native Title, e.g. 'Software Engineer'*/title:optional string/**The platforms that the user commonly works with*/@Relationship.`/*`={\"entityTypes\":[\"dataPlatform\"],\"name\":\"IsUserOf\"}platforms:optional array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]/**The user's persona type, based on their role*/@Relationship={\"entityTypes\":[\"dataHubPersona\"],\"name\":\"IsPersona\"}persona:optional com.linkedin.common.Urn/**Slack handle for the user*/slack:optional string/**Phone number to contact the user*/phone:optional string/**Email address to contact the user*/email:optional string/**Information sources that have been used to populate this CorpUserEditableInfo.\nThese include platform resources, such as Slack members or Looker users.\nThey can also refer to other semantic urns in the future.*/informationSources:optional array[com.linkedin.common.Urn]}}{namespace com.linkedin.identity/**The status of the user, e.g. provisioned, active, suspended, etc.*/@Aspect.name=\"corpUserStatus\"record CorpUserStatus{/**Status of the user, e.g. PROVISIONED / ACTIVE / SUSPENDED*/@Searchable.fieldType=\"KEYWORD\"status:string/**Audit stamp containing who last modified the status and when.*/@Searchable.`/time`={\"fieldName\":\"statusLastModifiedAt\",\"fieldType\":\"COUNT\"}lastModified:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}}}{namespace com.linkedin.identity/**Carries information about the CorpGroups a user is in.*/@Aspect.name=\"groupMembership\"record GroupMembership{@Relationship.`/*`={\"entityTypes\":[\"corpGroup\"],\"name\":\"IsMemberOfGroup\"}groups:array[com.linkedin.common.Urn]}}{namespace com.linkedin.common/**Tag aspect used for applying tags to an entity*/@Aspect.name=\"globalTags\"record GlobalTags{/**Tags associated with a given entity*/@Relationship.`/*/tag`={\"entityTypes\":[\"tag\"],\"name\":\"TaggedWith\"}@Searchable.`/*/tag`={\"addToFilters\":true,\"boostScore\":0.5,\"fieldName\":\"tags\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Tag\",\"hasValuesFieldName\":\"hasTags\",\"queryByDefault\":true}tags:array[/**Properties of an applied tag. For now, just an Urn. In the future we can extend this with other properties, e.g.\npropagation parameters.*/record TagAssociation{/**Urn of the applied tag*/tag:/**Globally defined tag*/@java.class=\"com.linkedin.common.urn.TagUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Globally defined tags\",\"entityType\":\"tag\",\"fields\":[{\"doc\":\"tag name\",\"maxLength\":200,\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":220,\"name\":\"Tag\",\"namespace\":\"li\",\"owners\":[],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref TagUrn=string/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"tagAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"tagAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"tagAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:Time/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:Urn/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}]}}{namespace com.linkedin.common/**The lifecycle status metadata of an entity, e.g. dataset, metric, feature, etc.\nThis aspect is used to represent soft deletes conventionally.*/@Aspect.name=\"status\"record Status{/**Whether the entity has been removed (soft-deleted).*/@Searchable.fieldType=\"BOOLEAN\"removed:boolean=false}}]", SchemaFormatType.PDL);
    private CorpUserKey _corpUserKeyMember = null;
    private CorpUserInfo _corpUserInfoMember = null;
    private CorpUserEditableInfo _corpUserEditableInfoMember = null;
    private CorpUserStatus _corpUserStatusMember = null;
    private GroupMembership _groupMembershipMember = null;
    private GlobalTags _globalTagsMember = null;
    private Status _statusMember = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final DataSchema MEMBER_CorpUserKey = SCHEMA.getTypeByMemberKey("com.linkedin.metadata.key.CorpUserKey");
    public static final String MEMBERKEY_CorpUserKey = "com.linkedin.metadata.key.CorpUserKey";
    private static final DataSchema MEMBER_CorpUserInfo = SCHEMA.getTypeByMemberKey("com.linkedin.identity.CorpUserInfo");
    public static final String MEMBERKEY_CorpUserInfo = "com.linkedin.identity.CorpUserInfo";
    private static final DataSchema MEMBER_CorpUserEditableInfo = SCHEMA.getTypeByMemberKey("com.linkedin.identity.CorpUserEditableInfo");
    public static final String MEMBERKEY_CorpUserEditableInfo = "com.linkedin.identity.CorpUserEditableInfo";
    private static final DataSchema MEMBER_CorpUserStatus = SCHEMA.getTypeByMemberKey("com.linkedin.identity.CorpUserStatus");
    public static final String MEMBERKEY_CorpUserStatus = "com.linkedin.identity.CorpUserStatus";
    private static final DataSchema MEMBER_GroupMembership = SCHEMA.getTypeByMemberKey("com.linkedin.identity.GroupMembership");
    public static final String MEMBERKEY_GroupMembership = "com.linkedin.identity.GroupMembership";
    private static final DataSchema MEMBER_GlobalTags = SCHEMA.getTypeByMemberKey("com.linkedin.common.GlobalTags");
    public static final String MEMBERKEY_GlobalTags = "com.linkedin.common.GlobalTags";
    private static final DataSchema MEMBER_Status = SCHEMA.getTypeByMemberKey("com.linkedin.common.Status");
    public static final String MEMBERKEY_Status = "com.linkedin.common.Status";
    private static final TyperefInfo TYPEREFINFO = new UnionTyperefInfo();

    public CorpUserAspect() {
        super(new DataMap(2, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public CorpUserAspect(Object data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static UnionDataSchema dataSchema() {
        return SCHEMA;
    }

    public static CorpUserAspect create(CorpUserKey value) {
        CorpUserAspect newUnion = new CorpUserAspect();
        newUnion.setCorpUserKey(value);
        return newUnion;
    }

    public boolean isCorpUserKey() {
        return this.memberIs(MEMBERKEY_CorpUserKey);
    }

    public CorpUserKey getCorpUserKey() {
        this.checkNotNull();
        if (this._corpUserKeyMember != null) {
            return this._corpUserKeyMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_CorpUserKey);
        this._corpUserKeyMember = __rawValue == null ? null : new CorpUserKey(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._corpUserKeyMember;
    }

    public void setCorpUserKey(CorpUserKey value) {
        this.checkNotNull();
        this._map.clear();
        this._corpUserKeyMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_CorpUserKey, value.data());
    }

    public static CorpUserAspect create(CorpUserInfo value) {
        CorpUserAspect newUnion = new CorpUserAspect();
        newUnion.setCorpUserInfo(value);
        return newUnion;
    }

    public boolean isCorpUserInfo() {
        return this.memberIs(MEMBERKEY_CorpUserInfo);
    }

    public CorpUserInfo getCorpUserInfo() {
        this.checkNotNull();
        if (this._corpUserInfoMember != null) {
            return this._corpUserInfoMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_CorpUserInfo);
        this._corpUserInfoMember = __rawValue == null ? null : new CorpUserInfo(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._corpUserInfoMember;
    }

    public void setCorpUserInfo(CorpUserInfo value) {
        this.checkNotNull();
        this._map.clear();
        this._corpUserInfoMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_CorpUserInfo, value.data());
    }

    public static CorpUserAspect create(CorpUserEditableInfo value) {
        CorpUserAspect newUnion = new CorpUserAspect();
        newUnion.setCorpUserEditableInfo(value);
        return newUnion;
    }

    public boolean isCorpUserEditableInfo() {
        return this.memberIs(MEMBERKEY_CorpUserEditableInfo);
    }

    public CorpUserEditableInfo getCorpUserEditableInfo() {
        this.checkNotNull();
        if (this._corpUserEditableInfoMember != null) {
            return this._corpUserEditableInfoMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_CorpUserEditableInfo);
        this._corpUserEditableInfoMember = __rawValue == null ? null : new CorpUserEditableInfo(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._corpUserEditableInfoMember;
    }

    public void setCorpUserEditableInfo(CorpUserEditableInfo value) {
        this.checkNotNull();
        this._map.clear();
        this._corpUserEditableInfoMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_CorpUserEditableInfo, value.data());
    }

    public static CorpUserAspect create(CorpUserStatus value) {
        CorpUserAspect newUnion = new CorpUserAspect();
        newUnion.setCorpUserStatus(value);
        return newUnion;
    }

    public boolean isCorpUserStatus() {
        return this.memberIs(MEMBERKEY_CorpUserStatus);
    }

    public CorpUserStatus getCorpUserStatus() {
        this.checkNotNull();
        if (this._corpUserStatusMember != null) {
            return this._corpUserStatusMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_CorpUserStatus);
        this._corpUserStatusMember = __rawValue == null ? null : new CorpUserStatus(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._corpUserStatusMember;
    }

    public void setCorpUserStatus(CorpUserStatus value) {
        this.checkNotNull();
        this._map.clear();
        this._corpUserStatusMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_CorpUserStatus, value.data());
    }

    public static CorpUserAspect create(GroupMembership value) {
        CorpUserAspect newUnion = new CorpUserAspect();
        newUnion.setGroupMembership(value);
        return newUnion;
    }

    public boolean isGroupMembership() {
        return this.memberIs(MEMBERKEY_GroupMembership);
    }

    public GroupMembership getGroupMembership() {
        this.checkNotNull();
        if (this._groupMembershipMember != null) {
            return this._groupMembershipMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_GroupMembership);
        this._groupMembershipMember = __rawValue == null ? null : new GroupMembership(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._groupMembershipMember;
    }

    public void setGroupMembership(GroupMembership value) {
        this.checkNotNull();
        this._map.clear();
        this._groupMembershipMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_GroupMembership, value.data());
    }

    public static CorpUserAspect create(GlobalTags value) {
        CorpUserAspect newUnion = new CorpUserAspect();
        newUnion.setGlobalTags(value);
        return newUnion;
    }

    public boolean isGlobalTags() {
        return this.memberIs(MEMBERKEY_GlobalTags);
    }

    public GlobalTags getGlobalTags() {
        this.checkNotNull();
        if (this._globalTagsMember != null) {
            return this._globalTagsMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_GlobalTags);
        this._globalTagsMember = __rawValue == null ? null : new GlobalTags(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._globalTagsMember;
    }

    public void setGlobalTags(GlobalTags value) {
        this.checkNotNull();
        this._map.clear();
        this._globalTagsMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_GlobalTags, value.data());
    }

    public static CorpUserAspect create(Status value) {
        CorpUserAspect newUnion = new CorpUserAspect();
        newUnion.setStatus(value);
        return newUnion;
    }

    public boolean isStatus() {
        return this.memberIs(MEMBERKEY_Status);
    }

    public Status getStatus() {
        this.checkNotNull();
        if (this._statusMember != null) {
            return this._statusMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_Status);
        this._statusMember = __rawValue == null ? null : new Status(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._statusMember;
    }

    public void setStatus(Status value) {
        this.checkNotNull();
        this._map.clear();
        this._statusMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_Status, value.data());
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public CorpUserAspect clone() throws CloneNotSupportedException {
        CorpUserAspect __clone = (CorpUserAspect)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public CorpUserAspect copy() throws CloneNotSupportedException {
        CorpUserAspect __copy = (CorpUserAspect)super.copy();
        __copy._corpUserStatusMember = null;
        __copy._corpUserKeyMember = null;
        __copy._globalTagsMember = null;
        __copy._corpUserInfoMember = null;
        __copy._corpUserEditableInfoMember = null;
        __copy._groupMembershipMember = null;
        __copy._statusMember = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    @Override
    public TyperefInfo typerefInfo() {
        return TYPEREFINFO;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final CorpUserAspect __objectRef;

        private ChangeListener(CorpUserAspect reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "com.linkedin.identity.CorpUserStatus": {
                    this.__objectRef._corpUserStatusMember = null;
                    break;
                }
                case "com.linkedin.metadata.key.CorpUserKey": {
                    this.__objectRef._corpUserKeyMember = null;
                    break;
                }
                case "com.linkedin.common.GlobalTags": {
                    this.__objectRef._globalTagsMember = null;
                    break;
                }
                case "com.linkedin.identity.CorpUserInfo": {
                    this.__objectRef._corpUserInfoMember = null;
                    break;
                }
                case "com.linkedin.identity.CorpUserEditableInfo": {
                    this.__objectRef._corpUserEditableInfoMember = null;
                    break;
                }
                case "com.linkedin.identity.GroupMembership": {
                    this.__objectRef._groupMembershipMember = null;
                    break;
                }
                case "com.linkedin.common.Status": {
                    this.__objectRef._statusMember = null;
                }
            }
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private CorpUserKey.ProjectionMask _CorpUserKeyMask;
        private CorpUserInfo.ProjectionMask _CorpUserInfoMask;
        private CorpUserEditableInfo.ProjectionMask _CorpUserEditableInfoMask;
        private CorpUserStatus.ProjectionMask _CorpUserStatusMask;
        private GroupMembership.ProjectionMask _GroupMembershipMask;
        private GlobalTags.ProjectionMask _GlobalTagsMask;
        private Status.ProjectionMask _StatusMask;

        ProjectionMask() {
            super(10);
        }

        public ProjectionMask withCorpUserKey(Function<CorpUserKey.ProjectionMask, CorpUserKey.ProjectionMask> nestedMask) {
            this._CorpUserKeyMask = nestedMask.apply(this._CorpUserKeyMask == null ? CorpUserKey.createMask() : this._CorpUserKeyMask);
            this.getDataMap().put(CorpUserAspect.MEMBERKEY_CorpUserKey, this._CorpUserKeyMask.getDataMap());
            return this;
        }

        public ProjectionMask withCorpUserInfo(Function<CorpUserInfo.ProjectionMask, CorpUserInfo.ProjectionMask> nestedMask) {
            this._CorpUserInfoMask = nestedMask.apply(this._CorpUserInfoMask == null ? CorpUserInfo.createMask() : this._CorpUserInfoMask);
            this.getDataMap().put(CorpUserAspect.MEMBERKEY_CorpUserInfo, this._CorpUserInfoMask.getDataMap());
            return this;
        }

        public ProjectionMask withCorpUserEditableInfo(Function<CorpUserEditableInfo.ProjectionMask, CorpUserEditableInfo.ProjectionMask> nestedMask) {
            this._CorpUserEditableInfoMask = nestedMask.apply(this._CorpUserEditableInfoMask == null ? CorpUserEditableInfo.createMask() : this._CorpUserEditableInfoMask);
            this.getDataMap().put(CorpUserAspect.MEMBERKEY_CorpUserEditableInfo, this._CorpUserEditableInfoMask.getDataMap());
            return this;
        }

        public ProjectionMask withCorpUserStatus(Function<CorpUserStatus.ProjectionMask, CorpUserStatus.ProjectionMask> nestedMask) {
            this._CorpUserStatusMask = nestedMask.apply(this._CorpUserStatusMask == null ? CorpUserStatus.createMask() : this._CorpUserStatusMask);
            this.getDataMap().put(CorpUserAspect.MEMBERKEY_CorpUserStatus, this._CorpUserStatusMask.getDataMap());
            return this;
        }

        public ProjectionMask withGroupMembership(Function<GroupMembership.ProjectionMask, GroupMembership.ProjectionMask> nestedMask) {
            this._GroupMembershipMask = nestedMask.apply(this._GroupMembershipMask == null ? GroupMembership.createMask() : this._GroupMembershipMask);
            this.getDataMap().put(CorpUserAspect.MEMBERKEY_GroupMembership, this._GroupMembershipMask.getDataMap());
            return this;
        }

        public ProjectionMask withGlobalTags(Function<GlobalTags.ProjectionMask, GlobalTags.ProjectionMask> nestedMask) {
            this._GlobalTagsMask = nestedMask.apply(this._GlobalTagsMask == null ? GlobalTags.createMask() : this._GlobalTagsMask);
            this.getDataMap().put(CorpUserAspect.MEMBERKEY_GlobalTags, this._GlobalTagsMask.getDataMap());
            return this;
        }

        public ProjectionMask withStatus(Function<Status.ProjectionMask, Status.ProjectionMask> nestedMask) {
            this._StatusMask = nestedMask.apply(this._StatusMask == null ? Status.createMask() : this._StatusMask);
            this.getDataMap().put(CorpUserAspect.MEMBERKEY_Status, this._StatusMask.getDataMap());
            return this;
        }
    }

    private static final class UnionTyperefInfo
    extends TyperefInfo {
        private static final TyperefDataSchema SCHEMA = (TyperefDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a CorpUser*/typeref CorpUserAspect=union[{namespace com.linkedin.metadata.key/**Key for a CorpUser*/@Aspect.name=\"corpUserKey\"record CorpUserKey{/**The name of the AD/LDAP user.*/@Searchable={\"boostScore\":2.0,\"enableAutocomplete\":true,\"fieldName\":\"ldap\",\"fieldType\":\"WORD_GRAM\"}username:string}}{namespace com.linkedin.identity/**Linkedin corp user information*/@Aspect={\"EntityUrns\":[\"com.linkedin.common.CorpuserUrn\"],\"name\":\"corpUserInfo\"}record CorpUserInfo includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{/**Deprecated! Use CorpUserStatus instead. Whether the corpUser is active, ref: https://iwww.corp.linkedin.com/wiki/cf/display/GTSD/Accessing+Active+Directory+via+LDAP+tools*/@Searchable={\"fieldType\":\"BOOLEAN\",\"weightsPerFieldValue\":{\"true\":2.0}}active:boolean/**displayName of this user ,  e.g.  Hang Zhang(DataHQ)*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\",\"queryByDefault\":true}displayName:optional string/**email address of this user*/@Searchable={\"fieldType\":\"KEYWORD\",\"queryByDefault\":true}email:optional{namespace com.linkedin.common,typeref EmailAddress=string}/**title of this user*/@Searchable={\"fieldType\":\"KEYWORD\",\"queryByDefault\":true}title:optional string/**direct manager of this user*/@Relationship={\"entityTypes\":[\"corpuser\"],\"name\":\"ReportsTo\"}@Searchable={\"fieldName\":\"managerLdap\",\"fieldType\":\"URN\",\"queryByDefault\":false}managerUrn:optional{namespace com.linkedin.common/**Corporate user's AD/LDAP login*/@java.class=\"com.linkedin.common.urn.CorpuserUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Corporate user's AD/LDAP login\",\"entityType\":\"corpuser\",\"fields\":[{\"doc\":\"The name of the AD/LDAP user.\",\"maxLength\":20,\"name\":\"username\",\"type\":\"string\"}],\"maxLength\":36,\"name\":\"Corpuser\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:security\"}typeref CorpuserUrn=string}/**department id this user belong to*/departmentId:optional long/**department name this user belong to*/departmentName:optional string/**first name of this user*/firstName:optional string/**last name of this user*/lastName:optional string/**Common name of this user, format is firstName + lastName (split by a whitespace)*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\",\"queryByDefault\":true}fullName:optional string/**two uppercase letters country code. e.g.  US*/countryCode:optional string/**Whether the corpUser is a system user.*/@Searchable={\"fieldType\":\"BOOLEAN\",\"queryByDefault\":false}system:optional boolean=false}}{namespace com.linkedin.identity/**Linkedin corp user information that can be edited from UI*/@Aspect={\"EntityUrns\":[\"com.linkedin.common.CorpuserUrn\"],\"name\":\"corpUserEditableInfo\"}record CorpUserEditableInfo{/**About me section of the user*/aboutMe:optional string/**Teams that the user belongs to e.g. Metadata*/@Searchable.`/*`.fieldType=\"TEXT\"teams:array[string]=[]/**Skills that the user possesses e.g. Machine Learning*/@Searchable.`/*`.fieldType=\"TEXT\"skills:array[string]=[]/**A URL which points to a picture which user wants to set as a profile photo*/pictureLink:{namespace com.linkedin.common@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}=\"assets/platforms/default_avatar.png\"/**DataHub-native display name*/@Searchable={\"boostScore\":10.0,\"fieldType\":\"WORD_GRAM\",\"queryByDefault\":true}displayName:optional string/**DataHub-native Title, e.g. 'Software Engineer'*/title:optional string/**The platforms that the user commonly works with*/@Relationship.`/*`={\"entityTypes\":[\"dataPlatform\"],\"name\":\"IsUserOf\"}platforms:optional array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]/**The user's persona type, based on their role*/@Relationship={\"entityTypes\":[\"dataHubPersona\"],\"name\":\"IsPersona\"}persona:optional com.linkedin.common.Urn/**Slack handle for the user*/slack:optional string/**Phone number to contact the user*/phone:optional string/**Email address to contact the user*/email:optional string/**Information sources that have been used to populate this CorpUserEditableInfo.\nThese include platform resources, such as Slack members or Looker users.\nThey can also refer to other semantic urns in the future.*/informationSources:optional array[com.linkedin.common.Urn]}}{namespace com.linkedin.identity/**The status of the user, e.g. provisioned, active, suspended, etc.*/@Aspect.name=\"corpUserStatus\"record CorpUserStatus{/**Status of the user, e.g. PROVISIONED / ACTIVE / SUSPENDED*/@Searchable.fieldType=\"KEYWORD\"status:string/**Audit stamp containing who last modified the status and when.*/@Searchable.`/time`={\"fieldName\":\"statusLastModifiedAt\",\"fieldType\":\"COUNT\"}lastModified:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}}}{namespace com.linkedin.identity/**Carries information about the CorpGroups a user is in.*/@Aspect.name=\"groupMembership\"record GroupMembership{@Relationship.`/*`={\"entityTypes\":[\"corpGroup\"],\"name\":\"IsMemberOfGroup\"}groups:array[com.linkedin.common.Urn]}}{namespace com.linkedin.common/**Tag aspect used for applying tags to an entity*/@Aspect.name=\"globalTags\"record GlobalTags{/**Tags associated with a given entity*/@Relationship.`/*/tag`={\"entityTypes\":[\"tag\"],\"name\":\"TaggedWith\"}@Searchable.`/*/tag`={\"addToFilters\":true,\"boostScore\":0.5,\"fieldName\":\"tags\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Tag\",\"hasValuesFieldName\":\"hasTags\",\"queryByDefault\":true}tags:array[/**Properties of an applied tag. For now, just an Urn. In the future we can extend this with other properties, e.g.\npropagation parameters.*/record TagAssociation{/**Urn of the applied tag*/tag:/**Globally defined tag*/@java.class=\"com.linkedin.common.urn.TagUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Globally defined tags\",\"entityType\":\"tag\",\"fields\":[{\"doc\":\"tag name\",\"maxLength\":200,\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":220,\"name\":\"Tag\",\"namespace\":\"li\",\"owners\":[],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref TagUrn=string/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"tagAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"tagAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"tagAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:Time/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:Urn/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}]}}{namespace com.linkedin.common/**The lifecycle status metadata of an entity, e.g. dataset, metric, feature, etc.\nThis aspect is used to represent soft deletes conventionally.*/@Aspect.name=\"status\"record Status{/**Whether the entity has been removed (soft-deleted).*/@Searchable.fieldType=\"BOOLEAN\"removed:boolean=false}}]", SchemaFormatType.PDL);

        public UnionTyperefInfo() {
            super(SCHEMA);
        }

        public static TyperefDataSchema dataSchema() {
            return SCHEMA;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public CorpUserKey.Fields CorpUserKey() {
            return new CorpUserKey.Fields(this.getPathComponents(), CorpUserAspect.MEMBERKEY_CorpUserKey);
        }

        public CorpUserInfo.Fields CorpUserInfo() {
            return new CorpUserInfo.Fields(this.getPathComponents(), CorpUserAspect.MEMBERKEY_CorpUserInfo);
        }

        public CorpUserEditableInfo.Fields CorpUserEditableInfo() {
            return new CorpUserEditableInfo.Fields(this.getPathComponents(), CorpUserAspect.MEMBERKEY_CorpUserEditableInfo);
        }

        public CorpUserStatus.Fields CorpUserStatus() {
            return new CorpUserStatus.Fields(this.getPathComponents(), CorpUserAspect.MEMBERKEY_CorpUserStatus);
        }

        public GroupMembership.Fields GroupMembership() {
            return new GroupMembership.Fields(this.getPathComponents(), CorpUserAspect.MEMBERKEY_GroupMembership);
        }

        public GlobalTags.Fields GlobalTags() {
            return new GlobalTags.Fields(this.getPathComponents(), CorpUserAspect.MEMBERKEY_GlobalTags);
        }

        public Status.Fields Status() {
            return new Status.Fields(this.getPathComponents(), CorpUserAspect.MEMBERKEY_Status);
        }
    }
}

