/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataset;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.dataset.Quantile;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class QuantileArray
extends WrappingArrayTemplate<Quantile> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.dataset,record Quantile{quantile:string,value:string}}]", SchemaFormatType.PDL);

    public QuantileArray() {
        this(new DataList());
    }

    public QuantileArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public QuantileArray(Collection<Quantile> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public QuantileArray(DataList data) {
        super(data, SCHEMA, Quantile.class);
    }

    public QuantileArray(Quantile first, Quantile ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public QuantileArray clone() throws CloneNotSupportedException {
        QuantileArray __clone = (QuantileArray)super.clone();
        return __clone;
    }

    @Override
    public QuantileArray copy() throws CloneNotSupportedException {
        QuantileArray __copy = (QuantileArray)super.copy();
        return __copy;
    }

    @Override
    protected Quantile coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new Quantile(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private Quantile.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<Quantile.ProjectionMask, Quantile.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? Quantile.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public Quantile.Fields items() {
            return new Quantile.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

