/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMapBuilder;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.template.AbstractArrayTemplate;
import com.linkedin.data.template.DataObjectToObjectCache;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.util.ArgumentUtil;
import java.lang.reflect.Constructor;

public class WrappingArrayTemplate<E extends DataTemplate<?>>
extends AbstractArrayTemplate<E> {
    private Constructor<E> _constructor;
    protected DataObjectToObjectCache<E> _cache;

    protected WrappingArrayTemplate(DataList list, ArrayDataSchema schema, Class<E> elementClass) throws TemplateOutputCastException {
        super(list, schema, elementClass, DataTemplateUtil.getDataClass(schema.getItems()));
        this._cache = new DataObjectToObjectCache(DataMapBuilder.getOptimumHashMapCapacityFromSize(list.size()));
    }

    @Override
    public boolean add(E element) throws ClassCastException {
        boolean result = CheckedUtil.addWithoutChecking(this._list, this.unwrap(element));
        ++this.modCount;
        return result;
    }

    @Override
    public void add(int index, E element) throws ClassCastException {
        CheckedUtil.addWithoutChecking(this._list, index, this.unwrap(element));
        ++this.modCount;
    }

    @Override
    public E get(int index) throws TemplateOutputCastException {
        return this.cacheLookup(this._list.get(index), index);
    }

    @Override
    public E remove(int index) throws TemplateOutputCastException {
        Object removed = this._list.remove(index);
        ++this.modCount;
        return this.cacheLookup(removed, -1);
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        this._list.removeRange(fromIndex, toIndex);
        ++this.modCount;
    }

    @Override
    public E set(int index, E element) throws ClassCastException, TemplateOutputCastException {
        Object replaced = CheckedUtil.setWithoutChecking(this._list, index, this.unwrap(element));
        ++this.modCount;
        return this.cacheLookup(replaced, -1);
    }

    @Override
    public WrappingArrayTemplate<E> clone() throws CloneNotSupportedException {
        WrappingArrayTemplate clone = (WrappingArrayTemplate)super.clone();
        clone._cache = clone._cache.clone();
        return clone;
    }

    @Override
    public WrappingArrayTemplate<E> copy() throws CloneNotSupportedException {
        WrappingArrayTemplate copy = (WrappingArrayTemplate)super.copy();
        copy._cache = new DataObjectToObjectCache(copy.data().size());
        return copy;
    }

    protected Object unwrap(E object) throws ClassCastException {
        ArgumentUtil.notNull(object, "object");
        if (object.getClass() == this._elementClass) {
            return object.data();
        }
        throw new ClassCastException("Input " + object + " should be a " + this._elementClass.getName());
    }

    protected E cacheLookup(Object object, int index) throws TemplateOutputCastException {
        assert (object != null);
        DataTemplate wrapped = (DataTemplate)this._cache.get(object);
        if (wrapped == null || wrapped.data() != object) {
            wrapped = this.coerceOutput(object);
            if (index != -1) {
                this._cache.put(object, wrapped);
            }
        }
        return (E)wrapped;
    }

    protected E coerceOutput(Object value) throws TemplateOutputCastException {
        if (this._constructor == null) {
            this._constructor = DataTemplateUtil.templateConstructor(this._elementClass, this.schema().getItems());
        }
        return DataTemplateUtil.wrap(value, this._constructor);
    }
}

