/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.resolver;

import com.linkedin.data.schema.DataSchemaParserFactory;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.SchemaParserFactory;
import com.linkedin.data.schema.resolver.AbstractMultiFormatDataSchemaResolver;
import com.linkedin.data.schema.resolver.DefaultDataSchemaResolver;
import com.linkedin.data.schema.resolver.FileDataSchemaLocation;
import com.linkedin.data.schema.resolver.SchemaDirectory;
import com.linkedin.data.schema.resolver.SchemaDirectoryName;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ClasspathResourceDataSchemaResolver
extends AbstractMultiFormatDataSchemaResolver {
    @Deprecated
    public static final String DEFAULT_EXTENSION = ".pdsc";
    private final ClassLoader _classLoader;

    public ClasspathResourceDataSchemaResolver() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ClasspathResourceDataSchemaResolver(SchemaDirectoryName schemaDirectoryName) {
        this(Thread.currentThread().getContextClassLoader(), schemaDirectoryName);
    }

    @Deprecated
    public ClasspathResourceDataSchemaResolver(SchemaParserFactory parserFactory) {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ClasspathResourceDataSchemaResolver(ClassLoader classLoader) {
        for (DataSchemaParserFactory parserForFormat : BUILTIN_FORMAT_PARSER_FACTORIES) {
            this.addResolver(new SingleFormatClasspathSchemaResolver(parserForFormat));
        }
        this._classLoader = classLoader;
    }

    @Deprecated
    public ClasspathResourceDataSchemaResolver(ClassLoader classLoader, SchemaDirectoryName schemaDirectoryName) {
        ArrayList<SchemaDirectory> schemaDirectories = new ArrayList<SchemaDirectory>();
        schemaDirectories.add(schemaDirectoryName);
        if (schemaDirectoryName == SchemaDirectoryName.EXTENSIONS) {
            schemaDirectories.add(SchemaDirectoryName.PEGASUS);
        }
        for (DataSchemaParserFactory parserForFormat : BUILTIN_FORMAT_PARSER_FACTORIES) {
            SingleFormatClasspathSchemaResolver resolver = new SingleFormatClasspathSchemaResolver(parserForFormat);
            resolver.setSchemaDirectories(schemaDirectories);
            this.addResolver(resolver);
        }
        this._classLoader = classLoader;
        this.setSchemaDirectories(schemaDirectories);
    }

    public ClasspathResourceDataSchemaResolver(ClassLoader classLoader, List<SchemaDirectory> schemaDirectories) {
        for (DataSchemaParserFactory parserForFormat : BUILTIN_FORMAT_PARSER_FACTORIES) {
            SingleFormatClasspathSchemaResolver resolver = new SingleFormatClasspathSchemaResolver(parserForFormat);
            resolver.setSchemaDirectories(schemaDirectories);
            this.addResolver(resolver);
        }
        this._classLoader = classLoader;
        this.setSchemaDirectories(schemaDirectories);
    }

    @Override
    public SchemaDirectoryName getSchemasDirectoryName() {
        assert (this.getSchemaDirectories().size() > 0);
        return (SchemaDirectoryName)this.getSchemaDirectories().get(0);
    }

    @Deprecated
    public ClasspathResourceDataSchemaResolver(SchemaParserFactory parserFactory, ClassLoader classLoader) {
        this(classLoader);
    }

    private class SingleFormatClasspathSchemaResolver
    extends DefaultDataSchemaResolver {
        private final String _extension;

        public SingleFormatClasspathSchemaResolver(DataSchemaParserFactory parserFactory) {
            super(parserFactory, ClasspathResourceDataSchemaResolver.this);
            this._extension = "." + parserFactory.getLanguageExtension();
        }

        @Deprecated
        public SingleFormatClasspathSchemaResolver(DataSchemaParserFactory parserFactory, SchemaDirectoryName schemaDirectoryName) {
            super(parserFactory, ClasspathResourceDataSchemaResolver.this);
            this._extension = "." + parserFactory.getLanguageExtension();
            this.setSchemaDirectories(Collections.singletonList(schemaDirectoryName));
        }

        private Collection<String> getDataSchemaResourcePaths(String schemaName) {
            ArrayList<String> resourcePaths = new ArrayList<String>(this.getSchemaDirectories().size());
            this.getSchemaDirectories().forEach(directory -> resourcePaths.add(directory.getName() + "/" + schemaName.replace('.', '/') + this._extension));
            return resourcePaths;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected NamedDataSchema locateDataSchema(String schemaName, StringBuilder errorMessageBuilder) {
            Iterator<String> iterator = this.getDataSchemaResourcePaths(schemaName).iterator();
            while (iterator.hasNext()) {
                String schemaResourcePath = iterator.next();
                try {
                    InputStream stream = ClasspathResourceDataSchemaResolver.this._classLoader.getResourceAsStream(schemaResourcePath);
                    try {
                        if (stream == null) continue;
                        FileDataSchemaLocation location = new FileDataSchemaLocation(new File(schemaResourcePath));
                        NamedDataSchema namedDataSchema = this.parse(stream, location, schemaName, errorMessageBuilder);
                        return namedDataSchema;
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (IOException e) {
                    errorMessageBuilder.append(String.format("Failed to read/close data schema file \"%s\" in classpath: \"%s\"", schemaResourcePath, e.getMessage()));
                }
            }
            return null;
        }
    }
}

