/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.annotation;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.schema.annotation.CurrentSchemaEntryMode;
import com.linkedin.data.schema.annotation.SchemaVisitor;
import com.linkedin.data.schema.annotation.TraverserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class TraverserContextImpl
implements TraverserContext {
    private Boolean _shouldContinue = null;
    private DataSchema _parentSchema;
    private RecordDataSchema.Field _enclosingField;
    private UnionDataSchema.Member _enclosingUnionMember;
    private CurrentSchemaEntryMode _currentSchemaEntryMode;
    private SchemaVisitor.VisitorContext _visitorContext;
    private final DataSchema _originalTopLevelSchema;
    private final DataSchema _currentSchema;
    private final ArrayList<String> _traversePath;
    private final ArrayList<String> _schemaPathSpec;
    private final int _traversePathLimit;
    private final int _schemaPathLimit;

    TraverserContextImpl(DataSchema originalTopLevelSchema, DataSchema currentSchema, SchemaVisitor.VisitorContext visitorContext) {
        this._originalTopLevelSchema = originalTopLevelSchema;
        this._currentSchema = currentSchema;
        this._visitorContext = visitorContext;
        this._traversePath = new ArrayList();
        this._traversePath.add(currentSchema.getUnionMemberKey());
        this._schemaPathSpec = new ArrayList();
        this._traversePathLimit = 1;
        this._schemaPathLimit = 0;
    }

    private TraverserContextImpl(TraverserContextImpl existing, DataSchema nextSchema, int newSchemaPathLimit, int newTraversePathLimit) {
        this._originalTopLevelSchema = existing._originalTopLevelSchema;
        this._currentSchema = nextSchema;
        this._visitorContext = existing._visitorContext;
        this._traversePath = existing._traversePath;
        this._schemaPathSpec = existing._schemaPathSpec;
        this._schemaPathLimit = newSchemaPathLimit;
        this._traversePathLimit = newTraversePathLimit;
    }

    @Override
    public SchemaVisitor.VisitorContext getVisitorContext() {
        return this._visitorContext;
    }

    TraverserContextImpl getNextContext(String nextTraversePathComponent, String nextSchemaPathSpecComponent, DataSchema nextSchema, CurrentSchemaEntryMode nextSchemaEntryMode) {
        boolean hasNextSchemaComponent = nextSchemaPathSpecComponent != null;
        int newSchemaPathLimit = hasNextSchemaComponent ? this._schemaPathLimit + 1 : this._schemaPathLimit;
        TraverserContextImpl nextContext = new TraverserContextImpl(this, nextSchema, newSchemaPathLimit, this._traversePathLimit + 2);
        nextContext.setParentSchema(this.getCurrentSchema());
        nextContext.setEnclosingField(this.getEnclosingField());
        nextContext.setEnclosingUnionMember(this.getEnclosingUnionMember());
        TraverserContextImpl.safeAdd(this._traversePath, this._traversePathLimit, nextTraversePathComponent);
        TraverserContextImpl.safeAdd(this._traversePath, this._traversePathLimit + 1, nextSchema.getUnionMemberKey());
        if (hasNextSchemaComponent) {
            TraverserContextImpl.safeAdd(this._schemaPathSpec, this._schemaPathLimit, nextSchemaPathSpecComponent);
        }
        nextContext.setCurrentSchemaEntryMode(nextSchemaEntryMode);
        return nextContext;
    }

    public Boolean shouldContinue() {
        return this._shouldContinue;
    }

    @Override
    public void setShouldContinue(Boolean shouldContinue) {
        this._shouldContinue = shouldContinue;
    }

    @Override
    public void setVisitorContext(SchemaVisitor.VisitorContext visitorContext) {
        this._visitorContext = visitorContext;
    }

    @Override
    public DataSchema getTopLevelSchema() {
        return this._originalTopLevelSchema;
    }

    @Override
    public List<String> getSchemaPathSpec() {
        return Collections.unmodifiableList(this._schemaPathSpec.subList(0, this._schemaPathLimit));
    }

    @Override
    public DataSchema getCurrentSchema() {
        return this._currentSchema;
    }

    @Override
    public List<String> getTraversePath() {
        return Collections.unmodifiableList(this._traversePath.subList(0, this._traversePathLimit));
    }

    @Override
    public DataSchema getParentSchema() {
        return this._parentSchema;
    }

    private void setParentSchema(DataSchema parentSchema) {
        this._parentSchema = parentSchema;
    }

    @Override
    public RecordDataSchema.Field getEnclosingField() {
        return this._enclosingField;
    }

    void setEnclosingField(RecordDataSchema.Field enclosingField) {
        this._enclosingField = enclosingField;
    }

    @Override
    public UnionDataSchema.Member getEnclosingUnionMember() {
        return this._enclosingUnionMember;
    }

    void setEnclosingUnionMember(UnionDataSchema.Member enclosingUnionMember) {
        this._enclosingUnionMember = enclosingUnionMember;
    }

    @Override
    public CurrentSchemaEntryMode getCurrentSchemaEntryMode() {
        return this._currentSchemaEntryMode;
    }

    private void setCurrentSchemaEntryMode(CurrentSchemaEntryMode currentSchemaEntryMode) {
        this._currentSchemaEntryMode = currentSchemaEntryMode;
    }

    private static void safeAdd(List<String> list, int index, String value) {
        assert (value != null);
        if (index < list.size()) {
            list.set(index, value);
        } else {
            list.add(index, value);
        }
    }
}

