/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.annotation;

import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.schema.annotation.DataSchemaRichContextTraverser;
import com.linkedin.data.schema.annotation.SchemaAnnotationHandler;
import com.linkedin.data.schema.annotation.SchemaAnnotationValidationVisitor;
import com.linkedin.data.schema.annotation.SchemaVisitor;
import com.linkedin.data.schema.annotation.SchemaVisitorTraversalResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaAnnotationProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaAnnotationProcessor.class);

    public static SchemaAnnotationProcessResult process(List<SchemaAnnotationHandler> handlers, DataSchema dataSchema, AnnotationProcessOption options) {
        return SchemaAnnotationProcessor.process(handlers, dataSchema, options, true);
    }

    public static SchemaAnnotationProcessResult process(List<SchemaAnnotationHandler> handlers, DataSchema dataSchema, AnnotationProcessOption options, boolean validateProcessResult) {
        String errorMsgs;
        SchemaVisitorTraversalResult handlerTraverseResult;
        SchemaAnnotationProcessResult processResult = new SchemaAnnotationProcessResult();
        processResult.setResultSchema(dataSchema);
        StringBuilder errorMsgBuilder = new StringBuilder();
        boolean hasResolveError = false;
        for (SchemaAnnotationHandler schemaAnnotationHandler : handlers) {
            DataSchema visitorConstructedSchema;
            LOG.debug("DEBUG:  starting resolving schema annotations using \"{}\" handler", (Object)schemaAnnotationHandler.getAnnotationNamespace());
            DataSchema schemaToProcess = processResult.getResultSchema();
            SchemaVisitor visitor = schemaAnnotationHandler.getVisitor();
            DataSchemaRichContextTraverser traverser = new DataSchemaRichContextTraverser(visitor);
            try {
                traverser.traverse(schemaToProcess);
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Annotation resolution processing failed at \"%s\" handler", schemaAnnotationHandler.getAnnotationNamespace()), e);
            }
            handlerTraverseResult = visitor.getSchemaVisitorTraversalResult();
            if (!handlerTraverseResult.isTraversalSuccessful()) {
                hasResolveError = true;
                errorMsgs = handlerTraverseResult.formatToErrorMessage();
                errorMsgBuilder.append(String.format("Annotation processing encountered errors during resolution in \"%s\" handler. \n", schemaAnnotationHandler.getAnnotationNamespace()));
                errorMsgBuilder.append(errorMsgs);
            }
            if (!handlerTraverseResult.isTraversalSuccessful() && !options.forcePopulateDataSchemaToResult() || (visitorConstructedSchema = handlerTraverseResult.getConstructedSchema()) == null) continue;
            processResult.setResultSchema(visitorConstructedSchema);
        }
        processResult.setResolutionSuccess(!hasResolveError);
        if (!processResult.isResolutionSuccess()) {
            errorMsgBuilder.append("Annotation resolution processing failed at at least one of the handlers.\n");
            processResult.setErrorMsgs(errorMsgBuilder.toString());
            return processResult;
        }
        if (validateProcessResult) {
            boolean hasValidationError = false;
            for (SchemaAnnotationHandler schemaAnnotationHandler : handlers) {
                LOG.debug("DEBUG:  starting validating using \"{}\" handler", (Object)schemaAnnotationHandler.getAnnotationNamespace());
                SchemaAnnotationValidationVisitor validationVisitor = new SchemaAnnotationValidationVisitor(schemaAnnotationHandler);
                DataSchemaRichContextTraverser traverserBase = new DataSchemaRichContextTraverser(validationVisitor);
                try {
                    traverserBase.traverse(processResult.getResultSchema());
                }
                catch (Exception e) {
                    throw new IllegalStateException(String.format("Annotation validation failed in \"%s\" handler.", schemaAnnotationHandler.getAnnotationNamespace()), e);
                }
                handlerTraverseResult = validationVisitor.getSchemaVisitorTraversalResult();
                if (handlerTraverseResult.isTraversalSuccessful()) continue;
                hasValidationError = true;
                errorMsgs = handlerTraverseResult.formatToErrorMessage();
                errorMsgBuilder.append(String.format("Annotation validation process failed in \"%s\" handler. \n", schemaAnnotationHandler.getAnnotationNamespace()));
                errorMsgBuilder.append(errorMsgs);
            }
            processResult.setValidationSuccess(!hasValidationError);
            processResult.setErrorMsgs(errorMsgBuilder.toString());
        } else {
            processResult.setValidationSuccess(true);
        }
        return processResult;
    }

    public static Map<String, Object> getResolvedPropertiesByPath(String pathSpec, DataSchema dataSchema) {
        if (dataSchema == null) {
            throw new IllegalArgumentException("Invalid data schema input");
        }
        if (pathSpec == null || !pathSpec.isEmpty() && !PathSpec.validatePathSpecString(pathSpec)) {
            throw new IllegalArgumentException(String.format("Invalid inputs: PathSpec %s", pathSpec));
        }
        DataSchema dataSchemaToPath = SchemaAnnotationProcessor.findDataSchemaByPath(dataSchema, pathSpec);
        return dataSchemaToPath.getResolvedProperties();
    }

    private static DataSchema findDataSchemaByPath(DataSchema dataSchema, String pathSpec) {
        ArrayList<String> paths = new ArrayList<String>(Arrays.asList(pathSpec.split(Character.toString('/'))));
        paths.remove("");
        DataSchema currentSchema = dataSchema;
        for (String pathSegment : paths) {
            String errorMsg = String.format("Could not find path segment \"%s\" in PathSpec \"%s\"", pathSegment, pathSpec);
            if (currentSchema == null) continue;
            currentSchema = currentSchema.getDereferencedDataSchema();
            switch (currentSchema.getType()) {
                case RECORD: {
                    RecordDataSchema recordDataSchema = (RecordDataSchema)currentSchema;
                    RecordDataSchema.Field field = recordDataSchema.getField(pathSegment);
                    if (field == null) {
                        throw new IllegalArgumentException(errorMsg);
                    }
                    currentSchema = field.getType();
                    break;
                }
                case UNION: {
                    UnionDataSchema unionDataSchema = (UnionDataSchema)currentSchema;
                    DataSchema unionSchema = unionDataSchema.getTypeByMemberKey(pathSegment);
                    if (unionSchema == null) {
                        throw new IllegalArgumentException(errorMsg);
                    }
                    currentSchema = unionSchema;
                    break;
                }
                case MAP: {
                    if (pathSegment.equals(PathSpec.WILDCARD)) {
                        currentSchema = ((MapDataSchema)currentSchema).getValues();
                        break;
                    }
                    if (pathSegment.equals("$key")) {
                        currentSchema = ((MapDataSchema)currentSchema).getKey();
                        break;
                    }
                    throw new IllegalArgumentException(errorMsg);
                }
                case ARRAY: {
                    if (pathSegment.equals(PathSpec.WILDCARD)) {
                        currentSchema = ((ArrayDataSchema)currentSchema).getItems();
                        break;
                    }
                    throw new IllegalArgumentException(errorMsg);
                }
            }
        }
        currentSchema = currentSchema.getDereferencedDataSchema();
        return currentSchema;
    }

    public static class AnnotationProcessOption {
        boolean _forcePopulateResultSchema = false;

        public boolean forcePopulateDataSchemaToResult() {
            return this._forcePopulateResultSchema;
        }

        public void setForcePopulateResultSchema(boolean forcePopulateResultSchema) {
            this._forcePopulateResultSchema = forcePopulateResultSchema;
        }
    }

    public static class SchemaAnnotationProcessResult {
        DataSchema _resultSchema;
        boolean _resolutionSuccess = false;
        boolean _validationSuccess = false;
        String errorMsgs;

        SchemaAnnotationProcessResult() {
        }

        public DataSchema getResultSchema() {
            return this._resultSchema;
        }

        public void setResultSchema(DataSchema resultSchema) {
            this._resultSchema = resultSchema;
        }

        public boolean hasError() {
            return !this._resolutionSuccess || !this._validationSuccess;
        }

        public boolean isResolutionSuccess() {
            return this._resolutionSuccess;
        }

        void setResolutionSuccess(boolean resolutionSuccess) {
            this._resolutionSuccess = resolutionSuccess;
        }

        public boolean isValidationSuccess() {
            return this._validationSuccess;
        }

        public void setValidationSuccess(boolean validationSuccess) {
            this._validationSuccess = validationSuccess;
        }

        public String getErrorMsgs() {
            return this.errorMsgs;
        }

        public void setErrorMsgs(String errorMsgs) {
            this.errorMsgs = errorMsgs;
        }
    }
}

