/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.schema.DataSchema;
import java.util.Collections;
import java.util.Map;

public abstract class ComplexDataSchema
extends DataSchema {
    private boolean _hasError;
    private Map<String, Object> _properties = _emptyProperties;
    private static final Map<String, Object> _emptyProperties = Collections.emptyMap();

    protected ComplexDataSchema(DataSchema.Type type) {
        super(type);
    }

    @Override
    public boolean hasError() {
        return this._hasError;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    protected void setHasError() {
        this._hasError = true;
    }

    public void setProperties(Map<String, Object> properties) {
        this._properties = Collections.unmodifiableMap(properties);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this._properties;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object instanceof ComplexDataSchema) {
            ComplexDataSchema other = (ComplexDataSchema)object;
            return this.getType() == other.getType() && this._hasError == other._hasError && this._properties.equals(other._properties) && this._resolvedProperties.equals(other._resolvedProperties);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getType().hashCode() ^ this._properties.hashCode() ^ this._resolvedProperties.hashCode();
    }
}

