/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec.symbol;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.linkedin.data.codec.ProtobufCodecOptions;
import com.linkedin.data.codec.ProtobufDataCodec;
import com.linkedin.data.codec.symbol.SymbolTable;
import com.linkedin.data.codec.symbol.SymbolTableMetadata;
import com.linkedin.data.codec.symbol.SymbolTableMetadataExtractor;
import com.linkedin.data.codec.symbol.SymbolTableProvider;
import com.linkedin.data.codec.symbol.SymbolTableSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSymbolTableProvider
implements SymbolTableProvider {
    private static final SymbolTableMetadataExtractor METADATA_EXTRACTOR = new SymbolTableMetadataExtractor();
    private static final String ACCEPT_HEADER = "Accept";
    private static final String SYMBOL_TABLE_HEADER = "x-restli-symbol-table-request";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSymbolTableProvider.class.getSimpleName());
    static final ProtobufDataCodec CODEC = new ProtobufDataCodec(new ProtobufCodecOptions.Builder().setEnableASCIIOnlyStrings(true).build());
    public static final String SYMBOL_TABLE_URI_PATH = "symbolTable";
    private static SSLSocketFactory SSL_SOCKET_FACTORY;
    private static Map<String, String> DEFAULT_HEADERS;
    private static HeaderProvider HEADER_PROVIDER;
    private final Cache<String, SymbolTable> _cache = Caffeine.newBuilder().maximumSize(1000L).build();

    public static void setSSLSocketFactory(SSLSocketFactory socketFactory) {
        SSL_SOCKET_FACTORY = socketFactory;
    }

    public static void setDefaultHeaders(Map<String, String> defaultHeaders) {
        DEFAULT_HEADERS = defaultHeaders;
    }

    public static void setHeaderProvider(HeaderProvider headerProvider) {
        HEADER_PROVIDER = headerProvider;
    }

    DefaultSymbolTableProvider() {
    }

    public void injectLocalSymbolTable(SymbolTable symbolTable) {
        if (symbolTable != null) {
            this._cache.put(symbolTable.getName(), symbolTable);
        } else {
            LOGGER.error("Cannot inject null local symbol table");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SymbolTable getSymbolTable(String symbolTableName) {
        try {
            SymbolTable symbolTable;
            String tableName;
            block11: {
                SymbolTableMetadata metadata = METADATA_EXTRACTOR.extractMetadata(symbolTableName);
                String serverNodeUri = metadata.getServerNodeUri();
                tableName = metadata.getSymbolTableName();
                boolean isRemote = metadata.isRemote();
                symbolTable = this._cache.getIfPresent(tableName);
                if (symbolTable != null) {
                    return symbolTable;
                }
                if (!isRemote) {
                    throw new IllegalStateException("Unable to fetch symbol table with name: " + symbolTableName);
                }
                String url = serverNodeUri + "/" + SYMBOL_TABLE_URI_PATH + "/" + tableName;
                HttpURLConnection connection = this.openConnection(url);
                try {
                    if (DEFAULT_HEADERS != null) {
                        DEFAULT_HEADERS.entrySet().forEach(entry -> connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue()));
                    }
                    if (HEADER_PROVIDER != null) {
                        HEADER_PROVIDER.getHeaders().entrySet().forEach(entry -> connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue()));
                    }
                    connection.setRequestProperty(ACCEPT_HEADER, "application/x-protobuf2");
                    connection.setRequestProperty(SYMBOL_TABLE_HEADER, Boolean.toString(true));
                    int responseCode = connection.getResponseCode();
                    if (responseCode == 200) {
                        InputStream inputStream = connection.getInputStream();
                        symbolTable = SymbolTableSerializer.fromInputStream(inputStream, CODEC, null);
                        break block11;
                    }
                    throw new IOException("Unexpected response status: " + responseCode);
                }
                finally {
                    connection.disconnect();
                }
            }
            this._cache.put(tableName, symbolTable);
            return symbolTable;
        }
        catch (MalformedURLException ex) {
            LOGGER.error("Failed to construct symbol table URL from symbol table name: " + symbolTableName, ex);
        }
        catch (Exception e) {
            LOGGER.error("Failed to fetch remote symbol table with name: " + symbolTableName, e);
        }
        throw new IllegalStateException("Unable to fetch symbol table with name: " + symbolTableName);
    }

    HttpURLConnection openConnection(String url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        if (SSL_SOCKET_FACTORY != null && connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(SSL_SOCKET_FACTORY);
        }
        return connection;
    }

    public static interface HeaderProvider {
        public Map<String, String> getHeaders();
    }
}

