/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec.entitystream;

import com.linkedin.data.ByteString;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Deque;

class QueueBufferedOutputStream
extends OutputStream {
    private int _bufferSize;
    private Deque<byte[]> _buffers = new ArrayDeque<byte[]>();
    private int _tailOffset;

    QueueBufferedOutputStream(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] tail = this._buffers.peekLast();
        if (tail == null || this._tailOffset == this._bufferSize) {
            tail = new byte[this._bufferSize];
            this._tailOffset = 0;
            this._buffers.addLast(tail);
        }
        tail[this._tailOffset++] = (byte)b;
    }

    @Override
    public void write(byte[] data, int offset, int length) {
        if (length == 0) {
            return;
        }
        byte[] tail = this._buffers.peekLast();
        if (tail == null) {
            tail = new byte[this._bufferSize];
            this._buffers.addLast(tail);
            this._tailOffset = 0;
        }
        while (length > 0) {
            int remaining = this._bufferSize - this._tailOffset;
            if (length > remaining) {
                System.arraycopy(data, offset, tail, this._tailOffset, remaining);
                tail = new byte[this._bufferSize];
                this._buffers.addLast(tail);
                this._tailOffset = 0;
                length -= remaining;
                offset += remaining;
                continue;
            }
            System.arraycopy(data, offset, tail, this._tailOffset, length);
            this._tailOffset += length;
            break;
        }
    }

    boolean isEmpty() {
        return this._buffers.isEmpty();
    }

    boolean isFull() {
        int size = this._buffers.size();
        return size > 1 || size == 1 && this._tailOffset == this._bufferSize;
    }

    ByteString getBytes() {
        byte[] bytes = this._buffers.removeFirst();
        return this._buffers.isEmpty() ? ByteString.unsafeWrap(bytes, 0, this._tailOffset) : ByteString.unsafeWrap(bytes);
    }
}

