/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.urn;

import com.linkedin.common.urn.TupleKey;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DirectCoercer;
import com.linkedin.data.template.TemplateOutputCastException;
import java.net.URISyntaxException;

public final class DataFlowUrn
extends Urn {
    public static final String ENTITY_TYPE = "dataFlow";
    private final String _orchestrator;
    private final String _flowId;
    private final String _cluster;

    public DataFlowUrn(String orchestrator, String flowId, String cluster) {
        super(ENTITY_TYPE, TupleKey.create(orchestrator, flowId, cluster));
        this._orchestrator = orchestrator;
        this._flowId = flowId;
        this._cluster = cluster;
    }

    public String getOrchestratorEntity() {
        return this._orchestrator;
    }

    public String getFlowIdEntity() {
        return this._flowId;
    }

    public String getClusterEntity() {
        return this._cluster;
    }

    public static DataFlowUrn createFromString(String rawUrn) throws URISyntaxException {
        return DataFlowUrn.createFromUrn(Urn.createFromString(rawUrn));
    }

    public static DataFlowUrn createFromUrn(Urn urn) throws URISyntaxException {
        if (!"li".equals(urn.getNamespace())) {
            throw new URISyntaxException(urn.toString(), "Urn namespace type should be 'li'.");
        }
        if (!ENTITY_TYPE.equals(urn.getEntityType())) {
            throw new URISyntaxException(urn.toString(), "Urn entity type should be 'dataFlow'.");
        }
        TupleKey key = urn.getEntityKey();
        if (key.size() != 3) {
            throw new URISyntaxException(urn.toString(), "Invalid number of keys.");
        }
        try {
            return new DataFlowUrn(key.getAs(0, String.class), key.getAs(1, String.class), key.getAs(2, String.class));
        }
        catch (Exception e) {
            throw new URISyntaxException(urn.toString(), "Invalid URN Parameter: '" + e.getMessage());
        }
    }

    public static DataFlowUrn deserialize(String rawUrn) throws URISyntaxException {
        return DataFlowUrn.createFromString(rawUrn);
    }

    static {
        Custom.registerCoercer(new DirectCoercer<DataFlowUrn>(){

            @Override
            public Object coerceInput(DataFlowUrn object) throws ClassCastException {
                return object.toString();
            }

            @Override
            public DataFlowUrn coerceOutput(Object object) throws TemplateOutputCastException {
                try {
                    return DataFlowUrn.createFromString((String)object);
                }
                catch (URISyntaxException e) {
                    throw new TemplateOutputCastException("Invalid URN syntax: " + e.getMessage(), e);
                }
            }
        }, DataFlowUrn.class);
    }
}

