/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.BrowsePathEntryArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BrowsePathsV2
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Shared aspect containing a Browse Path to be indexed for an entity.*/@Aspect.name=\"browsePathsV2\"record BrowsePathsV2{/**A valid browse path for the entity. This field is provided by DataHub by default.\nThis aspect is a newer version of browsePaths where we can encode more information in the path.\nThis path is also based on containers for a given entity if it has containers.\n\nThis is stored in elasticsearch as unit-separator delimited strings and only includes platform specific folders or containers.\nThese paths should not include high level info captured elsewhere ie. Platform and Environment.*/@Searchable.`/*/id`={\"fieldName\":\"browsePathV2\",\"fieldType\":\"BROWSE_PATH_V2\"}path:array[/**Represents a single level in an entity's browsePathV2*/record BrowsePathEntry{/**The ID of the browse path entry. This is what gets stored in the index.\nIf there's an urn associated with this entry, id and urn will be the same*/id:string/**Optional urn pointing to some entity in DataHub*/urn:optional@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]}", SchemaFormatType.PDL);
    private BrowsePathEntryArray _pathField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Path = SCHEMA.getField("path");

    public BrowsePathsV2() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public BrowsePathsV2(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasPath() {
        if (this._pathField != null) {
            return true;
        }
        return this._map.containsKey("path");
    }

    public void removePath() {
        this._map.remove("path");
    }

    @Nullable
    public BrowsePathEntryArray getPath(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getPath();
            }
            case DEFAULT: 
            case NULL: {
                if (this._pathField != null) {
                    return this._pathField;
                }
                Object __rawValue = this._map.get("path");
                this._pathField = __rawValue == null ? null : new BrowsePathEntryArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._pathField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public BrowsePathEntryArray getPath() {
        if (this._pathField != null) {
            return this._pathField;
        }
        Object __rawValue = this._map.get("path");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("path");
        }
        this._pathField = __rawValue == null ? null : new BrowsePathEntryArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._pathField;
    }

    public BrowsePathsV2 setPath(@Nullable BrowsePathEntryArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPath(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field path of com.linkedin.common.BrowsePathsV2");
                }
                CheckedUtil.putWithoutChecking(this._map, "path", value.data());
                this._pathField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePath();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "path", value.data());
                this._pathField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "path", value.data());
                this._pathField = value;
            }
        }
        return this;
    }

    public BrowsePathsV2 setPath(@Nonnull BrowsePathEntryArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field path of com.linkedin.common.BrowsePathsV2 to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "path", value.data());
        this._pathField = value;
        return this;
    }

    @Override
    public BrowsePathsV2 clone() throws CloneNotSupportedException {
        BrowsePathsV2 __clone = (BrowsePathsV2)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public BrowsePathsV2 copy() throws CloneNotSupportedException {
        BrowsePathsV2 __copy = (BrowsePathsV2)super.copy();
        __copy._pathField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final BrowsePathsV2 __objectRef;

        private ChangeListener(BrowsePathsV2 reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "path": {
                    this.__objectRef._pathField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public BrowsePathEntryArray.Fields path() {
            return new BrowsePathEntryArray.Fields(this.getPathComponents(), "path");
        }

        public PathSpec path(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "path");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private BrowsePathEntryArray.ProjectionMask _pathMask;

        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withPath(Function<BrowsePathEntryArray.ProjectionMask, BrowsePathEntryArray.ProjectionMask> nestedMask) {
            this._pathMask = nestedMask.apply(this._pathMask == null ? BrowsePathEntryArray.createMask() : this._pathMask);
            this.getDataMap().put("path", this._pathMask.getDataMap());
            return this;
        }

        public ProjectionMask withPath() {
            this._pathMask = null;
            this.getDataMap().put("path", 1);
            return this;
        }

        public ProjectionMask withPath(Function<BrowsePathEntryArray.ProjectionMask, BrowsePathEntryArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._pathMask = nestedMask.apply(this._pathMask == null ? BrowsePathEntryArray.createMask() : this._pathMask);
            this.getDataMap().put("path", this._pathMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("path").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("path").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withPath(Integer start, Integer count) {
            this._pathMask = null;
            this.getDataMap().put("path", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("path").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("path").put("$count", count);
            }
            return this;
        }
    }
}

