/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.usage;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.usage.UsageAggregationArray;
import com.linkedin.usage.UsageQueryResultAggregations;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UsageQueryResult
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.usage/**Results of a query for usage data.*/record UsageQueryResult{/** Raw buckets */buckets:optional array[/**Usage data for a given resource, rolled up into a bucket.*/@deprecated=\"Use DatasetUsageStatistics, or other UsageStatistics records, instead\"record UsageAggregation{/** Bucket start time in milliseconds */bucket:long/** Bucket duration */duration:{namespace com.linkedin.common/**Enum to define the length of a bucket when doing aggregations*/enum WindowDuration{YEAR,MONTH,WEEK,DAY,HOUR}}/** Resource associated with these usage stats */resource:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/** Metrics associated with this bucket */metrics:/**Metrics for usage data for a given resource and bucket. Not all fields\nmake sense for all buckets, so every field is optional.*/record UsageAggregationMetrics{/** Unique user count */uniqueUserCount:optional int/** Users within this bucket, with frequency counts */users:optional array[/** Records a single user's usage counts for a given resource */record UserUsageCounts{user:optional com.linkedin.common.Urn,count:int/** If user_email is set, we attempt to resolve the user's urn upon ingest */userEmail:optional string}]/** Total SQL query count */totalSqlQueries:optional int/** Frequent SQL queries; mostly makes sense for datasets in SQL databases */topSqlQueries:optional array[string]/** Field-level usage stats */fields:optional array[/** Records field-level usage counts for a given resource */record FieldUsageCounts{fieldName:string,count:int}]}}]/**Aggregated metrics. All fields are optional here, since they will be populated\nonly if the underlying buckets contain the data required to generate that aggregation.*/aggregations:record UsageQueryResultAggregations{uniqueUserCount:optional int,totalSqlQueries:optional int,users:optional array[UserUsageCounts]fields:optional array[FieldUsageCounts]}}", SchemaFormatType.PDL);
    private UsageAggregationArray _bucketsField = null;
    private UsageQueryResultAggregations _aggregationsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Buckets = SCHEMA.getField("buckets");
    private static final RecordDataSchema.Field FIELD_Aggregations = SCHEMA.getField("aggregations");

    public UsageQueryResult() {
        super(new DataMap(3, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public UsageQueryResult(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasBuckets() {
        if (this._bucketsField != null) {
            return true;
        }
        return this._map.containsKey("buckets");
    }

    public void removeBuckets() {
        this._map.remove("buckets");
    }

    @Nullable
    public UsageAggregationArray getBuckets(GetMode mode) {
        return this.getBuckets();
    }

    @Nullable
    public UsageAggregationArray getBuckets() {
        if (this._bucketsField != null) {
            return this._bucketsField;
        }
        Object __rawValue = this._map.get("buckets");
        this._bucketsField = __rawValue == null ? null : new UsageAggregationArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._bucketsField;
    }

    public UsageQueryResult setBuckets(@Nullable UsageAggregationArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setBuckets(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeBuckets();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "buckets", value.data());
                this._bucketsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "buckets", value.data());
                this._bucketsField = value;
            }
        }
        return this;
    }

    public UsageQueryResult setBuckets(@Nonnull UsageAggregationArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field buckets of com.linkedin.usage.UsageQueryResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "buckets", value.data());
        this._bucketsField = value;
        return this;
    }

    public boolean hasAggregations() {
        if (this._aggregationsField != null) {
            return true;
        }
        return this._map.containsKey("aggregations");
    }

    public void removeAggregations() {
        this._map.remove("aggregations");
    }

    @Nullable
    public UsageQueryResultAggregations getAggregations(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAggregations();
            }
            case DEFAULT: 
            case NULL: {
                if (this._aggregationsField != null) {
                    return this._aggregationsField;
                }
                Object __rawValue = this._map.get("aggregations");
                this._aggregationsField = __rawValue == null ? null : new UsageQueryResultAggregations(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._aggregationsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public UsageQueryResultAggregations getAggregations() {
        if (this._aggregationsField != null) {
            return this._aggregationsField;
        }
        Object __rawValue = this._map.get("aggregations");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("aggregations");
        }
        this._aggregationsField = __rawValue == null ? null : new UsageQueryResultAggregations(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._aggregationsField;
    }

    public UsageQueryResult setAggregations(@Nullable UsageQueryResultAggregations value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAggregations(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field aggregations of com.linkedin.usage.UsageQueryResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "aggregations", value.data());
                this._aggregationsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAggregations();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "aggregations", value.data());
                this._aggregationsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "aggregations", value.data());
                this._aggregationsField = value;
            }
        }
        return this;
    }

    public UsageQueryResult setAggregations(@Nonnull UsageQueryResultAggregations value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field aggregations of com.linkedin.usage.UsageQueryResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "aggregations", value.data());
        this._aggregationsField = value;
        return this;
    }

    @Override
    public UsageQueryResult clone() throws CloneNotSupportedException {
        UsageQueryResult __clone = (UsageQueryResult)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public UsageQueryResult copy() throws CloneNotSupportedException {
        UsageQueryResult __copy = (UsageQueryResult)super.copy();
        __copy._bucketsField = null;
        __copy._aggregationsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final UsageQueryResult __objectRef;

        private ChangeListener(UsageQueryResult reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "buckets": {
                    this.__objectRef._bucketsField = null;
                    break;
                }
                case "aggregations": {
                    this.__objectRef._aggregationsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public UsageAggregationArray.Fields buckets() {
            return new UsageAggregationArray.Fields(this.getPathComponents(), "buckets");
        }

        public PathSpec buckets(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "buckets");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public UsageQueryResultAggregations.Fields aggregations() {
            return new UsageQueryResultAggregations.Fields(this.getPathComponents(), "aggregations");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private UsageAggregationArray.ProjectionMask _bucketsMask;
        private UsageQueryResultAggregations.ProjectionMask _aggregationsMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withBuckets(Function<UsageAggregationArray.ProjectionMask, UsageAggregationArray.ProjectionMask> nestedMask) {
            this._bucketsMask = nestedMask.apply(this._bucketsMask == null ? UsageAggregationArray.createMask() : this._bucketsMask);
            this.getDataMap().put("buckets", this._bucketsMask.getDataMap());
            return this;
        }

        public ProjectionMask withBuckets() {
            this._bucketsMask = null;
            this.getDataMap().put("buckets", 1);
            return this;
        }

        public ProjectionMask withBuckets(Function<UsageAggregationArray.ProjectionMask, UsageAggregationArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._bucketsMask = nestedMask.apply(this._bucketsMask == null ? UsageAggregationArray.createMask() : this._bucketsMask);
            this.getDataMap().put("buckets", this._bucketsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("buckets").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("buckets").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withBuckets(Integer start, Integer count) {
            this._bucketsMask = null;
            this.getDataMap().put("buckets", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("buckets").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("buckets").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withAggregations(Function<UsageQueryResultAggregations.ProjectionMask, UsageQueryResultAggregations.ProjectionMask> nestedMask) {
            this._aggregationsMask = nestedMask.apply(this._aggregationsMask == null ? UsageQueryResultAggregations.createMask() : this._aggregationsMask);
            this.getDataMap().put("aggregations", this._aggregationsMask.getDataMap());
            return this;
        }

        public ProjectionMask withAggregations() {
            this._aggregationsMask = null;
            this.getDataMap().put("aggregations", 1);
            return this;
        }
    }
}

