/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.test;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.test.TestResultArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TestResults
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.test/**Information about a Test Result*/@Aspect.name=\"testResults\"record TestResults{/**Results that are failing*/@Relationship.`/*/test`={\"entityTypes\":[\"test\"],\"name\":\"IsFailing\"}@Searchable.`/*/test`={\"fieldName\":\"failingTests\",\"fieldType\":\"URN\",\"hasValuesFieldName\":\"hasFailingTests\",\"queryByDefault\":false}failing:array[/**Information about a Test Result*/record TestResult{/**The urn of the test*/test:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**The type of the result*/type:enum TestResultType{/** The Test Succeeded*/SUCCESS/** The Test Failed*/FAILURE}/**The md5 of the test definition that was used to compute this result.\nSee TestInfo.testDefinition.md5 for more information.*/testDefinitionMd5:optional string/**The audit stamp of when the result was computed, including the actor who computed it.*/lastComputed:optional{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}}]/**Results that are passing*/@Relationship.`/*/test`={\"entityTypes\":[\"test\"],\"name\":\"IsPassing\"}@Searchable.`/*/test`={\"fieldName\":\"passingTests\",\"fieldType\":\"URN\",\"hasValuesFieldName\":\"hasPassingTests\",\"queryByDefault\":false}passing:array[TestResult]}", SchemaFormatType.PDL);
    private TestResultArray _failingField = null;
    private TestResultArray _passingField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Failing = SCHEMA.getField("failing");
    private static final RecordDataSchema.Field FIELD_Passing = SCHEMA.getField("passing");

    public TestResults() {
        super(new DataMap(3, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public TestResults(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasFailing() {
        if (this._failingField != null) {
            return true;
        }
        return this._map.containsKey("failing");
    }

    public void removeFailing() {
        this._map.remove("failing");
    }

    @Nullable
    public TestResultArray getFailing(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getFailing();
            }
            case DEFAULT: 
            case NULL: {
                if (this._failingField != null) {
                    return this._failingField;
                }
                Object __rawValue = this._map.get("failing");
                this._failingField = __rawValue == null ? null : new TestResultArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._failingField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public TestResultArray getFailing() {
        if (this._failingField != null) {
            return this._failingField;
        }
        Object __rawValue = this._map.get("failing");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("failing");
        }
        this._failingField = __rawValue == null ? null : new TestResultArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._failingField;
    }

    public TestResults setFailing(@Nullable TestResultArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFailing(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field failing of com.linkedin.test.TestResults");
                }
                CheckedUtil.putWithoutChecking(this._map, "failing", value.data());
                this._failingField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFailing();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "failing", value.data());
                this._failingField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "failing", value.data());
                this._failingField = value;
            }
        }
        return this;
    }

    public TestResults setFailing(@Nonnull TestResultArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field failing of com.linkedin.test.TestResults to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "failing", value.data());
        this._failingField = value;
        return this;
    }

    public boolean hasPassing() {
        if (this._passingField != null) {
            return true;
        }
        return this._map.containsKey("passing");
    }

    public void removePassing() {
        this._map.remove("passing");
    }

    @Nullable
    public TestResultArray getPassing(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getPassing();
            }
            case DEFAULT: 
            case NULL: {
                if (this._passingField != null) {
                    return this._passingField;
                }
                Object __rawValue = this._map.get("passing");
                this._passingField = __rawValue == null ? null : new TestResultArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._passingField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public TestResultArray getPassing() {
        if (this._passingField != null) {
            return this._passingField;
        }
        Object __rawValue = this._map.get("passing");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("passing");
        }
        this._passingField = __rawValue == null ? null : new TestResultArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._passingField;
    }

    public TestResults setPassing(@Nullable TestResultArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPassing(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field passing of com.linkedin.test.TestResults");
                }
                CheckedUtil.putWithoutChecking(this._map, "passing", value.data());
                this._passingField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePassing();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "passing", value.data());
                this._passingField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "passing", value.data());
                this._passingField = value;
            }
        }
        return this;
    }

    public TestResults setPassing(@Nonnull TestResultArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field passing of com.linkedin.test.TestResults to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "passing", value.data());
        this._passingField = value;
        return this;
    }

    @Override
    public TestResults clone() throws CloneNotSupportedException {
        TestResults __clone = (TestResults)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public TestResults copy() throws CloneNotSupportedException {
        TestResults __copy = (TestResults)super.copy();
        __copy._failingField = null;
        __copy._passingField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final TestResults __objectRef;

        private ChangeListener(TestResults reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "failing": {
                    this.__objectRef._failingField = null;
                    break;
                }
                case "passing": {
                    this.__objectRef._passingField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public TestResultArray.Fields failing() {
            return new TestResultArray.Fields(this.getPathComponents(), "failing");
        }

        public PathSpec failing(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "failing");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public TestResultArray.Fields passing() {
            return new TestResultArray.Fields(this.getPathComponents(), "passing");
        }

        public PathSpec passing(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "passing");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private TestResultArray.ProjectionMask _failingMask;
        private TestResultArray.ProjectionMask _passingMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withFailing(Function<TestResultArray.ProjectionMask, TestResultArray.ProjectionMask> nestedMask) {
            this._failingMask = nestedMask.apply(this._failingMask == null ? TestResultArray.createMask() : this._failingMask);
            this.getDataMap().put("failing", this._failingMask.getDataMap());
            return this;
        }

        public ProjectionMask withFailing() {
            this._failingMask = null;
            this.getDataMap().put("failing", 1);
            return this;
        }

        public ProjectionMask withFailing(Function<TestResultArray.ProjectionMask, TestResultArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._failingMask = nestedMask.apply(this._failingMask == null ? TestResultArray.createMask() : this._failingMask);
            this.getDataMap().put("failing", this._failingMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("failing").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("failing").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withFailing(Integer start, Integer count) {
            this._failingMask = null;
            this.getDataMap().put("failing", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("failing").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("failing").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withPassing(Function<TestResultArray.ProjectionMask, TestResultArray.ProjectionMask> nestedMask) {
            this._passingMask = nestedMask.apply(this._passingMask == null ? TestResultArray.createMask() : this._passingMask);
            this.getDataMap().put("passing", this._passingMask.getDataMap());
            return this;
        }

        public ProjectionMask withPassing() {
            this._passingMask = null;
            this.getDataMap().put("passing", 1);
            return this;
        }

        public ProjectionMask withPassing(Function<TestResultArray.ProjectionMask, TestResultArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._passingMask = nestedMask.apply(this._passingMask == null ? TestResultArray.createMask() : this._passingMask);
            this.getDataMap().put("passing", this._passingMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("passing").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("passing").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withPassing(Integer start, Integer count) {
            this._passingMask = null;
            this.getDataMap().put("passing", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("passing").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("passing").put("$count", count);
            }
            return this;
        }
    }
}

