/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.test;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.test.TestResultType;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TestResult
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.test/**Information about a Test Result*/record TestResult{/**The urn of the test*/test:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**The type of the result*/type:enum TestResultType{/** The Test Succeeded*/SUCCESS/** The Test Failed*/FAILURE}/**The md5 of the test definition that was used to compute this result.\nSee TestInfo.testDefinition.md5 for more information.*/testDefinitionMd5:optional string/**The audit stamp of when the result was computed, including the actor who computed it.*/lastComputed:optional{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}}", SchemaFormatType.PDL);
    private Urn _testField = null;
    private TestResultType _typeField = null;
    private String _testDefinitionMd5Field = null;
    private AuditStamp _lastComputedField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Test = SCHEMA.getField("test");
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_TestDefinitionMd5 = SCHEMA.getField("testDefinitionMd5");
    private static final RecordDataSchema.Field FIELD_LastComputed = SCHEMA.getField("lastComputed");

    public TestResult() {
        super(new DataMap(6, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public TestResult(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTest() {
        if (this._testField != null) {
            return true;
        }
        return this._map.containsKey("test");
    }

    public void removeTest() {
        this._map.remove("test");
    }

    @Nullable
    public Urn getTest(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTest();
            }
            case DEFAULT: 
            case NULL: {
                if (this._testField != null) {
                    return this._testField;
                }
                Object __rawValue = this._map.get("test");
                this._testField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._testField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getTest() {
        if (this._testField != null) {
            return this._testField;
        }
        Object __rawValue = this._map.get("test");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("test");
        }
        this._testField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._testField;
    }

    public TestResult setTest(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTest(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field test of com.linkedin.test.TestResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "test", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._testField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTest();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "test", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._testField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "test", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._testField = value;
            }
        }
        return this;
    }

    public TestResult setTest(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field test of com.linkedin.test.TestResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "test", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._testField = value;
        return this;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public TestResultType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, TestResultType.class, TestResultType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public TestResultType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, TestResultType.class, TestResultType.$UNKNOWN);
        return this._typeField;
    }

    public TestResult setType(@Nullable TestResultType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.test.TestResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public TestResult setType(@Nonnull TestResultType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.test.TestResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasTestDefinitionMd5() {
        if (this._testDefinitionMd5Field != null) {
            return true;
        }
        return this._map.containsKey("testDefinitionMd5");
    }

    public void removeTestDefinitionMd5() {
        this._map.remove("testDefinitionMd5");
    }

    @Nullable
    public String getTestDefinitionMd5(GetMode mode) {
        return this.getTestDefinitionMd5();
    }

    @Nullable
    public String getTestDefinitionMd5() {
        if (this._testDefinitionMd5Field != null) {
            return this._testDefinitionMd5Field;
        }
        Object __rawValue = this._map.get("testDefinitionMd5");
        this._testDefinitionMd5Field = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._testDefinitionMd5Field;
    }

    public TestResult setTestDefinitionMd5(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTestDefinitionMd5(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTestDefinitionMd5();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "testDefinitionMd5", value);
                this._testDefinitionMd5Field = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "testDefinitionMd5", value);
                this._testDefinitionMd5Field = value;
            }
        }
        return this;
    }

    public TestResult setTestDefinitionMd5(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field testDefinitionMd5 of com.linkedin.test.TestResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "testDefinitionMd5", value);
        this._testDefinitionMd5Field = value;
        return this;
    }

    public boolean hasLastComputed() {
        if (this._lastComputedField != null) {
            return true;
        }
        return this._map.containsKey("lastComputed");
    }

    public void removeLastComputed() {
        this._map.remove("lastComputed");
    }

    @Nullable
    public AuditStamp getLastComputed(GetMode mode) {
        return this.getLastComputed();
    }

    @Nullable
    public AuditStamp getLastComputed() {
        if (this._lastComputedField != null) {
            return this._lastComputedField;
        }
        Object __rawValue = this._map.get("lastComputed");
        this._lastComputedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lastComputedField;
    }

    public TestResult setLastComputed(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastComputed(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastComputed();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastComputed", value.data());
                this._lastComputedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastComputed", value.data());
                this._lastComputedField = value;
            }
        }
        return this;
    }

    public TestResult setLastComputed(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastComputed of com.linkedin.test.TestResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastComputed", value.data());
        this._lastComputedField = value;
        return this;
    }

    @Override
    public TestResult clone() throws CloneNotSupportedException {
        TestResult __clone = (TestResult)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public TestResult copy() throws CloneNotSupportedException {
        TestResult __copy = (TestResult)super.copy();
        __copy._testDefinitionMd5Field = null;
        __copy._testField = null;
        __copy._typeField = null;
        __copy._lastComputedField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final TestResult __objectRef;

        private ChangeListener(TestResult reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "testDefinitionMd5": {
                    this.__objectRef._testDefinitionMd5Field = null;
                    break;
                }
                case "test": {
                    this.__objectRef._testField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "lastComputed": {
                    this.__objectRef._lastComputedField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec test() {
            return new PathSpec(this.getPathComponents(), "test");
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec testDefinitionMd5() {
            return new PathSpec(this.getPathComponents(), "testDefinitionMd5");
        }

        public AuditStamp.Fields lastComputed() {
            return new AuditStamp.Fields(this.getPathComponents(), "lastComputed");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AuditStamp.ProjectionMask _lastComputedMask;

        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withTest() {
            this.getDataMap().put("test", 1);
            return this;
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withTestDefinitionMd5() {
            this.getDataMap().put("testDefinitionMd5", 1);
            return this;
        }

        public ProjectionMask withLastComputed(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._lastComputedMask = nestedMask.apply(this._lastComputedMask == null ? AuditStamp.createMask() : this._lastComputedMask);
            this.getDataMap().put("lastComputed", this._lastComputedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastComputed(MaskMap nestedMask) {
            this.getDataMap().put("lastComputed", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastComputed() {
            this._lastComputedMask = null;
            this.getDataMap().put("lastComputed", 1);
            return this;
        }
    }
}

