/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.query;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.query.QueryLanguage;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class QueryStatement
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.query/**A query statement against one or more data assets.*/record QueryStatement{/**The query text*/value:string/**The language of the Query, e.g. SQL.*/language:enum QueryLanguage{/**A SQL Query*/SQL/**Unknown query language*/UNKNOWN}=\"SQL\"}", SchemaFormatType.PDL);
    private String _valueField = null;
    private QueryLanguage _languageField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Value = SCHEMA.getField("value");
    private static final RecordDataSchema.Field FIELD_Language = SCHEMA.getField("language");
    private static final QueryLanguage DEFAULT_Language = DataTemplateUtil.coerceEnumOutput(FIELD_Language.getDefault(), QueryLanguage.class, QueryLanguage.$UNKNOWN);

    public QueryStatement() {
        super(new DataMap(3, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public QueryStatement(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasValue() {
        if (this._valueField != null) {
            return true;
        }
        return this._map.containsKey("value");
    }

    public void removeValue() {
        this._map.remove("value");
    }

    @Nullable
    public String getValue(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getValue();
            }
            case DEFAULT: 
            case NULL: {
                if (this._valueField != null) {
                    return this._valueField;
                }
                Object __rawValue = this._map.get("value");
                this._valueField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._valueField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getValue() {
        if (this._valueField != null) {
            return this._valueField;
        }
        Object __rawValue = this._map.get("value");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("value");
        }
        this._valueField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._valueField;
    }

    public QueryStatement setValue(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setValue(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field value of com.linkedin.query.QueryStatement");
                }
                CheckedUtil.putWithoutChecking(this._map, "value", value);
                this._valueField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeValue();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "value", value);
                this._valueField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "value", value);
                this._valueField = value;
            }
        }
        return this;
    }

    public QueryStatement setValue(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field value of com.linkedin.query.QueryStatement to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "value", value);
        this._valueField = value;
        return this;
    }

    public boolean hasLanguage() {
        if (this._languageField != null) {
            return true;
        }
        return this._map.containsKey("language");
    }

    public void removeLanguage() {
        this._map.remove("language");
    }

    @Nullable
    public QueryLanguage getLanguage(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getLanguage();
            }
            case NULL: {
                if (this._languageField != null) {
                    return this._languageField;
                }
                Object __rawValue = this._map.get("language");
                this._languageField = DataTemplateUtil.coerceEnumOutput(__rawValue, QueryLanguage.class, QueryLanguage.$UNKNOWN);
                return this._languageField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public QueryLanguage getLanguage() {
        if (this._languageField != null) {
            return this._languageField;
        }
        Object __rawValue = this._map.get("language");
        if (__rawValue == null) {
            return DEFAULT_Language;
        }
        this._languageField = DataTemplateUtil.coerceEnumOutput(__rawValue, QueryLanguage.class, QueryLanguage.$UNKNOWN);
        return this._languageField;
    }

    public QueryStatement setLanguage(@Nullable QueryLanguage value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLanguage(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field language of com.linkedin.query.QueryStatement");
                }
                CheckedUtil.putWithoutChecking(this._map, "language", value.name());
                this._languageField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLanguage();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "language", value.name());
                this._languageField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "language", value.name());
                this._languageField = value;
            }
        }
        return this;
    }

    public QueryStatement setLanguage(@Nonnull QueryLanguage value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field language of com.linkedin.query.QueryStatement to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "language", value.name());
        this._languageField = value;
        return this;
    }

    @Override
    public QueryStatement clone() throws CloneNotSupportedException {
        QueryStatement __clone = (QueryStatement)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public QueryStatement copy() throws CloneNotSupportedException {
        QueryStatement __copy = (QueryStatement)super.copy();
        __copy._languageField = null;
        __copy._valueField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final QueryStatement __objectRef;

        private ChangeListener(QueryStatement reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "language": {
                    this.__objectRef._languageField = null;
                    break;
                }
                case "value": {
                    this.__objectRef._valueField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec value() {
            return new PathSpec(this.getPathComponents(), "value");
        }

        public PathSpec language() {
            return new PathSpec(this.getPathComponents(), "language");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withValue() {
            this.getDataMap().put("value", 1);
            return this;
        }

        public ProjectionMask withLanguage() {
            this.getDataMap().put("language", 1);
            return this;
        }
    }
}

