/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.post;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.post.PostContent;
import com.linkedin.post.PostType;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PostInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.post/**Information about a DataHub Post.*/@Aspect.name=\"postInfo\"record PostInfo{/**Type of the Post.*/@Searchable={}type:/**Enum defining types of Posts.*/enum PostType{/**The Post is an Home Page announcement.*/HOME_PAGE_ANNOUNCEMENT/**The Post is an Entity level announcement.*/ENTITY_ANNOUNCEMENT}/**Content stored in the post.*/content:/**Content stored inside a Post.*/record PostContent{/**Title of the post.*/@Searchable.fieldType=\"TEXT_PARTIAL\"title:string/**Type of content held in the post.*/type:/**Enum defining the type of content held in a Post.*/enum PostContentType{/**Text content*/TEXT/**Link content*/LINK}/**Optional description of the post.*/description:optional string/**Optional link that the post is associated with.*/link:optional{namespace com.linkedin.common@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}/**Optional media that the post is storing*/media:optional{namespace com.linkedin.common/**Carries information about which roles a user is assigned to.*/record Media{/**Type of content the Media is storing, e.g. image, video, etc.*/type:/**Enum defining the type of content a Media object holds.*/enum MediaType{/**The Media holds an image.*/IMAGE}/**Where the media content is stored.*/location:Url}}}/**The time at which the post was initially created*/@Searchable.fieldType=\"COUNT\"created:long/**The time at which the post was last modified*/@Searchable.fieldType=\"COUNT\"lastModified:long/**The audit stamp at which the request was last updated*/@Searchable.`/time`={\"fieldName\":\"created\",\"fieldType\":\"COUNT\"}auditStamp:optional{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}/**Optional Entity URN that the post is associated with.*/@Relationship={\"entityTypes\":[\"dataset\",\"schemaField\",\"chart\",\"container\",\"dashboard\",\"dataFlow\",\"dataJob\",\"dataProduct\",\"glossaryTerm\",\"glossaryNode\",\"mlModel\",\"mlFeature\",\"notebook\",\"mlFeatureTable\",\"mlPrimaryKey\",\"mlModelGroup\",\"domain\",\"dataProduct\"],\"name\":\"PostTarget\"}@Searchable={}target:optional com.linkedin.common.Urn}", SchemaFormatType.PDL);
    private PostType _typeField = null;
    private PostContent _contentField = null;
    private Long _createdField = null;
    private Long _lastModifiedField = null;
    private AuditStamp _auditStampField = null;
    private Urn _targetField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_Content = SCHEMA.getField("content");
    private static final RecordDataSchema.Field FIELD_Created = SCHEMA.getField("created");
    private static final RecordDataSchema.Field FIELD_LastModified = SCHEMA.getField("lastModified");
    private static final RecordDataSchema.Field FIELD_AuditStamp = SCHEMA.getField("auditStamp");
    private static final RecordDataSchema.Field FIELD_Target = SCHEMA.getField("target");

    public PostInfo() {
        super(new DataMap(8, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public PostInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public PostType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, PostType.class, PostType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public PostType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, PostType.class, PostType.$UNKNOWN);
        return this._typeField;
    }

    public PostInfo setType(@Nullable PostType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.post.PostInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public PostInfo setType(@Nonnull PostType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.post.PostInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasContent() {
        if (this._contentField != null) {
            return true;
        }
        return this._map.containsKey("content");
    }

    public void removeContent() {
        this._map.remove("content");
    }

    @Nullable
    public PostContent getContent(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getContent();
            }
            case DEFAULT: 
            case NULL: {
                if (this._contentField != null) {
                    return this._contentField;
                }
                Object __rawValue = this._map.get("content");
                this._contentField = __rawValue == null ? null : new PostContent(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._contentField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public PostContent getContent() {
        if (this._contentField != null) {
            return this._contentField;
        }
        Object __rawValue = this._map.get("content");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("content");
        }
        this._contentField = __rawValue == null ? null : new PostContent(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._contentField;
    }

    public PostInfo setContent(@Nullable PostContent value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setContent(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field content of com.linkedin.post.PostInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "content", value.data());
                this._contentField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeContent();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "content", value.data());
                this._contentField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "content", value.data());
                this._contentField = value;
            }
        }
        return this;
    }

    public PostInfo setContent(@Nonnull PostContent value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field content of com.linkedin.post.PostInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "content", value.data());
        this._contentField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public Long getCreated(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCreated();
            }
            case DEFAULT: 
            case NULL: {
                if (this._createdField != null) {
                    return this._createdField;
                }
                Object __rawValue = this._map.get("created");
                this._createdField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._createdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("created");
        }
        this._createdField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._createdField;
    }

    public PostInfo setCreated(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field created of com.linkedin.post.PostInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "created", DataTemplateUtil.coerceLongInput(value));
                this._createdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", DataTemplateUtil.coerceLongInput(value));
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", DataTemplateUtil.coerceLongInput(value));
                this._createdField = value;
            }
        }
        return this;
    }

    public PostInfo setCreated(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.post.PostInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", DataTemplateUtil.coerceLongInput(value));
        this._createdField = value;
        return this;
    }

    public PostInfo setCreated(long value) {
        CheckedUtil.putWithoutChecking(this._map, "created", DataTemplateUtil.coerceLongInput(value));
        this._createdField = value;
        return this;
    }

    public boolean hasLastModified() {
        if (this._lastModifiedField != null) {
            return true;
        }
        return this._map.containsKey("lastModified");
    }

    public void removeLastModified() {
        this._map.remove("lastModified");
    }

    @Nullable
    public Long getLastModified(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getLastModified();
            }
            case DEFAULT: 
            case NULL: {
                if (this._lastModifiedField != null) {
                    return this._lastModifiedField;
                }
                Object __rawValue = this._map.get("lastModified");
                this._lastModifiedField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._lastModifiedField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getLastModified() {
        if (this._lastModifiedField != null) {
            return this._lastModifiedField;
        }
        Object __rawValue = this._map.get("lastModified");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("lastModified");
        }
        this._lastModifiedField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._lastModifiedField;
    }

    public PostInfo setLastModified(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastModified(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field lastModified of com.linkedin.post.PostInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", DataTemplateUtil.coerceLongInput(value));
                this._lastModifiedField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastModified();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", DataTemplateUtil.coerceLongInput(value));
                this._lastModifiedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastModified", DataTemplateUtil.coerceLongInput(value));
                this._lastModifiedField = value;
            }
        }
        return this;
    }

    public PostInfo setLastModified(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastModified of com.linkedin.post.PostInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastModified", DataTemplateUtil.coerceLongInput(value));
        this._lastModifiedField = value;
        return this;
    }

    public PostInfo setLastModified(long value) {
        CheckedUtil.putWithoutChecking(this._map, "lastModified", DataTemplateUtil.coerceLongInput(value));
        this._lastModifiedField = value;
        return this;
    }

    public boolean hasAuditStamp() {
        if (this._auditStampField != null) {
            return true;
        }
        return this._map.containsKey("auditStamp");
    }

    public void removeAuditStamp() {
        this._map.remove("auditStamp");
    }

    @Nullable
    public AuditStamp getAuditStamp(GetMode mode) {
        return this.getAuditStamp();
    }

    @Nullable
    public AuditStamp getAuditStamp() {
        if (this._auditStampField != null) {
            return this._auditStampField;
        }
        Object __rawValue = this._map.get("auditStamp");
        this._auditStampField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._auditStampField;
    }

    public PostInfo setAuditStamp(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAuditStamp(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAuditStamp();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "auditStamp", value.data());
                this._auditStampField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "auditStamp", value.data());
                this._auditStampField = value;
            }
        }
        return this;
    }

    public PostInfo setAuditStamp(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field auditStamp of com.linkedin.post.PostInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "auditStamp", value.data());
        this._auditStampField = value;
        return this;
    }

    public boolean hasTarget() {
        if (this._targetField != null) {
            return true;
        }
        return this._map.containsKey("target");
    }

    public void removeTarget() {
        this._map.remove("target");
    }

    @Nullable
    public Urn getTarget(GetMode mode) {
        return this.getTarget();
    }

    @Nullable
    public Urn getTarget() {
        if (this._targetField != null) {
            return this._targetField;
        }
        Object __rawValue = this._map.get("target");
        this._targetField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._targetField;
    }

    public PostInfo setTarget(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTarget(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTarget();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "target", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._targetField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "target", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._targetField = value;
            }
        }
        return this;
    }

    public PostInfo setTarget(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field target of com.linkedin.post.PostInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "target", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._targetField = value;
        return this;
    }

    @Override
    public PostInfo clone() throws CloneNotSupportedException {
        PostInfo __clone = (PostInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public PostInfo copy() throws CloneNotSupportedException {
        PostInfo __copy = (PostInfo)super.copy();
        __copy._auditStampField = null;
        __copy._createdField = null;
        __copy._lastModifiedField = null;
        __copy._typeField = null;
        __copy._contentField = null;
        __copy._targetField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final PostInfo __objectRef;

        private ChangeListener(PostInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "auditStamp": {
                    this.__objectRef._auditStampField = null;
                    break;
                }
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "lastModified": {
                    this.__objectRef._lastModifiedField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "content": {
                    this.__objectRef._contentField = null;
                    break;
                }
                case "target": {
                    this.__objectRef._targetField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PostContent.Fields content() {
            return new PostContent.Fields(this.getPathComponents(), "content");
        }

        public PathSpec created() {
            return new PathSpec(this.getPathComponents(), "created");
        }

        public PathSpec lastModified() {
            return new PathSpec(this.getPathComponents(), "lastModified");
        }

        public AuditStamp.Fields auditStamp() {
            return new AuditStamp.Fields(this.getPathComponents(), "auditStamp");
        }

        public PathSpec target() {
            return new PathSpec(this.getPathComponents(), "target");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private PostContent.ProjectionMask _contentMask;
        private AuditStamp.ProjectionMask _auditStampMask;

        ProjectionMask() {
            super(8);
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withContent(Function<PostContent.ProjectionMask, PostContent.ProjectionMask> nestedMask) {
            this._contentMask = nestedMask.apply(this._contentMask == null ? PostContent.createMask() : this._contentMask);
            this.getDataMap().put("content", this._contentMask.getDataMap());
            return this;
        }

        public ProjectionMask withContent() {
            this._contentMask = null;
            this.getDataMap().put("content", 1);
            return this;
        }

        public ProjectionMask withCreated() {
            this.getDataMap().put("created", 1);
            return this;
        }

        public ProjectionMask withLastModified() {
            this.getDataMap().put("lastModified", 1);
            return this;
        }

        public ProjectionMask withAuditStamp(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._auditStampMask = nestedMask.apply(this._auditStampMask == null ? AuditStamp.createMask() : this._auditStampMask);
            this.getDataMap().put("auditStamp", this._auditStampMask.getDataMap());
            return this;
        }

        public ProjectionMask withAuditStamp(MaskMap nestedMask) {
            this.getDataMap().put("auditStamp", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withAuditStamp() {
            this._auditStampMask = null;
            this.getDataMap().put("auditStamp", 1);
            return this;
        }

        public ProjectionMask withTarget() {
            this.getDataMap().put("target", 1);
            return this;
        }
    }
}

