/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils.elasticsearch;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.metadata.models.EntitySpec;
import com.linkedin.metadata.utils.SchemaFieldUtils;
import com.linkedin.metadata.utils.elasticsearch.IndexConvention;
import com.linkedin.util.Pair;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class IndexConventionImpl
implements IndexConvention {
    private final Map<String, String> indexNameMapping = new ConcurrentHashMap<String, String>();
    private final Optional<String> _prefix;
    private final String _getAllEntityIndicesPattern;
    private final String _getAllTimeseriesIndicesPattern;
    private final IndexConventionConfig indexConventionConfig;
    private static final String ENTITY_INDEX_VERSION = "v2";
    private static final String ENTITY_INDEX_SUFFIX = "index";
    private static final String TIMESERIES_INDEX_VERSION = "v1";
    private static final String TIMESERIES_ENTITY_INDEX_SUFFIX = "aspect";

    public static IndexConvention noPrefix(@Nonnull String idHashAlgo) {
        return new IndexConventionImpl(IndexConventionConfig.builder().hashIdAlgo(idHashAlgo).build());
    }

    public IndexConventionImpl(IndexConventionConfig indexConventionConfig) {
        this.indexConventionConfig = indexConventionConfig;
        this._prefix = StringUtils.isEmpty(indexConventionConfig.getPrefix()) ? Optional.empty() : Optional.of(indexConventionConfig.getPrefix());
        this._getAllEntityIndicesPattern = this._prefix.map(p -> p + "_").orElse("") + "*index_v2";
        this._getAllTimeseriesIndicesPattern = this._prefix.map(p -> p + "_").orElse("") + "*aspect_v1";
    }

    @Override
    @Nonnull
    public String getIdHashAlgo() {
        return this.indexConventionConfig.getHashIdAlgo();
    }

    private String createIndexName(String baseName) {
        return (this._prefix.map(prefix -> prefix + "_").orElse("") + baseName).toLowerCase();
    }

    private Optional<String> extractIndexBase(String indexName, String indexSuffix) {
        int suffixIndex;
        String prefixString = this._prefix.map(prefix -> prefix + "_").orElse("");
        if (!indexName.startsWith(prefixString)) {
            return Optional.empty();
        }
        int prefixIndex = prefixString.length();
        if (prefixIndex < (suffixIndex = indexName.indexOf(indexSuffix))) {
            return Optional.of(indexName.substring(prefixIndex, suffixIndex));
        }
        return Optional.empty();
    }

    private Optional<String> extractEntityName(String indexName) {
        return this.extractIndexBase(indexName, "index_v2");
    }

    @Override
    public Optional<String> getPrefix() {
        return this._prefix;
    }

    @Override
    @Nonnull
    public String getIndexName(Class<? extends RecordTemplate> documentClass) {
        return this.getIndexName(documentClass.getSimpleName());
    }

    @Override
    @Nonnull
    public String getIndexName(EntitySpec entitySpec) {
        return this.getEntityIndexName(entitySpec.getName());
    }

    @Override
    @Nonnull
    public String getIndexName(String baseIndexName) {
        return this.indexNameMapping.computeIfAbsent(baseIndexName, this::createIndexName);
    }

    @Override
    @Nonnull
    public String getEntityIndexName(String entityName) {
        return this.getIndexName(entityName + "index_v2");
    }

    @Override
    @Nonnull
    public String getTimeseriesAspectIndexName(String entityName, String aspectName) {
        return this.getIndexName(entityName + "_" + aspectName) + "aspect_v1";
    }

    @Override
    @Nonnull
    public String getAllEntityIndicesPattern() {
        return this._getAllEntityIndicesPattern;
    }

    @Override
    @Nonnull
    public String getAllTimeseriesAspectIndicesPattern() {
        return this._getAllTimeseriesIndicesPattern;
    }

    @Override
    public Optional<String> getEntityName(String indexName) {
        return this.extractEntityName(indexName);
    }

    @Override
    public Optional<Pair<String, String>> getEntityAndAspectName(String timeseriesAspectIndexName) {
        String[] entityAndAspectTokens;
        Optional<String> entityAndAspect = this.extractIndexBase(timeseriesAspectIndexName, "aspect_v1");
        if (entityAndAspect.isPresent() && (entityAndAspectTokens = entityAndAspect.get().split("_")).length == 2) {
            return Optional.of(Pair.of(entityAndAspectTokens[0], entityAndAspectTokens[1]));
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public String getEntityDocumentId(Urn entityUrn) {
        String unencodedId = this.indexConventionConfig.schemaFieldDocIdHashEnabled && "schemaField".equals(entityUrn.getEntityType()) ? SchemaFieldUtils.generateDocumentId(entityUrn) : entityUrn.toString();
        return URLEncoder.encode(unencodedId, StandardCharsets.UTF_8);
    }

    @Generated
    public IndexConventionConfig getIndexConventionConfig() {
        return this.indexConventionConfig;
    }

    public static final class IndexConventionConfig {
        private final String hashIdAlgo;
        @Nullable
        private final String prefix;
        private final boolean schemaFieldDocIdHashEnabled;

        @Generated
        private static String $default$hashIdAlgo() {
            return "MD5";
        }

        @Generated
        private static String $default$prefix() {
            return null;
        }

        @Generated
        private static boolean $default$schemaFieldDocIdHashEnabled() {
            return false;
        }

        @Generated
        IndexConventionConfig(String hashIdAlgo, @Nullable String prefix, boolean schemaFieldDocIdHashEnabled) {
            this.hashIdAlgo = hashIdAlgo;
            this.prefix = prefix;
            this.schemaFieldDocIdHashEnabled = schemaFieldDocIdHashEnabled;
        }

        @Generated
        public static IndexConventionConfigBuilder builder() {
            return new IndexConventionConfigBuilder();
        }

        @Generated
        public String getHashIdAlgo() {
            return this.hashIdAlgo;
        }

        @Nullable
        @Generated
        public String getPrefix() {
            return this.prefix;
        }

        @Generated
        public boolean isSchemaFieldDocIdHashEnabled() {
            return this.schemaFieldDocIdHashEnabled;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IndexConventionConfig)) {
                return false;
            }
            IndexConventionConfig other = (IndexConventionConfig)o;
            if (this.isSchemaFieldDocIdHashEnabled() != other.isSchemaFieldDocIdHashEnabled()) {
                return false;
            }
            String this$hashIdAlgo = this.getHashIdAlgo();
            String other$hashIdAlgo = other.getHashIdAlgo();
            if (this$hashIdAlgo == null ? other$hashIdAlgo != null : !this$hashIdAlgo.equals(other$hashIdAlgo)) {
                return false;
            }
            String this$prefix = this.getPrefix();
            String other$prefix = other.getPrefix();
            return !(this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSchemaFieldDocIdHashEnabled() ? 79 : 97);
            String $hashIdAlgo = this.getHashIdAlgo();
            result = result * 59 + ($hashIdAlgo == null ? 43 : $hashIdAlgo.hashCode());
            String $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "IndexConventionImpl.IndexConventionConfig(hashIdAlgo=" + this.getHashIdAlgo() + ", prefix=" + this.getPrefix() + ", schemaFieldDocIdHashEnabled=" + this.isSchemaFieldDocIdHashEnabled() + ")";
        }

        @Generated
        public static class IndexConventionConfigBuilder {
            @Generated
            private boolean hashIdAlgo$set;
            @Generated
            private String hashIdAlgo$value;
            @Generated
            private boolean prefix$set;
            @Generated
            private String prefix$value;
            @Generated
            private boolean schemaFieldDocIdHashEnabled$set;
            @Generated
            private boolean schemaFieldDocIdHashEnabled$value;

            @Generated
            IndexConventionConfigBuilder() {
            }

            @Generated
            public IndexConventionConfigBuilder hashIdAlgo(String hashIdAlgo) {
                this.hashIdAlgo$value = hashIdAlgo;
                this.hashIdAlgo$set = true;
                return this;
            }

            @Generated
            public IndexConventionConfigBuilder prefix(@Nullable String prefix) {
                this.prefix$value = prefix;
                this.prefix$set = true;
                return this;
            }

            @Generated
            public IndexConventionConfigBuilder schemaFieldDocIdHashEnabled(boolean schemaFieldDocIdHashEnabled) {
                this.schemaFieldDocIdHashEnabled$value = schemaFieldDocIdHashEnabled;
                this.schemaFieldDocIdHashEnabled$set = true;
                return this;
            }

            @Generated
            public IndexConventionConfig build() {
                String hashIdAlgo$value = this.hashIdAlgo$value;
                if (!this.hashIdAlgo$set) {
                    hashIdAlgo$value = IndexConventionConfig.$default$hashIdAlgo();
                }
                String prefix$value = this.prefix$value;
                if (!this.prefix$set) {
                    prefix$value = IndexConventionConfig.$default$prefix();
                }
                boolean schemaFieldDocIdHashEnabled$value = this.schemaFieldDocIdHashEnabled$value;
                if (!this.schemaFieldDocIdHashEnabled$set) {
                    schemaFieldDocIdHashEnabled$value = IndexConventionConfig.$default$schemaFieldDocIdHashEnabled();
                }
                return new IndexConventionConfig(hashIdAlgo$value, prefix$value, schemaFieldDocIdHashEnabled$value);
            }

            @Generated
            public String toString() {
                return "IndexConventionImpl.IndexConventionConfig.IndexConventionConfigBuilder(hashIdAlgo$value=" + this.hashIdAlgo$value + ", prefix$value=" + this.prefix$value + ", schemaFieldDocIdHashEnabled$value=" + this.schemaFieldDocIdHashEnabled$value + ")";
            }
        }
    }
}

