/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.snapshot;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.metadata.aspect.SchemaFieldAspectArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SchemaFieldSnapshot
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.snapshot/**A metadata snapshot for a specific schema field entity.*/@Entity={\"keyAspect\":\"schemaFieldKey\",\"name\":\"schemaField\"}record SchemaFieldSnapshot{/**URN for the entity the metadata snapshot is associated with.*/urn:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**The list of metadata aspects associated with the dataset. Depending on the use case, this can either be all, or a selection, of supported aspects.*/aspects:array[{namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a SchemaField*/typeref SchemaFieldAspect=union[{namespace com.linkedin.metadata.key/**Key for a SchemaField*/@Aspect.name=\"schemaFieldKey\"record SchemaFieldKey{/**Parent associated with the schema field*/@Searchable.fieldType=\"URN\"parent:com.linkedin.common.Urn/**fieldPath identifying the schema field*/@Searchable.fieldType=\"KEYWORD\"fieldPath:string}}]}]}", SchemaFormatType.PDL);
    private Urn _urnField = null;
    private SchemaFieldAspectArray _aspectsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Urn = SCHEMA.getField("urn");
    private static final RecordDataSchema.Field FIELD_Aspects = SCHEMA.getField("aspects");

    public SchemaFieldSnapshot() {
        super(new DataMap(3, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public SchemaFieldSnapshot(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasUrn() {
        if (this._urnField != null) {
            return true;
        }
        return this._map.containsKey("urn");
    }

    public void removeUrn() {
        this._map.remove("urn");
    }

    @Nullable
    public Urn getUrn(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getUrn();
            }
            case DEFAULT: 
            case NULL: {
                if (this._urnField != null) {
                    return this._urnField;
                }
                Object __rawValue = this._map.get("urn");
                this._urnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._urnField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getUrn() {
        if (this._urnField != null) {
            return this._urnField;
        }
        Object __rawValue = this._map.get("urn");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("urn");
        }
        this._urnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._urnField;
    }

    public SchemaFieldSnapshot setUrn(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field urn of com.linkedin.metadata.snapshot.SchemaFieldSnapshot");
                }
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._urnField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._urnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._urnField = value;
            }
        }
        return this;
    }

    public SchemaFieldSnapshot setUrn(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field urn of com.linkedin.metadata.snapshot.SchemaFieldSnapshot to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._urnField = value;
        return this;
    }

    public boolean hasAspects() {
        if (this._aspectsField != null) {
            return true;
        }
        return this._map.containsKey("aspects");
    }

    public void removeAspects() {
        this._map.remove("aspects");
    }

    @Nullable
    public SchemaFieldAspectArray getAspects(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAspects();
            }
            case DEFAULT: 
            case NULL: {
                if (this._aspectsField != null) {
                    return this._aspectsField;
                }
                Object __rawValue = this._map.get("aspects");
                this._aspectsField = __rawValue == null ? null : new SchemaFieldAspectArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._aspectsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public SchemaFieldAspectArray getAspects() {
        if (this._aspectsField != null) {
            return this._aspectsField;
        }
        Object __rawValue = this._map.get("aspects");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("aspects");
        }
        this._aspectsField = __rawValue == null ? null : new SchemaFieldAspectArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._aspectsField;
    }

    public SchemaFieldSnapshot setAspects(@Nullable SchemaFieldAspectArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAspects(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field aspects of com.linkedin.metadata.snapshot.SchemaFieldSnapshot");
                }
                CheckedUtil.putWithoutChecking(this._map, "aspects", value.data());
                this._aspectsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAspects();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "aspects", value.data());
                this._aspectsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "aspects", value.data());
                this._aspectsField = value;
            }
        }
        return this;
    }

    public SchemaFieldSnapshot setAspects(@Nonnull SchemaFieldAspectArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field aspects of com.linkedin.metadata.snapshot.SchemaFieldSnapshot to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "aspects", value.data());
        this._aspectsField = value;
        return this;
    }

    @Override
    public SchemaFieldSnapshot clone() throws CloneNotSupportedException {
        SchemaFieldSnapshot __clone = (SchemaFieldSnapshot)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public SchemaFieldSnapshot copy() throws CloneNotSupportedException {
        SchemaFieldSnapshot __copy = (SchemaFieldSnapshot)super.copy();
        __copy._urnField = null;
        __copy._aspectsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final SchemaFieldSnapshot __objectRef;

        private ChangeListener(SchemaFieldSnapshot reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "urn": {
                    this.__objectRef._urnField = null;
                    break;
                }
                case "aspects": {
                    this.__objectRef._aspectsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec urn() {
            return new PathSpec(this.getPathComponents(), "urn");
        }

        public SchemaFieldAspectArray.Fields aspects() {
            return new SchemaFieldAspectArray.Fields(this.getPathComponents(), "aspects");
        }

        public PathSpec aspects(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "aspects");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private SchemaFieldAspectArray.ProjectionMask _aspectsMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withUrn() {
            this.getDataMap().put("urn", 1);
            return this;
        }

        public ProjectionMask withAspects(Function<SchemaFieldAspectArray.ProjectionMask, SchemaFieldAspectArray.ProjectionMask> nestedMask) {
            this._aspectsMask = nestedMask.apply(this._aspectsMask == null ? SchemaFieldAspectArray.createMask() : this._aspectsMask);
            this.getDataMap().put("aspects", this._aspectsMask.getDataMap());
            return this;
        }

        public ProjectionMask withAspects() {
            this._aspectsMask = null;
            this.getDataMap().put("aspects", 1);
            return this;
        }

        public ProjectionMask withAspects(Function<SchemaFieldAspectArray.ProjectionMask, SchemaFieldAspectArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._aspectsMask = nestedMask.apply(this._aspectsMask == null ? SchemaFieldAspectArray.createMask() : this._aspectsMask);
            this.getDataMap().put("aspects", this._aspectsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("aspects").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("aspects").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withAspects(Integer start, Integer count) {
            this._aspectsMask = null;
            this.getDataMap().put("aspects", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("aspects").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("aspects").put("$count", count);
            }
            return this;
        }
    }
}

