/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.search;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.metadata.search.MatchedField;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class MatchedFieldArray
extends WrappingArrayTemplate<MatchedField> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.metadata.search,record MatchedField{/**Matched field name*/name:string/**Matched field value*/value:string}}]", SchemaFormatType.PDL);

    public MatchedFieldArray() {
        this(new DataList());
    }

    public MatchedFieldArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public MatchedFieldArray(Collection<MatchedField> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public MatchedFieldArray(DataList data) {
        super(data, SCHEMA, MatchedField.class);
    }

    public MatchedFieldArray(MatchedField first, MatchedField ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public MatchedFieldArray clone() throws CloneNotSupportedException {
        MatchedFieldArray __clone = (MatchedFieldArray)super.clone();
        return __clone;
    }

    @Override
    public MatchedFieldArray copy() throws CloneNotSupportedException {
        MatchedFieldArray __copy = (MatchedFieldArray)super.copy();
        return __copy;
    }

    @Override
    protected MatchedField coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new MatchedField(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private MatchedField.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<MatchedField.ProjectionMask, MatchedField.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? MatchedField.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public MatchedField.Fields items() {
            return new MatchedField.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

