/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.query;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.metadata.query.AutoCompleteEntity;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class AutoCompleteEntityArray
extends WrappingArrayTemplate<AutoCompleteEntity> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.metadata.query/**Data model for an entity returned as an autocomplete suggestion*/record AutoCompleteEntity{/**Urn of the entity*/urn:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}}]", SchemaFormatType.PDL);

    public AutoCompleteEntityArray() {
        this(new DataList());
    }

    public AutoCompleteEntityArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public AutoCompleteEntityArray(Collection<AutoCompleteEntity> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public AutoCompleteEntityArray(DataList data) {
        super(data, SCHEMA, AutoCompleteEntity.class);
    }

    public AutoCompleteEntityArray(AutoCompleteEntity first, AutoCompleteEntity ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public AutoCompleteEntityArray clone() throws CloneNotSupportedException {
        AutoCompleteEntityArray __clone = (AutoCompleteEntityArray)super.clone();
        return __clone;
    }

    @Override
    public AutoCompleteEntityArray copy() throws CloneNotSupportedException {
        AutoCompleteEntityArray __copy = (AutoCompleteEntityArray)super.copy();
        return __copy;
    }

    @Override
    protected AutoCompleteEntity coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new AutoCompleteEntity(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private AutoCompleteEntity.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<AutoCompleteEntity.ProjectionMask, AutoCompleteEntity.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? AutoCompleteEntity.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public AutoCompleteEntity.Fields items() {
            return new AutoCompleteEntity.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

