/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.annotation;

import com.linkedin.metadata.models.ModelValidationException;
import com.linkedin.metadata.models.annotation.AnnotationUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.Generated;

public final class RelationshipAnnotation {
    public static final String ANNOTATION_NAME = "Relationship";
    private static final String NAME_FIELD = "name";
    private static final String ENTITY_TYPES_FIELD = "entityTypes";
    private static final String IS_UPSTREAM_FIELD = "isUpstream";
    private static final String IS_LINEAGE_FIELD = "isLineage";
    private static final String CREATED_ON = "createdOn";
    private static final String CREATED_ACTOR = "createdActor";
    private static final String UPDATED_ON = "updatedOn";
    private static final String UPDATED_ACTOR = "updatedActor";
    private static final String PROPERTIES = "properties";
    private static final String VIA = "via";
    private final String name;
    private final List<String> validDestinationTypes;
    private final boolean isUpstream;
    private final boolean isLineage;
    private final String createdOn;
    private final String createdActor;
    private final String updatedOn;
    private final String updatedActor;
    private final String properties;
    private final String via;

    @Nonnull
    public static RelationshipAnnotation fromPegasusAnnotationObject(@Nonnull Object annotationObj, @Nonnull String context) {
        if (!Map.class.isAssignableFrom(annotationObj.getClass())) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: Invalid value type provided (Expected Map)", ANNOTATION_NAME, context));
        }
        Map map = (Map)annotationObj;
        Optional<String> name = AnnotationUtils.getField(map, NAME_FIELD, String.class);
        if (!name.isPresent()) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation at %s: Invalid field '%s'. Expected type String", ANNOTATION_NAME, context, NAME_FIELD));
        }
        Optional<List> entityTypesList = AnnotationUtils.getField(map, ENTITY_TYPES_FIELD, List.class);
        ArrayList<String> entityTypes = new ArrayList<String>();
        if (entityTypesList.isPresent()) {
            for (Object entityTypeObj : entityTypesList.get()) {
                if (!String.class.isAssignableFrom(entityTypeObj.getClass())) {
                    throw new ModelValidationException(String.format("Failed to validate @%s annotation at %s: Invalid field '%s'. Expected type List<String>", ANNOTATION_NAME, context, ENTITY_TYPES_FIELD));
                }
                entityTypes.add((String)entityTypeObj);
            }
        }
        Optional<Boolean> isUpstream = AnnotationUtils.getField(map, IS_UPSTREAM_FIELD, Boolean.class);
        Optional<Boolean> isLineage = AnnotationUtils.getField(map, IS_LINEAGE_FIELD, Boolean.class);
        Optional<String> createdOn = AnnotationUtils.getField(map, CREATED_ON, String.class);
        Optional<String> createdActor = AnnotationUtils.getField(map, CREATED_ACTOR, String.class);
        Optional<String> updatedOn = AnnotationUtils.getField(map, UPDATED_ON, String.class);
        Optional<String> updatedActor = AnnotationUtils.getField(map, UPDATED_ACTOR, String.class);
        Optional<String> properties = AnnotationUtils.getField(map, PROPERTIES, String.class);
        Optional<String> via = AnnotationUtils.getField(map, VIA, String.class);
        return new RelationshipAnnotation(name.get(), entityTypes, isUpstream.orElse(true), isLineage.orElse(false), createdOn.orElse(null), createdActor.orElse(null), updatedOn.orElse(null), updatedActor.orElse(null), properties.orElse(null), via.orElse(null));
    }

    public RelationshipAnnotation(String name, List<String> validDestinationTypes, boolean isUpstream, boolean isLineage, String createdOn, String createdActor, String updatedOn, String updatedActor, String properties) {
        this(name, validDestinationTypes, isUpstream, isLineage, createdOn, createdActor, updatedOn, updatedActor, properties, null);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<String> getValidDestinationTypes() {
        return this.validDestinationTypes;
    }

    @Generated
    public boolean isUpstream() {
        return this.isUpstream;
    }

    @Generated
    public boolean isLineage() {
        return this.isLineage;
    }

    @Generated
    public String getCreatedOn() {
        return this.createdOn;
    }

    @Generated
    public String getCreatedActor() {
        return this.createdActor;
    }

    @Generated
    public String getUpdatedOn() {
        return this.updatedOn;
    }

    @Generated
    public String getUpdatedActor() {
        return this.updatedActor;
    }

    @Generated
    public String getProperties() {
        return this.properties;
    }

    @Generated
    public String getVia() {
        return this.via;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelationshipAnnotation)) {
            return false;
        }
        RelationshipAnnotation other = (RelationshipAnnotation)o;
        if (this.isUpstream() != other.isUpstream()) {
            return false;
        }
        if (this.isLineage() != other.isLineage()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$validDestinationTypes = this.getValidDestinationTypes();
        List<String> other$validDestinationTypes = other.getValidDestinationTypes();
        if (this$validDestinationTypes == null ? other$validDestinationTypes != null : !((Object)this$validDestinationTypes).equals(other$validDestinationTypes)) {
            return false;
        }
        String this$createdOn = this.getCreatedOn();
        String other$createdOn = other.getCreatedOn();
        if (this$createdOn == null ? other$createdOn != null : !this$createdOn.equals(other$createdOn)) {
            return false;
        }
        String this$createdActor = this.getCreatedActor();
        String other$createdActor = other.getCreatedActor();
        if (this$createdActor == null ? other$createdActor != null : !this$createdActor.equals(other$createdActor)) {
            return false;
        }
        String this$updatedOn = this.getUpdatedOn();
        String other$updatedOn = other.getUpdatedOn();
        if (this$updatedOn == null ? other$updatedOn != null : !this$updatedOn.equals(other$updatedOn)) {
            return false;
        }
        String this$updatedActor = this.getUpdatedActor();
        String other$updatedActor = other.getUpdatedActor();
        if (this$updatedActor == null ? other$updatedActor != null : !this$updatedActor.equals(other$updatedActor)) {
            return false;
        }
        String this$properties = this.getProperties();
        String other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
            return false;
        }
        String this$via = this.getVia();
        String other$via = other.getVia();
        return !(this$via == null ? other$via != null : !this$via.equals(other$via));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUpstream() ? 79 : 97);
        result = result * 59 + (this.isLineage() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $validDestinationTypes = this.getValidDestinationTypes();
        result = result * 59 + ($validDestinationTypes == null ? 43 : ((Object)$validDestinationTypes).hashCode());
        String $createdOn = this.getCreatedOn();
        result = result * 59 + ($createdOn == null ? 43 : $createdOn.hashCode());
        String $createdActor = this.getCreatedActor();
        result = result * 59 + ($createdActor == null ? 43 : $createdActor.hashCode());
        String $updatedOn = this.getUpdatedOn();
        result = result * 59 + ($updatedOn == null ? 43 : $updatedOn.hashCode());
        String $updatedActor = this.getUpdatedActor();
        result = result * 59 + ($updatedActor == null ? 43 : $updatedActor.hashCode());
        String $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        String $via = this.getVia();
        result = result * 59 + ($via == null ? 43 : $via.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RelationshipAnnotation(name=" + this.getName() + ", validDestinationTypes=" + String.valueOf(this.getValidDestinationTypes()) + ", isUpstream=" + this.isUpstream() + ", isLineage=" + this.isLineage() + ", createdOn=" + this.getCreatedOn() + ", createdActor=" + this.getCreatedActor() + ", updatedOn=" + this.getUpdatedOn() + ", updatedActor=" + this.getUpdatedActor() + ", properties=" + this.getProperties() + ", via=" + this.getVia() + ")";
    }

    @Generated
    public RelationshipAnnotation(String name, List<String> validDestinationTypes, boolean isUpstream, boolean isLineage, String createdOn, String createdActor, String updatedOn, String updatedActor, String properties, String via) {
        this.name = name;
        this.validDestinationTypes = validDestinationTypes;
        this.isUpstream = isUpstream;
        this.isLineage = isLineage;
        this.createdOn = createdOn;
        this.createdActor = createdActor;
        this.updatedOn = updatedOn;
        this.updatedActor = updatedActor;
        this.properties = properties;
        this.via = via;
    }
}

