/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.annotation;

import com.linkedin.data.DataMap;
import com.linkedin.metadata.models.ModelValidationException;
import com.linkedin.metadata.models.annotation.AnnotationUtils;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.Generated;

public final class AspectAnnotation {
    public static final String ANNOTATION_NAME = "Aspect";
    public static final String NAME_FIELD = "name";
    private static final String TYPE_FIELD = "type";
    private static final String RENDER_SPEC_FIELD = "renderSpec";
    private static final String AUTO_RENDER_FIELD = "autoRender";
    private static final String IS_KEY_FIELD = "isKey";
    private static final String TIMESERIES_TYPE = "timeseries";
    private final String name;
    private final boolean isTimeseries;
    private final boolean autoRender;
    private final DataMap renderSpec;

    @Nonnull
    public static AspectAnnotation fromSchemaProperty(@Nonnull Object annotationObj, @Nonnull String context) {
        if (!Map.class.isAssignableFrom(annotationObj.getClass())) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: Invalid value type provided (Expected Map)", ANNOTATION_NAME, context));
        }
        Map map = (Map)annotationObj;
        Optional<String> name = AnnotationUtils.getField(map, NAME_FIELD, String.class);
        if (!name.isPresent()) {
            throw new ModelValidationException(String.format("Failed to validated @%s annotation declared at %s: missing '%s' property", ANNOTATION_NAME, context, NAME_FIELD));
        }
        Optional<String> type = AnnotationUtils.getField(map, TYPE_FIELD, String.class);
        boolean isTimeseries = type.isPresent() && type.get().equals(TIMESERIES_TYPE);
        Optional<Boolean> autoRender = AnnotationUtils.getField(map, AUTO_RENDER_FIELD, Boolean.class);
        Optional<DataMap> renderSpec = AnnotationUtils.getField(map, RENDER_SPEC_FIELD, DataMap.class);
        return new AspectAnnotation(name.get(), isTimeseries, autoRender.orElseGet(() -> false), renderSpec.orElseGet(() -> null));
    }

    @Generated
    public AspectAnnotation(String name, boolean isTimeseries, boolean autoRender, DataMap renderSpec) {
        this.name = name;
        this.isTimeseries = isTimeseries;
        this.autoRender = autoRender;
        this.renderSpec = renderSpec;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean isTimeseries() {
        return this.isTimeseries;
    }

    @Generated
    public boolean isAutoRender() {
        return this.autoRender;
    }

    @Generated
    public DataMap getRenderSpec() {
        return this.renderSpec;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AspectAnnotation)) {
            return false;
        }
        AspectAnnotation other = (AspectAnnotation)o;
        if (this.isTimeseries() != other.isTimeseries()) {
            return false;
        }
        if (this.isAutoRender() != other.isAutoRender()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        DataMap this$renderSpec = this.getRenderSpec();
        DataMap other$renderSpec = other.getRenderSpec();
        return !(this$renderSpec == null ? other$renderSpec != null : !((Object)this$renderSpec).equals(other$renderSpec));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTimeseries() ? 79 : 97);
        result = result * 59 + (this.isAutoRender() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        DataMap $renderSpec = this.getRenderSpec();
        result = result * 59 + ($renderSpec == null ? 43 : ((Object)$renderSpec).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AspectAnnotation(name=" + this.getName() + ", isTimeseries=" + this.isTimeseries() + ", autoRender=" + this.isAutoRender() + ", renderSpec=" + String.valueOf(this.getRenderSpec()) + ")";
    }
}

