/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.metadata.models.DefaultEventSpec;
import com.linkedin.metadata.models.EventSpec;
import com.linkedin.metadata.models.ModelValidationException;
import com.linkedin.metadata.models.annotation.EventAnnotation;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSpecBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventSpecBuilder.class);

    public EventSpec buildEventSpec(@Nonnull String eventName, @Nonnull DataSchema eventDataSchema) {
        RecordDataSchema eventRecordSchema = this.validateEvent(eventDataSchema);
        Object eventAnnotationObj = eventDataSchema.getProperties().get("Event");
        if (eventAnnotationObj != null) {
            EventAnnotation eventAnnotation = EventAnnotation.fromPegasusAnnotationObject(eventAnnotationObj, eventRecordSchema.getFullName());
            return new DefaultEventSpec(eventName, eventAnnotation, eventRecordSchema);
        }
        return null;
    }

    private RecordDataSchema validateEvent(@Nonnull DataSchema eventSchema) {
        if (eventSchema.getType() != DataSchema.Type.RECORD) {
            this.failValidation(String.format("Failed to validate event schema of type %s. Schema must be of record type.", eventSchema.getType().toString()));
        }
        return (RecordDataSchema)eventSchema;
    }

    private void failValidation(@Nonnull String message) {
        throw new ModelValidationException(message);
    }
}

