/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.entity.ebean.batch;

import com.datahub.authorization.AuthorizationSession;
import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.events.metadata.ChangeType;
import com.linkedin.metadata.aspect.AspectRetriever;
import com.linkedin.metadata.aspect.RetrieverContext;
import com.linkedin.metadata.aspect.SystemAspect;
import com.linkedin.metadata.aspect.batch.AspectsBatch;
import com.linkedin.metadata.aspect.batch.BatchItem;
import com.linkedin.metadata.aspect.batch.ChangeMCP;
import com.linkedin.metadata.aspect.batch.MCPItem;
import com.linkedin.metadata.aspect.plugins.hooks.MutationHook;
import com.linkedin.metadata.aspect.plugins.validation.ValidationExceptionCollection;
import com.linkedin.metadata.entity.ebean.batch.ChangeItemImpl;
import com.linkedin.metadata.entity.ebean.batch.PatchItemImpl;
import com.linkedin.metadata.entity.ebean.batch.ProposedItem;
import com.linkedin.metadata.entity.validation.ValidationException;
import com.linkedin.mxe.MetadataChangeProposal;
import com.linkedin.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspectsBatchImpl
implements AspectsBatch {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AspectsBatchImpl.class);
    @Nonnull
    private final Collection<? extends BatchItem> items;
    @Nonnull
    private final Collection<? extends BatchItem> nonRepeatedItems;
    @Nonnull
    private final RetrieverContext retrieverContext;

    @Override
    @Nonnull
    public Collection<? extends BatchItem> getItems() {
        return this.nonRepeatedItems;
    }

    @Override
    public Collection<? extends BatchItem> getInitialItems() {
        return this.items;
    }

    @Override
    public Pair<Map<String, Set<String>>, List<ChangeMCP>> toUpsertBatchItems(Map<String, Map<String, SystemAspect>> latestAspects, Map<String, Map<String, Long>> nextVersions, BiFunction<ChangeMCP, SystemAspect, SystemAspect> databaseUpsert) {
        Stream<? extends BatchItem> mutatedProposalsStream = this.proposedItemsToChangeItemStream(this.items.stream().filter(item -> item instanceof ProposedItem).map(item -> (MCPItem)item).collect(Collectors.toList()));
        Stream<BatchItem> changeMCPStream = this.items.stream().filter(item -> !(item instanceof ProposedItem));
        LinkedList upsertBatchItems = Stream.concat(mutatedProposalsStream, changeMCPStream).map(item -> {
            ChangeItemImpl upsertItem;
            String urnStr = item.getUrn().toString();
            SystemAspect latest = (SystemAspect)latestAspects.getOrDefault(urnStr, Map.of()).get(item.getAspectName());
            if (item instanceof ChangeItemImpl) {
                upsertItem = (ChangeItemImpl)item;
            } else {
                PatchItemImpl patchBatchItem = (PatchItemImpl)item;
                RecordTemplate currentValue = latest != null ? latest.getRecordTemplate() : null;
                upsertItem = patchBatchItem.applyPatch(currentValue, this.retrieverContext.getAspectRetriever());
            }
            return AspectsBatch.incrementBatchVersion(upsertItem, latestAspects, nextVersions, databaseUpsert);
        }).collect(Collectors.toCollection(LinkedList::new));
        this.applyWriteMutationHooks(upsertBatchItems);
        LinkedList newItems = this.applyMCPSideEffects(upsertBatchItems).collect(Collectors.toCollection(LinkedList::new));
        upsertBatchItems.addAll(newItems);
        Map<String, Set<String>> newUrnAspectNames = this.getNewUrnAspectsMap(this.getUrnAspectsMap(), upsertBatchItems);
        return Pair.of(newUrnAspectNames, upsertBatchItems);
    }

    private Stream<? extends BatchItem> proposedItemsToChangeItemStream(List<MCPItem> proposedItems) {
        List<MutationHook> mutationHooks = this.retrieverContext.getAspectRetriever().getEntityRegistry().getAllMutationHooks();
        Stream<BatchItem> unmutatedItems = proposedItems.stream().filter(proposedItem -> mutationHooks.stream().noneMatch(mutationHook -> mutationHook.shouldApply(proposedItem.getChangeType(), proposedItem.getUrn(), proposedItem.getAspectName()))).map(mcpItem -> AspectsBatchImpl.patchDiscriminator(mcpItem, this.retrieverContext.getAspectRetriever()));
        List mutatedItems = this.applyProposalMutationHooks(proposedItems, this.retrieverContext).collect(Collectors.toList());
        Stream<BatchItem> proposedItemsToChangeItems = mutatedItems.stream().filter(mcpItem -> mcpItem.getMetadataChangeProposal() != null).filter(mcpItem -> mcpItem instanceof ProposedItem).map(mcpItem -> AspectsBatchImpl.patchDiscriminator(mcpItem, this.retrieverContext.getAspectRetriever()));
        Stream<MCPItem> sideEffectItems = mutatedItems.stream().filter(mcpItem -> !(mcpItem instanceof ProposedItem));
        Stream<BatchItem> combinedChangeItems = Stream.concat(proposedItemsToChangeItems, unmutatedItems);
        return Stream.concat(combinedChangeItems, sideEffectItems);
    }

    private static BatchItem patchDiscriminator(MCPItem mcpItem, AspectRetriever aspectRetriever) {
        if (ChangeType.PATCH.equals((Object)mcpItem.getChangeType())) {
            return PatchItemImpl.builder().build(mcpItem.getMetadataChangeProposal(), mcpItem.getAuditStamp(), aspectRetriever.getEntityRegistry());
        }
        return ChangeItemImpl.builder().build(mcpItem.getMetadataChangeProposal(), mcpItem.getAuditStamp(), aspectRetriever);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AspectsBatchImpl that = (AspectsBatchImpl)o;
        return Objects.equals(this.items, that.items);
    }

    public int hashCode() {
        return Objects.hash(this.items);
    }

    public String toString() {
        return "AspectsBatchImpl{items=" + String.valueOf(this.items) + "}";
    }

    @Generated
    AspectsBatchImpl(@Nonnull Collection<? extends BatchItem> items, @Nonnull Collection<? extends BatchItem> nonRepeatedItems, @Nonnull RetrieverContext retrieverContext) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        if (nonRepeatedItems == null) {
            throw new NullPointerException("nonRepeatedItems is marked non-null but is null");
        }
        if (retrieverContext == null) {
            throw new NullPointerException("retrieverContext is marked non-null but is null");
        }
        this.items = items;
        this.nonRepeatedItems = nonRepeatedItems;
        this.retrieverContext = retrieverContext;
    }

    @Generated
    public static AspectsBatchImplBuilder builder() {
        return new AspectsBatchImplBuilder();
    }

    @Generated
    public AspectsBatchImplBuilder toBuilder() {
        return new AspectsBatchImplBuilder().items(this.items).nonRepeatedItems(this.nonRepeatedItems).retrieverContext(this.retrieverContext);
    }

    @Override
    @Nonnull
    @Generated
    public RetrieverContext getRetrieverContext() {
        return this.retrieverContext;
    }

    public static class AspectsBatchImplBuilder {
        @Generated
        private Collection<? extends BatchItem> items;
        @Generated
        private Collection<? extends BatchItem> nonRepeatedItems;
        @Generated
        private RetrieverContext retrieverContext;

        public AspectsBatchImplBuilder one(BatchItem data, RetrieverContext retrieverContext) {
            this.retrieverContext(retrieverContext);
            this.items(List.of(data));
            return this;
        }

        public AspectsBatchImplBuilder mcps(Collection<MetadataChangeProposal> mcps, AuditStamp auditStamp, RetrieverContext retrieverContext) {
            return this.mcps(mcps, auditStamp, retrieverContext, false);
        }

        public AspectsBatchImplBuilder mcps(Collection<MetadataChangeProposal> mcps, AuditStamp auditStamp, RetrieverContext retrieverContext, boolean alternateMCPValidation) {
            this.retrieverContext(retrieverContext);
            this.items(mcps.stream().map(mcp -> {
                try {
                    if (alternateMCPValidation) {
                        return ProposedItem.builder().build((MetadataChangeProposal)mcp, auditStamp, retrieverContext.getAspectRetriever().getEntityRegistry());
                    }
                    if (mcp.getChangeType().equals((Object)ChangeType.PATCH)) {
                        return PatchItemImpl.builder().build((MetadataChangeProposal)mcp, auditStamp, retrieverContext.getAspectRetriever().getEntityRegistry());
                    }
                    return ChangeItemImpl.builder().build((MetadataChangeProposal)mcp, auditStamp, retrieverContext.getAspectRetriever());
                }
                catch (IllegalArgumentException e) {
                    log.error("Invalid proposal, skipping and proceeding with batch: {}", mcp, (Object)e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList()));
            return this;
        }

        private static <T extends BatchItem> List<T> filterRepeats(Collection<T> items) {
            ArrayList<BatchItem> result = new ArrayList<BatchItem>();
            HashMap<Pair<Urn, String>, BatchItem> last = new HashMap<Pair<Urn, String>, BatchItem>();
            for (BatchItem item : items) {
                Pair<Urn, String> urnAspect = Pair.of(item.getUrn(), item.getAspectName());
                if (!last.containsKey(urnAspect) || !item.isDatabaseDuplicateOf((BatchItem)last.get(urnAspect))) {
                    result.add(item);
                }
                last.put(urnAspect, item);
            }
            return result;
        }

        public AspectsBatchImpl build(@Nullable AuthorizationSession session) {
            if (this.items == null) {
                this.items = Collections.emptyList();
            }
            this.nonRepeatedItems = AspectsBatchImplBuilder.filterRepeats(this.items);
            ValidationExceptionCollection exceptions = AspectsBatch.validateProposed(this.nonRepeatedItems, this.retrieverContext, session);
            if (!exceptions.isEmpty()) {
                throw new ValidationException("Failed to validate MCP due to: " + String.valueOf(exceptions));
            }
            return new AspectsBatchImpl(this.items, this.nonRepeatedItems, this.retrieverContext);
        }

        private AspectsBatchImpl build() {
            return null;
        }

        @Generated
        AspectsBatchImplBuilder() {
        }

        @Generated
        public AspectsBatchImplBuilder items(@Nonnull Collection<? extends BatchItem> items) {
            if (items == null) {
                throw new NullPointerException("items is marked non-null but is null");
            }
            this.items = items;
            return this;
        }

        @Generated
        public AspectsBatchImplBuilder nonRepeatedItems(@Nonnull Collection<? extends BatchItem> nonRepeatedItems) {
            if (nonRepeatedItems == null) {
                throw new NullPointerException("nonRepeatedItems is marked non-null but is null");
            }
            this.nonRepeatedItems = nonRepeatedItems;
            return this;
        }

        @Generated
        public AspectsBatchImplBuilder retrieverContext(@Nonnull RetrieverContext retrieverContext) {
            if (retrieverContext == null) {
                throw new NullPointerException("retrieverContext is marked non-null but is null");
            }
            this.retrieverContext = retrieverContext;
            return this;
        }

        @Generated
        public String toString() {
            return "AspectsBatchImpl.AspectsBatchImplBuilder(items=" + String.valueOf(this.items) + ", nonRepeatedItems=" + String.valueOf(this.nonRepeatedItems) + ", retrieverContext=" + String.valueOf(this.retrieverContext) + ")";
        }
    }
}

