/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.entity;

import com.google.common.collect.ImmutableList;
import com.linkedin.metadata.query.SearchFlags;
import com.linkedin.metadata.query.filter.Filter;
import com.linkedin.metadata.query.filter.SortCriterion;
import com.linkedin.metadata.query.filter.SortOrder;
import com.linkedin.metadata.search.ScrollResult;
import com.linkedin.metadata.search.SearchEntityArray;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface SearchRetriever {
    public static final SearchFlags RETRIEVER_SEARCH_FLAGS = new SearchFlags().setFulltext(false).setMaxAggValues(20).setSkipCache(false).setSkipAggregates(true).setSkipHighlighting(true).setIncludeSoftDeleted(false).setIncludeRestricted(false);
    public static final SearchFlags RETRIEVER_SEARCH_FLAGS_NO_CACHE_ALL_VERSIONS = new SearchFlags().setFulltext(false).setMaxAggValues(20).setSkipCache(true).setSkipAggregates(true).setSkipHighlighting(true).setIncludeSoftDeleted(false).setIncludeRestricted(false).setFilterNonLatestVersions(false);
    public static final SearchRetriever EMPTY = new EmptySearchRetriever();

    public ScrollResult scroll(@Nonnull List<String> var1, @Nullable Filter var2, @Nullable String var3, @Nullable Integer var4, List<SortCriterion> var5, @Nullable SearchFlags var6);

    default public ScrollResult scroll(@Nonnull List<String> entities, @Nullable Filter filters, @Nullable String scrollId, @Nullable Integer count) {
        SortCriterion urnSort = new SortCriterion();
        urnSort.setField("urn");
        urnSort.setOrder(SortOrder.ASCENDING);
        return this.scroll(entities, filters, scrollId, count, ImmutableList.of(urnSort), RETRIEVER_SEARCH_FLAGS);
    }

    public static class EmptySearchRetriever
    implements SearchRetriever {
        @Override
        public ScrollResult scroll(@Nonnull List<String> entities, @Nullable Filter filters, @Nullable String scrollId, @Nullable Integer count, List<SortCriterion> sortCriteria, @Nullable SearchFlags searchFlags) {
            ScrollResult empty = new ScrollResult();
            empty.setEntities(new SearchEntityArray());
            empty.setNumEntities(0);
            empty.setPageSize(0);
            return empty;
        }
    }
}

