/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.browse;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.metadata.browse.BrowseResultGroupV2Array;
import com.linkedin.metadata.browse.BrowseResultMetadata;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BrowseResultV2
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.browse/**The model for the result of a browseV2 query*/record BrowseResultV2{/**A list of groups and total number of entities inside those groups under the queried path*/groups:array[/**The model for the result of a browse query*/record BrowseResultGroupV2{/**Name of the group*/name:string/**Urn of the group if this is an entity*/urn:optional{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**Number of entities that can be reached from this path*/count:long/**Whether or not this group has any sub-groups underneath it*/hasSubGroups:boolean}]=[]/**Metadata specific to the browse result of the queried path*/metadata:/**The model for browse result metadata*/record BrowseResultMetadata{/**Path that is being browsed*/path:string/**Total number of entities we can reach from path*/totalNumEntities:long}/**Offset of the first entity in the result*/from:int/**Size of each page in the result*/pageSize:int/**The total number of groups directly under queried path*/numGroups:int}", SchemaFormatType.PDL);
    private BrowseResultGroupV2Array _groupsField = null;
    private BrowseResultMetadata _metadataField = null;
    private Integer _fromField = null;
    private Integer _pageSizeField = null;
    private Integer _numGroupsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Groups = SCHEMA.getField("groups");
    private static final BrowseResultGroupV2Array DEFAULT_Groups;
    private static final RecordDataSchema.Field FIELD_Metadata;
    private static final RecordDataSchema.Field FIELD_From;
    private static final RecordDataSchema.Field FIELD_PageSize;
    private static final RecordDataSchema.Field FIELD_NumGroups;

    public BrowseResultV2() {
        super(new DataMap(7, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public BrowseResultV2(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasGroups() {
        if (this._groupsField != null) {
            return true;
        }
        return this._map.containsKey("groups");
    }

    public void removeGroups() {
        this._map.remove("groups");
    }

    @Nullable
    public BrowseResultGroupV2Array getGroups(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getGroups();
            }
            case NULL: {
                if (this._groupsField != null) {
                    return this._groupsField;
                }
                Object __rawValue = this._map.get("groups");
                this._groupsField = __rawValue == null ? null : new BrowseResultGroupV2Array(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._groupsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public BrowseResultGroupV2Array getGroups() {
        if (this._groupsField != null) {
            return this._groupsField;
        }
        Object __rawValue = this._map.get("groups");
        if (__rawValue == null) {
            return DEFAULT_Groups;
        }
        this._groupsField = __rawValue == null ? null : new BrowseResultGroupV2Array(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._groupsField;
    }

    public BrowseResultV2 setGroups(@Nullable BrowseResultGroupV2Array value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setGroups(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field groups of com.linkedin.metadata.browse.BrowseResultV2");
                }
                CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
                this._groupsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeGroups();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
                this._groupsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
                this._groupsField = value;
            }
        }
        return this;
    }

    public BrowseResultV2 setGroups(@Nonnull BrowseResultGroupV2Array value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field groups of com.linkedin.metadata.browse.BrowseResultV2 to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
        this._groupsField = value;
        return this;
    }

    public boolean hasMetadata() {
        if (this._metadataField != null) {
            return true;
        }
        return this._map.containsKey("metadata");
    }

    public void removeMetadata() {
        this._map.remove("metadata");
    }

    @Nullable
    public BrowseResultMetadata getMetadata(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getMetadata();
            }
            case DEFAULT: 
            case NULL: {
                if (this._metadataField != null) {
                    return this._metadataField;
                }
                Object __rawValue = this._map.get("metadata");
                this._metadataField = __rawValue == null ? null : new BrowseResultMetadata(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._metadataField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public BrowseResultMetadata getMetadata() {
        if (this._metadataField != null) {
            return this._metadataField;
        }
        Object __rawValue = this._map.get("metadata");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("metadata");
        }
        this._metadataField = __rawValue == null ? null : new BrowseResultMetadata(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._metadataField;
    }

    public BrowseResultV2 setMetadata(@Nullable BrowseResultMetadata value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMetadata(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field metadata of com.linkedin.metadata.browse.BrowseResultV2");
                }
                CheckedUtil.putWithoutChecking(this._map, "metadata", value.data());
                this._metadataField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMetadata();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "metadata", value.data());
                this._metadataField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "metadata", value.data());
                this._metadataField = value;
            }
        }
        return this;
    }

    public BrowseResultV2 setMetadata(@Nonnull BrowseResultMetadata value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field metadata of com.linkedin.metadata.browse.BrowseResultV2 to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "metadata", value.data());
        this._metadataField = value;
        return this;
    }

    public boolean hasFrom() {
        if (this._fromField != null) {
            return true;
        }
        return this._map.containsKey("from");
    }

    public void removeFrom() {
        this._map.remove("from");
    }

    @Nullable
    public Integer getFrom(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getFrom();
            }
            case DEFAULT: 
            case NULL: {
                if (this._fromField != null) {
                    return this._fromField;
                }
                Object __rawValue = this._map.get("from");
                this._fromField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._fromField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getFrom() {
        if (this._fromField != null) {
            return this._fromField;
        }
        Object __rawValue = this._map.get("from");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("from");
        }
        this._fromField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._fromField;
    }

    public BrowseResultV2 setFrom(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFrom(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field from of com.linkedin.metadata.browse.BrowseResultV2");
                }
                CheckedUtil.putWithoutChecking(this._map, "from", DataTemplateUtil.coerceIntInput(value));
                this._fromField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFrom();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "from", DataTemplateUtil.coerceIntInput(value));
                this._fromField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "from", DataTemplateUtil.coerceIntInput(value));
                this._fromField = value;
            }
        }
        return this;
    }

    public BrowseResultV2 setFrom(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field from of com.linkedin.metadata.browse.BrowseResultV2 to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "from", DataTemplateUtil.coerceIntInput(value));
        this._fromField = value;
        return this;
    }

    public BrowseResultV2 setFrom(int value) {
        CheckedUtil.putWithoutChecking(this._map, "from", DataTemplateUtil.coerceIntInput(value));
        this._fromField = value;
        return this;
    }

    public boolean hasPageSize() {
        if (this._pageSizeField != null) {
            return true;
        }
        return this._map.containsKey("pageSize");
    }

    public void removePageSize() {
        this._map.remove("pageSize");
    }

    @Nullable
    public Integer getPageSize(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getPageSize();
            }
            case DEFAULT: 
            case NULL: {
                if (this._pageSizeField != null) {
                    return this._pageSizeField;
                }
                Object __rawValue = this._map.get("pageSize");
                this._pageSizeField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._pageSizeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getPageSize() {
        if (this._pageSizeField != null) {
            return this._pageSizeField;
        }
        Object __rawValue = this._map.get("pageSize");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("pageSize");
        }
        this._pageSizeField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._pageSizeField;
    }

    public BrowseResultV2 setPageSize(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPageSize(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field pageSize of com.linkedin.metadata.browse.BrowseResultV2");
                }
                CheckedUtil.putWithoutChecking(this._map, "pageSize", DataTemplateUtil.coerceIntInput(value));
                this._pageSizeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePageSize();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "pageSize", DataTemplateUtil.coerceIntInput(value));
                this._pageSizeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "pageSize", DataTemplateUtil.coerceIntInput(value));
                this._pageSizeField = value;
            }
        }
        return this;
    }

    public BrowseResultV2 setPageSize(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field pageSize of com.linkedin.metadata.browse.BrowseResultV2 to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "pageSize", DataTemplateUtil.coerceIntInput(value));
        this._pageSizeField = value;
        return this;
    }

    public BrowseResultV2 setPageSize(int value) {
        CheckedUtil.putWithoutChecking(this._map, "pageSize", DataTemplateUtil.coerceIntInput(value));
        this._pageSizeField = value;
        return this;
    }

    public boolean hasNumGroups() {
        if (this._numGroupsField != null) {
            return true;
        }
        return this._map.containsKey("numGroups");
    }

    public void removeNumGroups() {
        this._map.remove("numGroups");
    }

    @Nullable
    public Integer getNumGroups(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getNumGroups();
            }
            case DEFAULT: 
            case NULL: {
                if (this._numGroupsField != null) {
                    return this._numGroupsField;
                }
                Object __rawValue = this._map.get("numGroups");
                this._numGroupsField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._numGroupsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getNumGroups() {
        if (this._numGroupsField != null) {
            return this._numGroupsField;
        }
        Object __rawValue = this._map.get("numGroups");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("numGroups");
        }
        this._numGroupsField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._numGroupsField;
    }

    public BrowseResultV2 setNumGroups(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNumGroups(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field numGroups of com.linkedin.metadata.browse.BrowseResultV2");
                }
                CheckedUtil.putWithoutChecking(this._map, "numGroups", DataTemplateUtil.coerceIntInput(value));
                this._numGroupsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNumGroups();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "numGroups", DataTemplateUtil.coerceIntInput(value));
                this._numGroupsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "numGroups", DataTemplateUtil.coerceIntInput(value));
                this._numGroupsField = value;
            }
        }
        return this;
    }

    public BrowseResultV2 setNumGroups(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field numGroups of com.linkedin.metadata.browse.BrowseResultV2 to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "numGroups", DataTemplateUtil.coerceIntInput(value));
        this._numGroupsField = value;
        return this;
    }

    public BrowseResultV2 setNumGroups(int value) {
        CheckedUtil.putWithoutChecking(this._map, "numGroups", DataTemplateUtil.coerceIntInput(value));
        this._numGroupsField = value;
        return this;
    }

    @Override
    public BrowseResultV2 clone() throws CloneNotSupportedException {
        BrowseResultV2 __clone = (BrowseResultV2)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public BrowseResultV2 copy() throws CloneNotSupportedException {
        BrowseResultV2 __copy = (BrowseResultV2)super.copy();
        __copy._numGroupsField = null;
        __copy._metadataField = null;
        __copy._groupsField = null;
        __copy._pageSizeField = null;
        __copy._fromField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Metadata = SCHEMA.getField("metadata");
        FIELD_From = SCHEMA.getField("from");
        FIELD_PageSize = SCHEMA.getField("pageSize");
        FIELD_NumGroups = SCHEMA.getField("numGroups");
        DEFAULT_Groups = FIELD_Groups.getDefault() == null ? null : new BrowseResultGroupV2Array(DataTemplateUtil.castOrThrow(FIELD_Groups.getDefault(), DataList.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final BrowseResultV2 __objectRef;

        private ChangeListener(BrowseResultV2 reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "numGroups": {
                    this.__objectRef._numGroupsField = null;
                    break;
                }
                case "metadata": {
                    this.__objectRef._metadataField = null;
                    break;
                }
                case "groups": {
                    this.__objectRef._groupsField = null;
                    break;
                }
                case "pageSize": {
                    this.__objectRef._pageSizeField = null;
                    break;
                }
                case "from": {
                    this.__objectRef._fromField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public BrowseResultGroupV2Array.Fields groups() {
            return new BrowseResultGroupV2Array.Fields(this.getPathComponents(), "groups");
        }

        public PathSpec groups(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "groups");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public BrowseResultMetadata.Fields metadata() {
            return new BrowseResultMetadata.Fields(this.getPathComponents(), "metadata");
        }

        public PathSpec from() {
            return new PathSpec(this.getPathComponents(), "from");
        }

        public PathSpec pageSize() {
            return new PathSpec(this.getPathComponents(), "pageSize");
        }

        public PathSpec numGroups() {
            return new PathSpec(this.getPathComponents(), "numGroups");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private BrowseResultGroupV2Array.ProjectionMask _groupsMask;
        private BrowseResultMetadata.ProjectionMask _metadataMask;

        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withGroups(Function<BrowseResultGroupV2Array.ProjectionMask, BrowseResultGroupV2Array.ProjectionMask> nestedMask) {
            this._groupsMask = nestedMask.apply(this._groupsMask == null ? BrowseResultGroupV2Array.createMask() : this._groupsMask);
            this.getDataMap().put("groups", this._groupsMask.getDataMap());
            return this;
        }

        public ProjectionMask withGroups() {
            this._groupsMask = null;
            this.getDataMap().put("groups", 1);
            return this;
        }

        public ProjectionMask withGroups(Function<BrowseResultGroupV2Array.ProjectionMask, BrowseResultGroupV2Array.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._groupsMask = nestedMask.apply(this._groupsMask == null ? BrowseResultGroupV2Array.createMask() : this._groupsMask);
            this.getDataMap().put("groups", this._groupsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("groups").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("groups").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withGroups(Integer start, Integer count) {
            this._groupsMask = null;
            this.getDataMap().put("groups", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("groups").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("groups").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withMetadata(Function<BrowseResultMetadata.ProjectionMask, BrowseResultMetadata.ProjectionMask> nestedMask) {
            this._metadataMask = nestedMask.apply(this._metadataMask == null ? BrowseResultMetadata.createMask() : this._metadataMask);
            this.getDataMap().put("metadata", this._metadataMask.getDataMap());
            return this;
        }

        public ProjectionMask withMetadata() {
            this._metadataMask = null;
            this.getDataMap().put("metadata", 1);
            return this;
        }

        public ProjectionMask withFrom() {
            this.getDataMap().put("from", 1);
            return this;
        }

        public ProjectionMask withPageSize() {
            this.getDataMap().put("pageSize", 1);
            return this;
        }

        public ProjectionMask withNumGroups() {
            this.getDataMap().put("numGroups", 1);
            return this;
        }
    }
}

