/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.plugins;

import com.linkedin.common.urn.Urn;
import com.linkedin.events.metadata.ChangeType;
import com.linkedin.metadata.aspect.plugins.config.AspectPluginConfig;
import com.linkedin.metadata.models.EntitySpec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public abstract class PluginSpec {
    protected static String WILDCARD = "*";

    @Nonnull
    public abstract AspectPluginConfig getConfig();

    public abstract PluginSpec setConfig(@Nonnull AspectPluginConfig var1);

    public boolean enabled() {
        return true;
    }

    public boolean shouldApply(@Nullable ChangeType changeType, @Nonnull Urn entityUrn, @Nonnull String aspectName) {
        return this.shouldApply(changeType, entityUrn.getEntityType(), aspectName);
    }

    public boolean shouldApply(@Nullable ChangeType changeType, @Nonnull EntitySpec entitySpec, @Nonnull String aspectName) {
        return this.shouldApply(changeType, entitySpec.getName(), aspectName);
    }

    public boolean shouldApply(@Nullable ChangeType changeType, @Nonnull String entityName, @Nonnull String aspectName) {
        return this.getConfig().isEnabled() && this.isChangeTypeSupported(changeType) && this.isEntityAspectSupported(entityName, aspectName);
    }

    protected boolean isEntityAspectSupported(@Nonnull EntitySpec entitySpec, @Nonnull String aspectName) {
        return this.isEntityAspectSupported(entitySpec.getName(), aspectName);
    }

    protected boolean isEntityAspectSupported(@Nonnull String entityName, @Nonnull String aspectName) {
        return this.getConfig().getSupportedEntityAspectNames().stream().anyMatch(supported -> WILDCARD.equals(supported.getEntityName()) || supported.getEntityName().equals(entityName)) && this.isAspectSupported(aspectName);
    }

    protected boolean isAspectSupported(@Nonnull String aspectName) {
        return this.getConfig().getSupportedEntityAspectNames().stream().anyMatch(supported -> WILDCARD.equals(supported.getAspectName()) || supported.getAspectName().equals(aspectName));
    }

    protected boolean isChangeTypeSupported(@Nullable ChangeType changeType) {
        return changeType == null && this.getConfig().getSupportedOperations().isEmpty() || this.getConfig().getSupportedOperations().stream().anyMatch(supported -> WILDCARD.equals(supported) || supported.equalsIgnoreCase(String.valueOf((Object)changeType)));
    }

    @Generated
    public PluginSpec() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginSpec)) {
            return false;
        }
        PluginSpec other = (PluginSpec)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PluginSpec;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

