/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.hooks;

import com.linkedin.common.Owner;
import com.linkedin.common.Ownership;
import com.linkedin.common.UrnArray;
import com.linkedin.common.UrnArrayMap;
import com.linkedin.common.urn.Urn;
import com.linkedin.common.urn.UrnUtils;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.metadata.Constants;
import com.linkedin.metadata.aspect.RetrieverContext;
import com.linkedin.metadata.aspect.batch.ChangeMCP;
import com.linkedin.metadata.aspect.plugins.config.AspectPluginConfig;
import com.linkedin.metadata.aspect.plugins.hooks.MutationHook;
import com.linkedin.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OwnershipOwnerTypes
extends MutationHook {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OwnershipOwnerTypes.class);
    @Nonnull
    private AspectPluginConfig config;

    @Override
    protected Stream<Pair<ChangeMCP, Boolean>> writeMutation(@Nonnull Collection<ChangeMCP> changeMCPS, @Nonnull RetrieverContext retrieverContext) {
        LinkedList<Pair<ChangeMCP, Boolean>> results = new LinkedList<Pair<ChangeMCP, Boolean>>();
        for (ChangeMCP item : changeMCPS) {
            if ("ownership".equals(item.getAspectName()) && item.getRecordTemplate() != null) {
                Map<Urn, Set<Owner>> oldTypeOwner = OwnershipOwnerTypes.groupByOwnerType(item.getPreviousRecordTemplate());
                Map<Urn, Set<Owner>> newTypeOwner = OwnershipOwnerTypes.groupByOwnerType(item.getRecordTemplate());
                Set removedTypes = oldTypeOwner.keySet().stream().filter(typeUrn -> !newTypeOwner.containsKey(typeUrn)).collect(Collectors.toSet());
                if (!removedTypes.isEmpty() || !oldTypeOwner.equals(newTypeOwner)) {
                    Map<String, UrnArray> typeOwners = newTypeOwner.entrySet().stream().collect(Collectors.toMap(e -> OwnershipOwnerTypes.encodeFieldName(((Urn)e.getKey()).toString()), e -> new UrnArray(((Set)e.getValue()).stream().map(Owner::getOwner).collect(Collectors.toSet()))));
                    item.getAspect(Ownership.class).setOwnerTypes(new UrnArrayMap(typeOwners));
                    results.add(Pair.of(item, true));
                    continue;
                }
                results.add(Pair.of(item, false));
                continue;
            }
            results.add(Pair.of(item, false));
        }
        return results.stream();
    }

    private static Map<Urn, Set<Owner>> groupByOwnerType(@Nullable RecordTemplate ownershipRecordTemplate) {
        Ownership ownership;
        if (ownershipRecordTemplate != null && !(ownership = new Ownership(ownershipRecordTemplate.data())).getOwners().isEmpty()) {
            return ownership.getOwners().stream().collect(Collectors.groupingBy(OwnershipOwnerTypes::resolveToTypeUrn, Collectors.toSet()));
        }
        return Collections.emptyMap();
    }

    private static Urn resolveToTypeUrn(Owner owner) {
        if (owner.getTypeUrn() != null) {
            return owner.getTypeUrn();
        }
        if (owner.hasType()) {
            return UrnUtils.getUrn(String.format("urn:li:ownershipType:__system__%s", owner.getType().toString().toLowerCase()));
        }
        return Constants.DEFAULT_OWNERSHIP_TYPE_URN;
    }

    public static String encodeFieldName(String value) {
        return value.replaceAll("[.]", "%2E");
    }

    public static String decodeFieldName(String value) {
        return value.replaceAll("%2E", ".");
    }

    @Override
    @Nonnull
    @Generated
    public AspectPluginConfig getConfig() {
        return this.config;
    }

    @Override
    @Generated
    public OwnershipOwnerTypes setConfig(@Nonnull AspectPluginConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        return this;
    }
}

