/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.linkedin.common.urn.Urn;
import com.linkedin.entity.Aspect;
import com.linkedin.metadata.aspect.SystemAspect;
import com.linkedin.metadata.models.registry.EntityRegistry;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface AspectRetriever {
    @Nullable
    default public Aspect getLatestAspectObject(@Nonnull Urn urn, @Nonnull String aspectName) {
        return (Aspect)this.getLatestAspectObjects(ImmutableSet.of(urn), ImmutableSet.of(aspectName)).getOrDefault(urn, Collections.emptyMap()).get(aspectName);
    }

    @Nonnull
    public Map<Urn, Map<String, Aspect>> getLatestAspectObjects(Set<Urn> var1, Set<String> var2);

    @Nullable
    default public SystemAspect getLatestSystemAspect(@Nonnull Urn urn, @Nonnull String aspectName) {
        return (SystemAspect)this.getLatestSystemAspects(ImmutableMap.of(urn, ImmutableSet.of(aspectName))).getOrDefault(urn, Collections.emptyMap()).get(aspectName);
    }

    @Nonnull
    public Map<Urn, Map<String, SystemAspect>> getLatestSystemAspects(Map<Urn, Set<String>> var1);

    @Nonnull
    public Map<Urn, Boolean> entityExists(Set<Urn> var1);

    @Nonnull
    public EntityRegistry getEntityRegistry();
}

