/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.form;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.form.FormPromptType;
import com.linkedin.form.StructuredPropertyParams;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FormPrompt
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.form/**A prompt to present to the user to encourage filling out metadata*/record FormPrompt{/**The unique id for this prompt. This must be GLOBALLY unique.*/@Searchable={\"fieldName\":\"promptId\",\"fieldType\":\"KEYWORD\",\"queryByDefault\":false}id:string/**The title of this prompt*/title:string/**The description of this prompt*/description:optional string/**The type of prompt*/type:enum FormPromptType{/**This prompt is meant to apply a structured property to an entity*/STRUCTURED_PROPERTY/**This prompt is meant to apply a structured property to a schema fields entity*/FIELDS_STRUCTURED_PROPERTY}/**An optional set of information specific to structured properties prompts.\nThis should be filled out if the prompt is type STRUCTURED_PROPERTY or FIELDS_STRUCTURED_PROPERTY.*/structuredPropertyParams:optional record StructuredPropertyParams{/**The structured property that is required on this entity*/@Searchable={\"fieldName\":\"structuredPropertyPromptUrns\",\"fieldType\":\"URN\"}urn:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}/**Whether the prompt is required to be completed, in order for the form to be marked as complete.*/required:boolean=false}", SchemaFormatType.PDL);
    private String _idField = null;
    private String _titleField = null;
    private String _descriptionField = null;
    private FormPromptType _typeField = null;
    private StructuredPropertyParams _structuredPropertyParamsField = null;
    private Boolean _requiredField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Id = SCHEMA.getField("id");
    private static final RecordDataSchema.Field FIELD_Title = SCHEMA.getField("title");
    private static final RecordDataSchema.Field FIELD_Description = SCHEMA.getField("description");
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_StructuredPropertyParams = SCHEMA.getField("structuredPropertyParams");
    private static final RecordDataSchema.Field FIELD_Required = SCHEMA.getField("required");
    private static final Boolean DEFAULT_Required = DataTemplateUtil.coerceBooleanOutput(FIELD_Required.getDefault());

    public FormPrompt() {
        super(new DataMap(8, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public FormPrompt(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasId() {
        if (this._idField != null) {
            return true;
        }
        return this._map.containsKey("id");
    }

    public void removeId() {
        this._map.remove("id");
    }

    @Nullable
    public String getId(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getId();
            }
            case DEFAULT: 
            case NULL: {
                if (this._idField != null) {
                    return this._idField;
                }
                Object __rawValue = this._map.get("id");
                this._idField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._idField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getId() {
        if (this._idField != null) {
            return this._idField;
        }
        Object __rawValue = this._map.get("id");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("id");
        }
        this._idField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._idField;
    }

    public FormPrompt setId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field id of com.linkedin.form.FormPrompt");
                }
                CheckedUtil.putWithoutChecking(this._map, "id", value);
                this._idField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "id", value);
                this._idField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "id", value);
                this._idField = value;
            }
        }
        return this;
    }

    public FormPrompt setId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field id of com.linkedin.form.FormPrompt to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "id", value);
        this._idField = value;
        return this;
    }

    public boolean hasTitle() {
        if (this._titleField != null) {
            return true;
        }
        return this._map.containsKey("title");
    }

    public void removeTitle() {
        this._map.remove("title");
    }

    @Nullable
    public String getTitle(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTitle();
            }
            case DEFAULT: 
            case NULL: {
                if (this._titleField != null) {
                    return this._titleField;
                }
                Object __rawValue = this._map.get("title");
                this._titleField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._titleField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getTitle() {
        if (this._titleField != null) {
            return this._titleField;
        }
        Object __rawValue = this._map.get("title");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("title");
        }
        this._titleField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._titleField;
    }

    public FormPrompt setTitle(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTitle(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field title of com.linkedin.form.FormPrompt");
                }
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTitle();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
            }
        }
        return this;
    }

    public FormPrompt setTitle(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field title of com.linkedin.form.FormPrompt to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "title", value);
        this._titleField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        return this.getDescription();
    }

    @Nullable
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public FormPrompt setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public FormPrompt setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.form.FormPrompt to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public FormPromptType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, FormPromptType.class, FormPromptType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FormPromptType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, FormPromptType.class, FormPromptType.$UNKNOWN);
        return this._typeField;
    }

    public FormPrompt setType(@Nullable FormPromptType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.form.FormPrompt");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public FormPrompt setType(@Nonnull FormPromptType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.form.FormPrompt to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasStructuredPropertyParams() {
        if (this._structuredPropertyParamsField != null) {
            return true;
        }
        return this._map.containsKey("structuredPropertyParams");
    }

    public void removeStructuredPropertyParams() {
        this._map.remove("structuredPropertyParams");
    }

    @Nullable
    public StructuredPropertyParams getStructuredPropertyParams(GetMode mode) {
        return this.getStructuredPropertyParams();
    }

    @Nullable
    public StructuredPropertyParams getStructuredPropertyParams() {
        if (this._structuredPropertyParamsField != null) {
            return this._structuredPropertyParamsField;
        }
        Object __rawValue = this._map.get("structuredPropertyParams");
        this._structuredPropertyParamsField = __rawValue == null ? null : new StructuredPropertyParams(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._structuredPropertyParamsField;
    }

    public FormPrompt setStructuredPropertyParams(@Nullable StructuredPropertyParams value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStructuredPropertyParams(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStructuredPropertyParams();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "structuredPropertyParams", value.data());
                this._structuredPropertyParamsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "structuredPropertyParams", value.data());
                this._structuredPropertyParamsField = value;
            }
        }
        return this;
    }

    public FormPrompt setStructuredPropertyParams(@Nonnull StructuredPropertyParams value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field structuredPropertyParams of com.linkedin.form.FormPrompt to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "structuredPropertyParams", value.data());
        this._structuredPropertyParamsField = value;
        return this;
    }

    public boolean hasRequired() {
        if (this._requiredField != null) {
            return true;
        }
        return this._map.containsKey("required");
    }

    public void removeRequired() {
        this._map.remove("required");
    }

    @Nullable
    public Boolean isRequired(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isRequired();
            }
            case NULL: {
                if (this._requiredField != null) {
                    return this._requiredField;
                }
                Object __rawValue = this._map.get("required");
                this._requiredField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._requiredField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isRequired() {
        if (this._requiredField != null) {
            return this._requiredField;
        }
        Object __rawValue = this._map.get("required");
        if (__rawValue == null) {
            return DEFAULT_Required;
        }
        this._requiredField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._requiredField;
    }

    public FormPrompt setRequired(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRequired(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field required of com.linkedin.form.FormPrompt");
                }
                CheckedUtil.putWithoutChecking(this._map, "required", value);
                this._requiredField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRequired();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "required", value);
                this._requiredField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "required", value);
                this._requiredField = value;
            }
        }
        return this;
    }

    public FormPrompt setRequired(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field required of com.linkedin.form.FormPrompt to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "required", value);
        this._requiredField = value;
        return this;
    }

    public FormPrompt setRequired(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "required", value);
        this._requiredField = value;
        return this;
    }

    @Override
    public FormPrompt clone() throws CloneNotSupportedException {
        FormPrompt __clone = (FormPrompt)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public FormPrompt copy() throws CloneNotSupportedException {
        FormPrompt __copy = (FormPrompt)super.copy();
        __copy._structuredPropertyParamsField = null;
        __copy._descriptionField = null;
        __copy._idField = null;
        __copy._titleField = null;
        __copy._typeField = null;
        __copy._requiredField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final FormPrompt __objectRef;

        private ChangeListener(FormPrompt reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "structuredPropertyParams": {
                    this.__objectRef._structuredPropertyParamsField = null;
                    break;
                }
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "id": {
                    this.__objectRef._idField = null;
                    break;
                }
                case "title": {
                    this.__objectRef._titleField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "required": {
                    this.__objectRef._requiredField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec id() {
            return new PathSpec(this.getPathComponents(), "id");
        }

        public PathSpec title() {
            return new PathSpec(this.getPathComponents(), "title");
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public StructuredPropertyParams.Fields structuredPropertyParams() {
            return new StructuredPropertyParams.Fields(this.getPathComponents(), "structuredPropertyParams");
        }

        public PathSpec required() {
            return new PathSpec(this.getPathComponents(), "required");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private StructuredPropertyParams.ProjectionMask _structuredPropertyParamsMask;

        ProjectionMask() {
            super(8);
        }

        public ProjectionMask withId() {
            this.getDataMap().put("id", 1);
            return this;
        }

        public ProjectionMask withTitle() {
            this.getDataMap().put("title", 1);
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withStructuredPropertyParams(Function<StructuredPropertyParams.ProjectionMask, StructuredPropertyParams.ProjectionMask> nestedMask) {
            this._structuredPropertyParamsMask = nestedMask.apply(this._structuredPropertyParamsMask == null ? StructuredPropertyParams.createMask() : this._structuredPropertyParamsMask);
            this.getDataMap().put("structuredPropertyParams", this._structuredPropertyParamsMask.getDataMap());
            return this;
        }

        public ProjectionMask withStructuredPropertyParams() {
            this._structuredPropertyParamsMask = null;
            this.getDataMap().put("structuredPropertyParams", 1);
            return this;
        }

        public ProjectionMask withRequired() {
            this.getDataMap().put("required", 1);
            return this;
        }
    }
}

