/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.schema.PathSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class PathSpecSet {
    private static final PathSpecSet EMPTY = new PathSpecSet(Collections.emptySet(), false);
    private static final PathSpecSet ALL_INCLUSIVE = new PathSpecSet(Collections.emptySet(), true);
    private final Set<PathSpec> _pathSpecs;
    private final boolean _allInclusive;

    private PathSpecSet(Builder builder) {
        this(new HashSet<PathSpec>(builder._pathSpecs), builder._allInclusive);
    }

    private PathSpecSet(Set<PathSpec> pathSpecs, boolean allInclusive) {
        this._pathSpecs = Collections.unmodifiableSet(pathSpecs);
        this._allInclusive = allInclusive;
    }

    public static PathSpecSet of(Collection<PathSpec> pathSpecs) {
        if (pathSpecs.isEmpty()) {
            return PathSpecSet.empty();
        }
        return new PathSpecSet(new HashSet<PathSpec>(pathSpecs), false);
    }

    public static PathSpecSet of(PathSpec ... pathSpecs) {
        return PathSpecSet.of(Arrays.asList(pathSpecs));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static PathSpecSet empty() {
        return EMPTY;
    }

    public static PathSpecSet allInclusive() {
        return ALL_INCLUSIVE;
    }

    public PathSpec[] toArray() {
        if (this._allInclusive) {
            return null;
        }
        return this._pathSpecs.toArray(new PathSpec[0]);
    }

    public Builder toBuilder() {
        return PathSpecSet.newBuilder().add(this);
    }

    public Set<PathSpec> getPathSpecs() {
        return this._pathSpecs;
    }

    public boolean isEmpty() {
        return this._pathSpecs.isEmpty() && !this._allInclusive;
    }

    public boolean isAllInclusive() {
        return this._allInclusive;
    }

    public boolean contains(PathSpec pathSpec) {
        if (this._allInclusive) {
            return true;
        }
        return IntStream.range(0, pathSpec.getPathComponents().size() + 1).mapToObj(i -> new PathSpec(pathSpec.getPathComponents().subList(0, i).toArray(new String[0]))).anyMatch(this._pathSpecs::contains);
    }

    public PathSpecSet copyWithScope(PathSpec parent) {
        if (this.isAllInclusive()) {
            return PathSpecSet.of(parent);
        }
        if (this.isEmpty()) {
            return PathSpecSet.empty();
        }
        Builder builder = PathSpecSet.newBuilder();
        this.getPathSpecs().stream().map(childPathSpec -> {
            List<String> parentPathComponents = parent.getPathComponents();
            List<String> childPathComponents = childPathSpec.getPathComponents();
            ArrayList<String> list = new ArrayList<String>(parentPathComponents.size() + childPathComponents.size());
            list.addAll(parentPathComponents);
            list.addAll(childPathComponents);
            return list;
        }).map(PathSpec::new).forEach(xva$0 -> builder.add((PathSpec)xva$0));
        return builder.build();
    }

    public PathSpecSet copyAndRemovePrefix(PathSpec prefix) {
        if (this.isAllInclusive() || this.isEmpty()) {
            return this;
        }
        PathSpec partialPrefix = prefix;
        do {
            if (!this.getPathSpecs().contains(partialPrefix)) continue;
            return PathSpecSet.allInclusive();
        } while (!(partialPrefix = partialPrefix.getParent()).isEmptyPath());
        List<String> prefixPathComponents = prefix.getPathComponents();
        int prefixPathLength = prefixPathComponents.size();
        return PathSpecSet.of(this.getPathSpecs().stream().filter(pathSpec -> {
            List<String> pathComponents = pathSpec.getPathComponents();
            return pathComponents.size() > prefixPathLength && prefixPathComponents.equals(pathComponents.subList(0, prefixPathLength));
        }).map(pathSpec -> new PathSpec(pathSpec.getPathComponents().subList(prefixPathLength, pathSpec.getPathComponents().size()).toArray(new String[0]))).collect(Collectors.toSet()));
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, o, new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, new String[0]);
    }

    public String toString() {
        return "PathSpecSet{" + (this._allInclusive ? "all inclusive" : StringUtils.join(this._pathSpecs, ',')) + "}";
    }

    public static final class Builder {
        private final Set<PathSpec> _pathSpecs = new HashSet<PathSpec>();
        private boolean _allInclusive;

        public Builder add(PathSpecSet ps) {
            if (ps._allInclusive || this._allInclusive) {
                this._pathSpecs.clear();
                this._allInclusive = true;
                return this;
            }
            this._pathSpecs.addAll(ps._pathSpecs);
            return this;
        }

        public Builder add(PathSpec ... pathSpecs) {
            if (this._allInclusive) {
                return this;
            }
            Collections.addAll(this._pathSpecs, pathSpecs);
            return this;
        }

        public Builder add(Collection<String> paths) {
            return this.add(new PathSpec(paths.toArray(new String[paths.size()])));
        }

        public Builder addAll(Builder builder) {
            return this.add(builder.build());
        }

        public boolean isEmpty() {
            return !this._allInclusive && this._pathSpecs.isEmpty();
        }

        public PathSpecSet build() {
            if (this._allInclusive) {
                return PathSpecSet.allInclusive();
            }
            return new PathSpecSet(this);
        }
    }
}

