/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.ByteString;
import com.linkedin.data.element.DataElement;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaConstants;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.PrimitiveDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class DataSchemaUtil {
    static final Map<String, PrimitiveDataSchema> _TYPE_STRING_TO_PRIMITIVE_DATA_SCHEMA_MAP = new HashMap<String, PrimitiveDataSchema>();
    static final Map<Class<?>, PrimitiveDataSchema> _JAVA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_TYPE;
    static final Map<DataSchema.Type, PrimitiveDataSchema> _DATA_SCHEMA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_MAP;
    static final Map<DataSchema.Type, Class<?>> _DATA_SCHEMA_TYPE_TO_PRIMITIVE_JAVA_TYPE_MAP;
    static final Map<String, DataSchema.Type> _TYPE_STRING_TO_COMPLEX_DATA_SCHEMA_TYPE_MAP;

    public static PrimitiveDataSchema typeStringToPrimitiveDataSchema(String type) {
        return _TYPE_STRING_TO_PRIMITIVE_DATA_SCHEMA_MAP.get(type);
    }

    public static PrimitiveDataSchema classToPrimitiveDataSchema(Class<?> clazz) {
        return _JAVA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_TYPE.get(clazz);
    }

    public static PrimitiveDataSchema dataSchemaTypeToPrimitiveDataSchema(DataSchema.Type type) {
        return _DATA_SCHEMA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_MAP.get((Object)type);
    }

    public static Class<?> dataSchemaTypeToPrimitiveDataSchemaClass(DataSchema.Type type) {
        return _DATA_SCHEMA_TYPE_TO_PRIMITIVE_JAVA_TYPE_MAP.get((Object)type);
    }

    public static DataSchema.Type typeStringToComplexDataSchemaType(String type) {
        return _TYPE_STRING_TO_COMPLEX_DATA_SCHEMA_TYPE_MAP.get(type);
    }

    public static boolean containsPath(DataSchema schema, String path) {
        return DataSchemaUtil.getField(schema, path) != null;
    }

    public static RecordDataSchema.Field getField(DataSchema schema, String path) {
        if (path.length() > 0 && path.charAt(0) == DataElement.SEPARATOR.charValue()) {
            path = path.substring(1);
        }
        return DataSchemaUtil.getField(schema, path.split(DataElement.SEPARATOR.toString()));
    }

    public static RecordDataSchema.Field getField(DataSchema schema, Object[] path) {
        RecordDataSchema.Field field = null;
        DataSchema dataSchema = schema;
        block6: for (int i = 0; i < path.length; ++i) {
            dataSchema = dataSchema.getDereferencedDataSchema();
            switch (dataSchema.getType()) {
                case MAP: {
                    dataSchema = ((MapDataSchema)dataSchema).getValues();
                    continue block6;
                }
                case ARRAY: {
                    dataSchema = ((ArrayDataSchema)dataSchema).getItems();
                    continue block6;
                }
                case RECORD: {
                    field = ((RecordDataSchema)dataSchema).getField(path[i].toString());
                    if (i == path.length - 1) {
                        return field;
                    }
                    if (field == null) {
                        return null;
                    }
                    dataSchema = field.getType();
                    continue block6;
                }
                case UNION: {
                    UnionDataSchema unionDataSchema = (UnionDataSchema)dataSchema;
                    dataSchema = unionDataSchema.getTypeByMemberKey(path[i].toString());
                    if (dataSchema != null) continue block6;
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    public static Class<?> getDataClassFromSchema(DataSchema schema) {
        if (schema == null) {
            return null;
        }
        return DataSchemaUtil.dataSchemaTypeToPrimitiveDataSchemaClass(schema.getDereferencedType());
    }

    private DataSchemaUtil() {
    }

    static {
        _TYPE_STRING_TO_PRIMITIVE_DATA_SCHEMA_MAP.put("null", DataSchemaConstants.NULL_DATA_SCHEMA);
        _TYPE_STRING_TO_PRIMITIVE_DATA_SCHEMA_MAP.put("boolean", DataSchemaConstants.BOOLEAN_DATA_SCHEMA);
        _TYPE_STRING_TO_PRIMITIVE_DATA_SCHEMA_MAP.put("int", DataSchemaConstants.INTEGER_DATA_SCHEMA);
        _TYPE_STRING_TO_PRIMITIVE_DATA_SCHEMA_MAP.put("long", DataSchemaConstants.LONG_DATA_SCHEMA);
        _TYPE_STRING_TO_PRIMITIVE_DATA_SCHEMA_MAP.put("float", DataSchemaConstants.FLOAT_DATA_SCHEMA);
        _TYPE_STRING_TO_PRIMITIVE_DATA_SCHEMA_MAP.put("double", DataSchemaConstants.DOUBLE_DATA_SCHEMA);
        _TYPE_STRING_TO_PRIMITIVE_DATA_SCHEMA_MAP.put("bytes", DataSchemaConstants.BYTES_DATA_SCHEMA);
        _TYPE_STRING_TO_PRIMITIVE_DATA_SCHEMA_MAP.put("string", DataSchemaConstants.STRING_DATA_SCHEMA);
        _JAVA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_TYPE = new HashMap(32);
        _JAVA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_TYPE.put(Integer.class, DataSchemaConstants.INTEGER_DATA_SCHEMA);
        _JAVA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_TYPE.put(Integer.TYPE, DataSchemaConstants.INTEGER_DATA_SCHEMA);
        _JAVA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_TYPE.put(Long.class, DataSchemaConstants.LONG_DATA_SCHEMA);
        _JAVA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_TYPE.put(Long.TYPE, DataSchemaConstants.LONG_DATA_SCHEMA);
        _JAVA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_TYPE.put(Short.class, DataSchemaConstants.INTEGER_DATA_SCHEMA);
        _JAVA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_TYPE.put(Short.TYPE, DataSchemaConstants.INTEGER_DATA_SCHEMA);
        _JAVA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_TYPE.put(Float.class, DataSchemaConstants.FLOAT_DATA_SCHEMA);
        _JAVA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_TYPE.put(Float.TYPE, DataSchemaConstants.FLOAT_DATA_SCHEMA);
        _JAVA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_TYPE.put(Double.class, DataSchemaConstants.DOUBLE_DATA_SCHEMA);
        _JAVA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_TYPE.put(Double.TYPE, DataSchemaConstants.DOUBLE_DATA_SCHEMA);
        _JAVA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_TYPE.put(Boolean.class, DataSchemaConstants.BOOLEAN_DATA_SCHEMA);
        _JAVA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_TYPE.put(Boolean.TYPE, DataSchemaConstants.BOOLEAN_DATA_SCHEMA);
        _JAVA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_TYPE.put(String.class, DataSchemaConstants.STRING_DATA_SCHEMA);
        _JAVA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_TYPE.put(ByteString.class, DataSchemaConstants.BYTES_DATA_SCHEMA);
        _DATA_SCHEMA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_MAP = new IdentityHashMap<DataSchema.Type, PrimitiveDataSchema>();
        _DATA_SCHEMA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_MAP.put(DataSchema.Type.NULL, DataSchemaConstants.NULL_DATA_SCHEMA);
        _DATA_SCHEMA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_MAP.put(DataSchema.Type.BOOLEAN, DataSchemaConstants.BOOLEAN_DATA_SCHEMA);
        _DATA_SCHEMA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_MAP.put(DataSchema.Type.INT, DataSchemaConstants.INTEGER_DATA_SCHEMA);
        _DATA_SCHEMA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_MAP.put(DataSchema.Type.LONG, DataSchemaConstants.LONG_DATA_SCHEMA);
        _DATA_SCHEMA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_MAP.put(DataSchema.Type.FLOAT, DataSchemaConstants.FLOAT_DATA_SCHEMA);
        _DATA_SCHEMA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_MAP.put(DataSchema.Type.DOUBLE, DataSchemaConstants.DOUBLE_DATA_SCHEMA);
        _DATA_SCHEMA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_MAP.put(DataSchema.Type.BYTES, DataSchemaConstants.BYTES_DATA_SCHEMA);
        _DATA_SCHEMA_TYPE_TO_PRIMITIVE_DATA_SCHEMA_MAP.put(DataSchema.Type.STRING, DataSchemaConstants.STRING_DATA_SCHEMA);
        _DATA_SCHEMA_TYPE_TO_PRIMITIVE_JAVA_TYPE_MAP = new IdentityHashMap();
        _DATA_SCHEMA_TYPE_TO_PRIMITIVE_JAVA_TYPE_MAP.put(DataSchema.Type.INT, Integer.class);
        _DATA_SCHEMA_TYPE_TO_PRIMITIVE_JAVA_TYPE_MAP.put(DataSchema.Type.LONG, Long.class);
        _DATA_SCHEMA_TYPE_TO_PRIMITIVE_JAVA_TYPE_MAP.put(DataSchema.Type.FLOAT, Float.class);
        _DATA_SCHEMA_TYPE_TO_PRIMITIVE_JAVA_TYPE_MAP.put(DataSchema.Type.DOUBLE, Double.class);
        _DATA_SCHEMA_TYPE_TO_PRIMITIVE_JAVA_TYPE_MAP.put(DataSchema.Type.BOOLEAN, Boolean.class);
        _DATA_SCHEMA_TYPE_TO_PRIMITIVE_JAVA_TYPE_MAP.put(DataSchema.Type.STRING, String.class);
        _DATA_SCHEMA_TYPE_TO_PRIMITIVE_JAVA_TYPE_MAP.put(DataSchema.Type.BYTES, ByteString.class);
        _TYPE_STRING_TO_COMPLEX_DATA_SCHEMA_TYPE_MAP = new HashMap<String, DataSchema.Type>();
        _TYPE_STRING_TO_COMPLEX_DATA_SCHEMA_TYPE_MAP.put("array", DataSchema.Type.ARRAY);
        _TYPE_STRING_TO_COMPLEX_DATA_SCHEMA_TYPE_MAP.put("enum", DataSchema.Type.ENUM);
        _TYPE_STRING_TO_COMPLEX_DATA_SCHEMA_TYPE_MAP.put("error", DataSchema.Type.RECORD);
        _TYPE_STRING_TO_COMPLEX_DATA_SCHEMA_TYPE_MAP.put("fixed", DataSchema.Type.FIXED);
        _TYPE_STRING_TO_COMPLEX_DATA_SCHEMA_TYPE_MAP.put("map", DataSchema.Type.MAP);
        _TYPE_STRING_TO_COMPLEX_DATA_SCHEMA_TYPE_MAP.put("record", DataSchema.Type.RECORD);
        _TYPE_STRING_TO_COMPLEX_DATA_SCHEMA_TYPE_MAP.put("typeref", DataSchema.Type.TYPEREF);
    }
}

