/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data;

import com.linkedin.data.ByteString;
import com.linkedin.data.Data;
import com.linkedin.data.DataComplex;
import com.linkedin.data.DataComplexHashCode;
import com.linkedin.data.DataComplexTable;
import com.linkedin.data.DataList;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.MapChecker;
import java.util.HashMap;
import java.util.Map;

public final class DataMap
extends CheckedMap<String, Object>
implements DataComplex {
    public static final String RESERVED_CONSTANT_PREFIX = "**";
    public static final String RESERVED_CONSTANT_SUFFIX = "**";
    public static final String ERROR_KEY = DataMap.reservedConstant("ERROR");
    private static final MapChecker<String, Object> _checker = (map, key, value) -> {
        if (key.getClass() != String.class) {
            throw new IllegalArgumentException("Key must be a string");
        }
        Data.checkAllowed((DataComplex)((Object)map), value);
    };
    private volatile ThreadLocal<Object> _isTraversing = null;
    private boolean _madeReadOnly = false;
    private boolean _instrumented = false;
    private Map<String, Integer> _accessMap;
    int _dataComplexHashCode = 0;

    public static String reservedConstant(String name) {
        return "**" + name + "**";
    }

    public DataMap() {
        super(_checker);
    }

    public DataMap(Map<? extends String, ? extends Object> map) {
        super(map, _checker);
    }

    public DataMap(int initialCapacity) {
        super(initialCapacity, _checker);
    }

    public DataMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor, _checker);
    }

    @Override
    public DataMap clone() throws CloneNotSupportedException {
        DataMap o = (DataMap)super.clone();
        o._madeReadOnly = false;
        o._instrumented = false;
        o._accessMap = null;
        o._dataComplexHashCode = 0;
        o._isTraversing = null;
        return o;
    }

    @Override
    public Object get(Object key) {
        this.instrumentAccess(key);
        return super.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        this.instrumentAccess(key);
        return super.containsKey(key);
    }

    @Override
    public DataMap copy() throws CloneNotSupportedException {
        return Data.copy(this, new DataComplexTable());
    }

    public void copyReferencedObjects(DataComplexTable alreadyCopied) throws CloneNotSupportedException {
        for (Map.Entry e : this.entrySet()) {
            Object valueCopy;
            Object value = e.getValue();
            if (value == (valueCopy = Data.copy(value, alreadyCopied))) continue;
            this.putWithoutChecking((String)e.getKey(), valueCopy);
        }
    }

    @Override
    public void makeReadOnly() {
        if (!this._madeReadOnly) {
            for (Map.Entry e : this.entrySet()) {
                Data.makeReadOnly(e.getValue());
            }
            this.setReadOnly();
            this._madeReadOnly = true;
        }
    }

    @Override
    public boolean isMadeReadOnly() {
        return this._madeReadOnly;
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public Integer getInteger(String key) {
        return (Integer)this.get(key);
    }

    public Long getLong(String key) {
        return (Long)this.get(key);
    }

    public Float getFloat(String key) {
        return (Float)this.get(key);
    }

    public Double getDouble(String key) {
        return (Double)this.get(key);
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public ByteString getByteString(String key) {
        return (ByteString)this.get(key);
    }

    public DataMap getDataMap(String key) {
        return (DataMap)this.get(key);
    }

    public DataList getDataList(String key) {
        return (DataList)this.get(key);
    }

    public String getError() {
        return (String)this.get(ERROR_KEY);
    }

    public String addError(String msg) {
        String error = this.getError();
        String res = error != null ? error + msg : msg;
        this.put(ERROR_KEY, res);
        return res;
    }

    @Override
    public void startInstrumentingAccess() {
        Data.startInstrumentingAccess(this.values());
        this._instrumented = true;
        if (this._accessMap == null) {
            this._accessMap = new HashMap<String, Integer>();
        }
    }

    @Override
    public void stopInstrumentingAccess() {
        this._instrumented = false;
        Data.stopInstrumentingAccess(this.values());
    }

    @Override
    public void clearInstrumentedData() {
        if (this._accessMap != null) {
            this._accessMap.clear();
        }
    }

    @Override
    public void collectInstrumentedData(StringBuilder keyPrefix, Map<String, Map<String, Object>> instrumentedData, boolean collectAllData) {
        for (Map.Entry entry : this.entrySet()) {
            Integer timesAccessed;
            String key = (String)entry.getKey();
            Integer n = timesAccessed = this._accessMap == null ? null : this._accessMap.get(key);
            if (timesAccessed == null) {
                timesAccessed = 0;
            }
            int preLength = keyPrefix.length();
            keyPrefix.append('.');
            keyPrefix.append(key);
            Data.collectInstrumentedData(keyPrefix, entry.getValue(), timesAccessed, instrumentedData, collectAllData);
            keyPrefix.setLength(preLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int dataComplexHashCode() {
        if (this._dataComplexHashCode != 0) {
            return this._dataComplexHashCode;
        }
        DataMap dataMap = this;
        synchronized (dataMap) {
            if (this._dataComplexHashCode == 0) {
                this._dataComplexHashCode = DataComplexHashCode.nextHashCode();
            }
        }
        return this._dataComplexHashCode;
    }

    void disableChecker() {
        ((CheckedMap)this)._checker = null;
    }

    Map<String, Object> getUnderlying() {
        return this.getObject();
    }

    private void instrumentAccess(Object key) {
        if (this._instrumented) {
            Integer i = this._accessMap.get(key);
            this._accessMap.put(key.toString(), i == null ? 1 : i + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ThreadLocal<Object> isTraversing() {
        if (this._isTraversing == null) {
            DataMap dataMap = this;
            synchronized (dataMap) {
                if (this._isTraversing == null) {
                    this._isTraversing = new ThreadLocal();
                }
            }
        }
        return this._isTraversing;
    }
}

