/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.UrnArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Siblings
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Siblings information of an entity.*/@Aspect.name=\"siblings\"record Siblings{/**List of sibling entities*/@Relationship.`/*`={\"entityTypes\":[\"dataset\"],\"name\":\"SiblingOf\"}@Searchable.`/*`={\"addHasValuesToFilters\":true,\"fieldName\":\"siblings\",\"fieldType\":\"URN\",\"hasValuesFieldName\":\"hasSiblings\",\"queryByDefault\":false}siblings:array[@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string]/**If this is the leader entity of the set of siblings*/primary:boolean}", SchemaFormatType.PDL);
    private UrnArray _siblingsField = null;
    private Boolean _primaryField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Siblings = SCHEMA.getField("siblings");
    private static final RecordDataSchema.Field FIELD_Primary = SCHEMA.getField("primary");

    public Siblings() {
        super(new DataMap(3, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public Siblings(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasSiblings() {
        if (this._siblingsField != null) {
            return true;
        }
        return this._map.containsKey("siblings");
    }

    public void removeSiblings() {
        this._map.remove("siblings");
    }

    @Nullable
    public UrnArray getSiblings(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getSiblings();
            }
            case DEFAULT: 
            case NULL: {
                if (this._siblingsField != null) {
                    return this._siblingsField;
                }
                Object __rawValue = this._map.get("siblings");
                this._siblingsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._siblingsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public UrnArray getSiblings() {
        if (this._siblingsField != null) {
            return this._siblingsField;
        }
        Object __rawValue = this._map.get("siblings");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("siblings");
        }
        this._siblingsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._siblingsField;
    }

    public Siblings setSiblings(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSiblings(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field siblings of com.linkedin.common.Siblings");
                }
                CheckedUtil.putWithoutChecking(this._map, "siblings", value.data());
                this._siblingsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSiblings();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "siblings", value.data());
                this._siblingsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "siblings", value.data());
                this._siblingsField = value;
            }
        }
        return this;
    }

    public Siblings setSiblings(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field siblings of com.linkedin.common.Siblings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "siblings", value.data());
        this._siblingsField = value;
        return this;
    }

    public boolean hasPrimary() {
        if (this._primaryField != null) {
            return true;
        }
        return this._map.containsKey("primary");
    }

    public void removePrimary() {
        this._map.remove("primary");
    }

    @Nullable
    public Boolean isPrimary(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.isPrimary();
            }
            case DEFAULT: 
            case NULL: {
                if (this._primaryField != null) {
                    return this._primaryField;
                }
                Object __rawValue = this._map.get("primary");
                this._primaryField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._primaryField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isPrimary() {
        if (this._primaryField != null) {
            return this._primaryField;
        }
        Object __rawValue = this._map.get("primary");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("primary");
        }
        this._primaryField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._primaryField;
    }

    public Siblings setPrimary(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPrimary(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field primary of com.linkedin.common.Siblings");
                }
                CheckedUtil.putWithoutChecking(this._map, "primary", value);
                this._primaryField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePrimary();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "primary", value);
                this._primaryField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "primary", value);
                this._primaryField = value;
            }
        }
        return this;
    }

    public Siblings setPrimary(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field primary of com.linkedin.common.Siblings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "primary", value);
        this._primaryField = value;
        return this;
    }

    public Siblings setPrimary(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "primary", value);
        this._primaryField = value;
        return this;
    }

    @Override
    public Siblings clone() throws CloneNotSupportedException {
        Siblings __clone = (Siblings)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public Siblings copy() throws CloneNotSupportedException {
        Siblings __copy = (Siblings)super.copy();
        __copy._siblingsField = null;
        __copy._primaryField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final Siblings __objectRef;

        private ChangeListener(Siblings reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "siblings": {
                    this.__objectRef._siblingsField = null;
                    break;
                }
                case "primary": {
                    this.__objectRef._primaryField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec siblings() {
            return new PathSpec(this.getPathComponents(), "siblings");
        }

        public PathSpec siblings(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "siblings");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec primary() {
            return new PathSpec(this.getPathComponents(), "primary");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withSiblings() {
            this.getDataMap().put("siblings", 1);
            return this;
        }

        public ProjectionMask withSiblings(Integer start, Integer count) {
            this.getDataMap().put("siblings", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("siblings").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("siblings").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withPrimary() {
            this.getDataMap().put("primary", 1);
            return this;
        }
    }
}

