/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.GlossaryTermAssociationArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GlossaryTerms
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Related business terms information*/@Aspect.name=\"glossaryTerms\"record GlossaryTerms{/**The related business terms*/terms:array[/**Properties of an applied glossary term.*/record GlossaryTermAssociation{/**Urn of the applied glossary term*/@Relationship={\"entityTypes\":[\"glossaryTerm\"],\"name\":\"TermedWith\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"glossaryTerms\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Glossary Term\",\"hasValuesFieldName\":\"hasGlossaryTerms\",\"includeSystemModifiedAt\":true,\"systemModifiedAtFieldName\":\"termsModifiedAt\"}urn:/**Business Term*/@java.class=\"com.linkedin.common.urn.GlossaryTermUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"business term\",\"entityType\":\"glossaryTerm\",\"fields\":[{\"doc\":\"The name of business term with hierarchy.\",\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":56,\"name\":\"GlossaryTerm\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref GlossaryTermUrn=string/**The user URN which will be credited for adding associating this term to the entity*/actor:optional@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"termAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"termAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"termAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:Urn/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}]/**Audit stamp containing who reported the related business term*/auditStamp:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:Time/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}", SchemaFormatType.PDL);
    private GlossaryTermAssociationArray _termsField = null;
    private AuditStamp _auditStampField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Terms = SCHEMA.getField("terms");
    private static final RecordDataSchema.Field FIELD_AuditStamp = SCHEMA.getField("auditStamp");

    public GlossaryTerms() {
        super(new DataMap(3, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public GlossaryTerms(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTerms() {
        if (this._termsField != null) {
            return true;
        }
        return this._map.containsKey("terms");
    }

    public void removeTerms() {
        this._map.remove("terms");
    }

    @Nullable
    public GlossaryTermAssociationArray getTerms(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTerms();
            }
            case DEFAULT: 
            case NULL: {
                if (this._termsField != null) {
                    return this._termsField;
                }
                Object __rawValue = this._map.get("terms");
                this._termsField = __rawValue == null ? null : new GlossaryTermAssociationArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._termsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public GlossaryTermAssociationArray getTerms() {
        if (this._termsField != null) {
            return this._termsField;
        }
        Object __rawValue = this._map.get("terms");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("terms");
        }
        this._termsField = __rawValue == null ? null : new GlossaryTermAssociationArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._termsField;
    }

    public GlossaryTerms setTerms(@Nullable GlossaryTermAssociationArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTerms(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field terms of com.linkedin.common.GlossaryTerms");
                }
                CheckedUtil.putWithoutChecking(this._map, "terms", value.data());
                this._termsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTerms();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "terms", value.data());
                this._termsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "terms", value.data());
                this._termsField = value;
            }
        }
        return this;
    }

    public GlossaryTerms setTerms(@Nonnull GlossaryTermAssociationArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field terms of com.linkedin.common.GlossaryTerms to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "terms", value.data());
        this._termsField = value;
        return this;
    }

    public boolean hasAuditStamp() {
        if (this._auditStampField != null) {
            return true;
        }
        return this._map.containsKey("auditStamp");
    }

    public void removeAuditStamp() {
        this._map.remove("auditStamp");
    }

    @Nullable
    public AuditStamp getAuditStamp(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAuditStamp();
            }
            case DEFAULT: 
            case NULL: {
                if (this._auditStampField != null) {
                    return this._auditStampField;
                }
                Object __rawValue = this._map.get("auditStamp");
                this._auditStampField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._auditStampField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getAuditStamp() {
        if (this._auditStampField != null) {
            return this._auditStampField;
        }
        Object __rawValue = this._map.get("auditStamp");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("auditStamp");
        }
        this._auditStampField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._auditStampField;
    }

    public GlossaryTerms setAuditStamp(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAuditStamp(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field auditStamp of com.linkedin.common.GlossaryTerms");
                }
                CheckedUtil.putWithoutChecking(this._map, "auditStamp", value.data());
                this._auditStampField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAuditStamp();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "auditStamp", value.data());
                this._auditStampField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "auditStamp", value.data());
                this._auditStampField = value;
            }
        }
        return this;
    }

    public GlossaryTerms setAuditStamp(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field auditStamp of com.linkedin.common.GlossaryTerms to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "auditStamp", value.data());
        this._auditStampField = value;
        return this;
    }

    @Override
    public GlossaryTerms clone() throws CloneNotSupportedException {
        GlossaryTerms __clone = (GlossaryTerms)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public GlossaryTerms copy() throws CloneNotSupportedException {
        GlossaryTerms __copy = (GlossaryTerms)super.copy();
        __copy._auditStampField = null;
        __copy._termsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final GlossaryTerms __objectRef;

        private ChangeListener(GlossaryTerms reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "auditStamp": {
                    this.__objectRef._auditStampField = null;
                    break;
                }
                case "terms": {
                    this.__objectRef._termsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public GlossaryTermAssociationArray.Fields terms() {
            return new GlossaryTermAssociationArray.Fields(this.getPathComponents(), "terms");
        }

        public PathSpec terms(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "terms");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public AuditStamp.Fields auditStamp() {
            return new AuditStamp.Fields(this.getPathComponents(), "auditStamp");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private GlossaryTermAssociationArray.ProjectionMask _termsMask;
        private AuditStamp.ProjectionMask _auditStampMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withTerms(Function<GlossaryTermAssociationArray.ProjectionMask, GlossaryTermAssociationArray.ProjectionMask> nestedMask) {
            this._termsMask = nestedMask.apply(this._termsMask == null ? GlossaryTermAssociationArray.createMask() : this._termsMask);
            this.getDataMap().put("terms", this._termsMask.getDataMap());
            return this;
        }

        public ProjectionMask withTerms() {
            this._termsMask = null;
            this.getDataMap().put("terms", 1);
            return this;
        }

        public ProjectionMask withTerms(Function<GlossaryTermAssociationArray.ProjectionMask, GlossaryTermAssociationArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._termsMask = nestedMask.apply(this._termsMask == null ? GlossaryTermAssociationArray.createMask() : this._termsMask);
            this.getDataMap().put("terms", this._termsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("terms").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("terms").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withTerms(Integer start, Integer count) {
            this._termsMask = null;
            this.getDataMap().put("terms", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("terms").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("terms").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withAuditStamp(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._auditStampMask = nestedMask.apply(this._auditStampMask == null ? AuditStamp.createMask() : this._auditStampMask);
            this.getDataMap().put("auditStamp", this._auditStampMask.getDataMap());
            return this;
        }

        public ProjectionMask withAuditStamp(MaskMap nestedMask) {
            this.getDataMap().put("auditStamp", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withAuditStamp() {
            this._auditStampMask = null;
            this.getDataMap().put("auditStamp", 1);
            return this;
        }
    }
}

