/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.urn.DataJobUrn;
import com.linkedin.data.DataList;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.DirectArrayTemplate;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.util.ArgumentUtil;
import java.util.Arrays;
import java.util.Collection;

public class DataJobUrnArray
extends DirectArrayTemplate<DataJobUrn> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.common/**Standardized data processing job identifier.*/@java.class=\"com.linkedin.common.urn.DataJobUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized data processing job identifier.\",\"entityType\":\"dataJob\",\"fields\":[{\"doc\":\"Standardized data processing flow urn representing the flow for the job\",\"name\":\"flow\",\"type\":\"com.linkedin.common.urn.DataFlowUrn\"},{\"doc\":\"Unique identifier of the data job\",\"maxLength\":200,\"name\":\"jobID\",\"type\":\"string\"}],\"maxLength\":594,\"name\":\"DataJob\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DataJobUrn=string}]", SchemaFormatType.PDL);

    public DataJobUrnArray() {
        this(new DataList());
    }

    public DataJobUrnArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public DataJobUrnArray(Collection<DataJobUrn> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public DataJobUrnArray(DataList data) {
        super(data, SCHEMA, DataJobUrn.class, String.class);
    }

    public DataJobUrnArray(DataJobUrn first, DataJobUrn ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    @Override
    public DataJobUrnArray clone() throws CloneNotSupportedException {
        DataJobUrnArray __clone = (DataJobUrnArray)super.clone();
        return __clone;
    }

    @Override
    public DataJobUrnArray copy() throws CloneNotSupportedException {
        DataJobUrnArray __copy = (DataJobUrnArray)super.copy();
        return __copy;
    }

    @Override
    protected Object coerceInput(DataJobUrn object) throws ClassCastException {
        ArgumentUtil.notNull(object, "object");
        return DataTemplateUtil.coerceCustomInput(object, DataJobUrn.class);
    }

    @Override
    protected DataJobUrn coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return DataTemplateUtil.coerceCustomOutput(object, DataJobUrn.class);
    }

    static {
        Custom.initializeCustomClass(DataJobUrn.class);
    }
}

