/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BrowsePaths
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Shared aspect containing Browse Paths to be indexed for an entity.*/@Aspect.name=\"browsePaths\"record BrowsePaths{/**A list of valid browse paths for the entity.\n\nBrowse paths are expected to be forward slash-separated strings. For example: 'prod/snowflake/datasetName'*/@Searchable.`/*`={\"fieldName\":\"browsePaths\",\"fieldType\":\"BROWSE_PATH\"}paths:array[string]}", SchemaFormatType.PDL);
    private StringArray _pathsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Paths = SCHEMA.getField("paths");

    public BrowsePaths() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public BrowsePaths(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasPaths() {
        if (this._pathsField != null) {
            return true;
        }
        return this._map.containsKey("paths");
    }

    public void removePaths() {
        this._map.remove("paths");
    }

    @Nullable
    public StringArray getPaths(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getPaths();
            }
            case DEFAULT: 
            case NULL: {
                if (this._pathsField != null) {
                    return this._pathsField;
                }
                Object __rawValue = this._map.get("paths");
                this._pathsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._pathsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringArray getPaths() {
        if (this._pathsField != null) {
            return this._pathsField;
        }
        Object __rawValue = this._map.get("paths");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("paths");
        }
        this._pathsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._pathsField;
    }

    public BrowsePaths setPaths(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPaths(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field paths of com.linkedin.common.BrowsePaths");
                }
                CheckedUtil.putWithoutChecking(this._map, "paths", value.data());
                this._pathsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePaths();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "paths", value.data());
                this._pathsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "paths", value.data());
                this._pathsField = value;
            }
        }
        return this;
    }

    public BrowsePaths setPaths(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field paths of com.linkedin.common.BrowsePaths to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "paths", value.data());
        this._pathsField = value;
        return this;
    }

    @Override
    public BrowsePaths clone() throws CloneNotSupportedException {
        BrowsePaths __clone = (BrowsePaths)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public BrowsePaths copy() throws CloneNotSupportedException {
        BrowsePaths __copy = (BrowsePaths)super.copy();
        __copy._pathsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final BrowsePaths __objectRef;

        private ChangeListener(BrowsePaths reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "paths": {
                    this.__objectRef._pathsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec paths() {
            return new PathSpec(this.getPathComponents(), "paths");
        }

        public PathSpec paths(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "paths");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withPaths() {
            this.getDataMap().put("paths", 1);
            return this;
        }

        public ProjectionMask withPaths(Integer start, Integer count) {
            this.getDataMap().put("paths", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("paths").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("paths").put("$count", count);
            }
            return this;
        }
    }
}

