/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.chart;

import com.linkedin.chart.ChartDataSourceType;
import com.linkedin.data.DataList;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class ChartDataSourceTypeArray
extends WrappingArrayTemplate<ChartDataSourceType> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[union[{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}]]", SchemaFormatType.PDL);

    public ChartDataSourceTypeArray() {
        this(new DataList());
    }

    public ChartDataSourceTypeArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public ChartDataSourceTypeArray(Collection<ChartDataSourceType> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public ChartDataSourceTypeArray(DataList data) {
        super(data, SCHEMA, ChartDataSourceType.class);
    }

    public ChartDataSourceTypeArray(ChartDataSourceType first, ChartDataSourceType ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public ChartDataSourceTypeArray clone() throws CloneNotSupportedException {
        ChartDataSourceTypeArray __clone = (ChartDataSourceTypeArray)super.clone();
        return __clone;
    }

    @Override
    public ChartDataSourceTypeArray copy() throws CloneNotSupportedException {
        ChartDataSourceTypeArray __copy = (ChartDataSourceTypeArray)super.copy();
        return __copy;
    }

    @Override
    protected ChartDataSourceType coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new ChartDataSourceType(object);
    }

    public static class ProjectionMask
    extends MaskMap {
        private ChartDataSourceType.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<ChartDataSourceType.ProjectionMask, ChartDataSourceType.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? ChartDataSourceType.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public ChartDataSourceType.Fields items() {
            return new ChartDataSourceType.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

