/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.objects.type.livemap;

import io.ably.lib.objects.ObjectData;
import io.ably.lib.objects.ObjectMessageKt;
import io.ably.lib.objects.ObjectOperation;
import io.ably.lib.objects.ObjectOperationAction;
import io.ably.lib.objects.ObjectState;
import io.ably.lib.objects.ObjectsMap;
import io.ably.lib.objects.ObjectsMapEntry;
import io.ably.lib.objects.ObjectsMapOp;
import io.ably.lib.objects.ObjectsMapSemantics;
import io.ably.lib.objects.UtilsKt;
import io.ably.lib.objects.type.BaseRealtimeObjectKt;
import io.ably.lib.objects.type.ObjectUpdate;
import io.ably.lib.objects.type.livemap.DefaultLiveMap;
import io.ably.lib.objects.type.livemap.LiveMapChangeCoordinator;
import io.ably.lib.objects.type.livemap.LiveMapChangeCoordinatorKt;
import io.ably.lib.objects.type.livemap.LiveMapEntry;
import io.ably.lib.objects.type.map.LiveMapUpdate;
import io.ably.lib.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J+\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u0002J)\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001c\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010#\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J5\u0010$\u001a\u00020\n2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020'0&2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020'0&H\u0000\u00a2\u0006\u0002\b)J\u0015\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b,J\u0010\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020/H\u0002J\u0012\u00100\u001a\u00020\u00122\b\u00101\u001a\u0004\u0018\u000102H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lio/ably/lib/objects/type/livemap/LiveMapManager;", "Lio/ably/lib/objects/type/livemap/LiveMapChangeCoordinator;", "liveMap", "Lio/ably/lib/objects/type/livemap/DefaultLiveMap;", "<init>", "(Lio/ably/lib/objects/type/livemap/DefaultLiveMap;)V", "objectId", "", "tag", "applyState", "Lio/ably/lib/objects/type/map/LiveMapUpdate;", "objectState", "Lio/ably/lib/objects/ObjectState;", "serialTimestamp", "", "applyState$liveobjects", "(Lio/ably/lib/objects/ObjectState;Ljava/lang/Long;)Lio/ably/lib/objects/type/map/LiveMapUpdate;", "applyOperation", "", "operation", "Lio/ably/lib/objects/ObjectOperation;", "serial", "applyOperation$liveobjects", "(Lio/ably/lib/objects/ObjectOperation;Ljava/lang/String;Ljava/lang/Long;)V", "applyMapCreate", "applyMapSet", "mapOp", "Lio/ably/lib/objects/ObjectsMapOp;", "timeSerial", "applyMapRemove", "timeStamp", "(Lio/ably/lib/objects/ObjectsMapOp;Ljava/lang/String;Ljava/lang/Long;)Lio/ably/lib/objects/type/map/LiveMapUpdate;", "canApplyMapOperation", "", "existingMapEntrySerial", "mergeInitialDataFromCreateOperation", "calculateUpdateFromDataDiff", "prevData", "", "Lio/ably/lib/objects/type/livemap/LiveMapEntry;", "newData", "calculateUpdateFromDataDiff$liveobjects", "validate", "state", "validate$liveobjects", "validateMapCreateAction", "action", "Lio/ably/lib/objects/ObjectOperationAction;", "validateMapSemantics", "semantics", "Lio/ably/lib/objects/ObjectsMapSemantics;", "liveobjects"})
@SourceDebugExtension(value={"SMAP\nLiveMapManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveMapManager.kt\nio/ably/lib/objects/type/livemap/LiveMapManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,335:1\n216#2,2:336\n216#2,2:338\n1557#3:340\n1628#3,3:341\n1797#3,3:344\n*S KotlinDebug\n*F\n+ 1 LiveMapManager.kt\nio/ably/lib/objects/type/livemap/LiveMapManager\n*L\n33#1:336,2\n231#1:338,2\n253#1:340\n253#1:341,3\n253#1:344,3\n*E\n"})
public final class LiveMapManager
extends LiveMapChangeCoordinator {
    @NotNull
    private final DefaultLiveMap liveMap;
    @NotNull
    private final String objectId;
    @NotNull
    private final String tag;

    public LiveMapManager(@NotNull DefaultLiveMap liveMap) {
        Intrinsics.checkNotNullParameter((Object)liveMap, (String)"liveMap");
        this.liveMap = liveMap;
        this.objectId = this.liveMap.getObjectId$liveobjects();
        this.tag = "LiveMapManager";
    }

    @NotNull
    public final LiveMapUpdate applyState$liveobjects(@NotNull ObjectState objectState, @Nullable Long serialTimestamp) {
        Intrinsics.checkNotNullParameter((Object)objectState, (String)"objectState");
        Map previousData = MapsKt.toMap((Map)this.liveMap.getData$liveobjects());
        if (objectState.getTombstone()) {
            v0 = this.liveMap.tombstone$liveobjects(serialTimestamp);
        } else {
            LiveMapUpdate liveMapUpdate;
            this.liveMap.setCreateOperationIsMerged$liveobjects(false);
            this.liveMap.getData$liveobjects().clear();
            Object object = objectState.getMap();
            if (object != null && (object = ((ObjectsMap)object).getEntries()) != null) {
                Object $this$forEach$iv = object;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Long l;
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl = false;
                    String key = (String)entry.getKey();
                    ObjectsMapEntry entry2 = (ObjectsMapEntry)entry.getValue();
                    Map map = this.liveMap.getData$liveobjects();
                    Boolean bl2 = entry2.getTombstone();
                    boolean bl3 = bl2 != null ? bl2 : false;
                    if (Intrinsics.areEqual((Object)entry2.getTombstone(), (Object)true)) {
                        Long l2 = entry2.getSerialTimestamp();
                        l = l2 != null ? l2 : System.currentTimeMillis();
                    } else {
                        l = null;
                    }
                    LiveMapEntry liveMapEntry = new LiveMapEntry(bl3, l, entry2.getTimeserial(), entry2.getData());
                    map.put(key, liveMapEntry);
                }
            }
            ObjectOperation objectOperation = objectState.getCreateOp();
            if (objectOperation != null) {
                ObjectOperation createOp = objectOperation;
                boolean bl = false;
                liveMapUpdate = this.mergeInitialDataFromCreateOperation(createOp);
            } else {
                liveMapUpdate = null;
            }
            v0 = (ObjectUpdate)liveMapUpdate;
        }
        return this.calculateUpdateFromDataDiff$liveobjects(previousData, MapsKt.toMap((Map)this.liveMap.getData$liveobjects()));
    }

    public final void applyOperation$liveobjects(@NotNull ObjectOperation operation, @Nullable String serial, @Nullable Long serialTimestamp) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        ObjectUpdate update = switch (WhenMappings.$EnumSwitchMapping$0[operation.getAction().ordinal()]) {
            case 1 -> (ObjectUpdate)this.applyMapCreate(operation);
            case 2 -> {
                if (operation.getMapOp() == null) {
                    throw UtilsKt.objectError$default("No payload found for " + operation.getAction() + " op for LiveMap objectId=" + this.objectId, null, 2, null);
                }
                yield (ObjectUpdate)this.applyMapSet(operation.getMapOp(), serial);
            }
            case 3 -> {
                if (operation.getMapOp() == null) {
                    throw UtilsKt.objectError$default("No payload found for " + operation.getAction() + " op for LiveMap objectId=" + this.objectId, null, 2, null);
                }
                yield (ObjectUpdate)this.applyMapRemove(operation.getMapOp(), serial, serialTimestamp);
            }
            case 4 -> this.liveMap.tombstone$liveobjects(serialTimestamp);
            default -> throw UtilsKt.objectError$default("Invalid " + operation.getAction() + " op for LiveMap objectId=" + this.objectId, null, 2, null);
        };
        this.liveMap.notifyUpdated(update);
    }

    private final LiveMapUpdate applyMapCreate(ObjectOperation operation) {
        if (this.liveMap.getCreateOperationIsMerged$liveobjects()) {
            Log.v((String)this.tag, (String)("Skipping applying MAP_CREATE op on a map instance as it was already applied before; objectId=" + this.objectId));
            return LiveMapChangeCoordinatorKt.getNoOpMapUpdate();
        }
        ObjectsMap objectsMap = operation.getMap();
        this.validateMapSemantics(objectsMap != null ? objectsMap.getSemantics() : null);
        return this.mergeInitialDataFromCreateOperation(operation);
    }

    private final LiveMapUpdate applyMapSet(ObjectsMapOp mapOp, String timeSerial) {
        LiveMapEntry existingEntry = this.liveMap.getData$liveobjects().get(mapOp.getKey());
        if (existingEntry != null && !this.canApplyMapOperation(existingEntry.getTimeserial(), timeSerial)) {
            Log.v((String)this.tag, (String)("Skipping update for key=\"" + mapOp.getKey() + "\": op serial " + timeSerial + " <= entry serial " + existingEntry.getTimeserial() + "; objectId=" + this.objectId));
            return LiveMapChangeCoordinatorKt.getNoOpMapUpdate();
        }
        if (ObjectMessageKt.isInvalid(mapOp.getData())) {
            throw UtilsKt.objectError$default("Invalid object data for MAP_SET op on objectId=" + this.objectId + " on key=" + mapOp.getKey(), null, 2, null);
        }
        Object object = mapOp.getData();
        if (object != null && (object = ((ObjectData)object).getObjectId()) != null) {
            Object it = object;
            boolean bl = false;
            this.liveMap.getObjectsPool$liveobjects().createZeroValueObjectIfNotExists$liveobjects((String)it);
        }
        if (existingEntry != null) {
            ((Map)this.liveMap.getData$liveobjects()).put(mapOp.getKey(), new LiveMapEntry(false, null, timeSerial, mapOp.getData(), 2, null));
        } else {
            ((Map)this.liveMap.getData$liveobjects()).put(mapOp.getKey(), new LiveMapEntry(false, null, timeSerial, mapOp.getData(), 2, null));
        }
        return new LiveMapUpdate(MapsKt.mapOf((Pair)TuplesKt.to((Object)mapOp.getKey(), (Object)LiveMapUpdate.Change.UPDATED)));
    }

    private final LiveMapUpdate applyMapRemove(ObjectsMapOp mapOp, String timeSerial, Long timeStamp) {
        long tombstonedAt;
        LiveMapEntry existingEntry = this.liveMap.getData$liveobjects().get(mapOp.getKey());
        if (existingEntry != null && !this.canApplyMapOperation(existingEntry.getTimeserial(), timeSerial)) {
            Log.v((String)this.tag, (String)("Skipping remove for key=\"" + mapOp.getKey() + "\": op serial " + timeSerial + " <= entry serial " + existingEntry.getTimeserial() + "; objectId=" + this.objectId));
            return LiveMapChangeCoordinatorKt.getNoOpMapUpdate();
        }
        Long l = timeStamp;
        if (l != null) {
            v1 = l;
        } else {
            Log.w((String)this.tag, (String)("No timestamp provided for MAP_REMOVE op on key=\"" + mapOp.getKey() + "\"; using current time as tombstone time; objectId=" + this.objectId));
            v1 = tombstonedAt = System.currentTimeMillis();
        }
        if (existingEntry != null) {
            ((Map)this.liveMap.getData$liveobjects()).put(mapOp.getKey(), new LiveMapEntry(true, tombstonedAt, timeSerial, null));
        } else {
            ((Map)this.liveMap.getData$liveobjects()).put(mapOp.getKey(), new LiveMapEntry(true, tombstonedAt, timeSerial, null, 8, null));
        }
        return new LiveMapUpdate(MapsKt.mapOf((Pair)TuplesKt.to((Object)mapOp.getKey(), (Object)LiveMapUpdate.Change.REMOVED)));
    }

    private final boolean canApplyMapOperation(String existingMapEntrySerial, String timeSerial) {
        CharSequence charSequence = existingMapEntrySerial;
        if ((charSequence == null || charSequence.length() == 0) && ((charSequence = (CharSequence)timeSerial) == null || charSequence.length() == 0)) {
            return false;
        }
        charSequence = existingMapEntrySerial;
        if (charSequence == null || charSequence.length() == 0) {
            return true;
        }
        charSequence = timeSerial;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        return timeSerial.compareTo(existingMapEntrySerial) > 0;
    }

    /*
     * WARNING - void declaration
     */
    private final LiveMapUpdate mergeInitialDataFromCreateOperation(ObjectOperation operation) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        Object $this$forEach$iv;
        ObjectsMap objectsMap = operation.getMap();
        Map<String, ObjectsMapEntry> map = objectsMap != null ? objectsMap.getEntries() : null;
        if (map == null || map.isEmpty()) {
            return LiveMapChangeCoordinatorKt.getNoOpMapUpdate();
        }
        List aggregatedUpdate = new ArrayList();
        Object object = operation.getMap();
        if (object != null && (object = ((ObjectsMap)object).getEntries()) != null) {
            $this$forEach$iv = object;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                LiveMapUpdate update;
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                boolean bl = false;
                String key = (String)entry2.getKey();
                ObjectsMapEntry entry22 = (ObjectsMapEntry)entry2.getValue();
                String opTimeserial = entry22.getTimeserial();
                LiveMapUpdate liveMapUpdate = update = Intrinsics.areEqual((Object)entry22.getTombstone(), (Object)true) ? this.applyMapRemove(new ObjectsMapOp(key, null, 2, null), opTimeserial, entry22.getSerialTimestamp()) : this.applyMapSet(new ObjectsMapOp(key, entry22.getData()), opTimeserial);
                if (BaseRealtimeObjectKt.getNoOp((ObjectUpdate)update)) continue;
                aggregatedUpdate.add(update);
            }
        }
        this.liveMap.setCreateOperationIsMerged$liveobjects(true);
        Iterable $this$map$iv = aggregatedUpdate;
        boolean $i$f$map = false;
        $this$forEach$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LiveMapUpdate bl = (LiveMapUpdate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getUpdate());
        }
        $this$map$iv = (List)destination$iv$iv;
        Map initial$iv = MapsKt.emptyMap();
        boolean $i$f$fold = false;
        Map accumulator$iv = initial$iv;
        for (Object t : $this$fold$iv) {
            void map2;
            Object item$iv$iv;
            item$iv$iv = (Map)t;
            Map acc = accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)map2);
            accumulator$iv = MapsKt.plus((Map)acc, (Map)map2);
        }
        Map map2 = accumulator$iv;
        return new LiveMapUpdate(map2);
    }

    @NotNull
    public final LiveMapUpdate calculateUpdateFromDataDiff$liveobjects(@NotNull Map<String, LiveMapEntry> prevData, @NotNull Map<String, LiveMapEntry> newData) {
        String key;
        Intrinsics.checkNotNullParameter(prevData, (String)"prevData");
        Intrinsics.checkNotNullParameter(newData, (String)"newData");
        Map update = new LinkedHashMap();
        for (Map.Entry<String, LiveMapEntry> entry : prevData.entrySet()) {
            key = entry.getKey();
            LiveMapEntry prevEntry = entry.getValue();
            if (prevEntry.isTombstoned() || newData.containsKey(key)) continue;
            update.put(key, LiveMapUpdate.Change.REMOVED);
        }
        for (Map.Entry<String, LiveMapEntry> entry : newData.entrySet()) {
            boolean valueChanged;
            LiveMapEntry prevEntry;
            key = entry.getKey();
            LiveMapEntry newEntry = entry.getValue();
            if (!prevData.containsKey(key)) {
                if (newEntry.isTombstoned()) continue;
                update.put(key, LiveMapUpdate.Change.UPDATED);
                continue;
            }
            Intrinsics.checkNotNull((Object)prevData.get(key));
            if (prevEntry.isTombstoned() && !newEntry.isTombstoned()) {
                update.put(key, LiveMapUpdate.Change.UPDATED);
                continue;
            }
            if (!prevEntry.isTombstoned() && newEntry.isTombstoned()) {
                update.put(key, LiveMapUpdate.Change.REMOVED);
                continue;
            }
            if (prevEntry.isTombstoned() && newEntry.isTombstoned() || !(valueChanged = !Intrinsics.areEqual((Object)prevEntry.getData(), (Object)newEntry.getData()))) continue;
            update.put(key, LiveMapUpdate.Change.UPDATED);
        }
        return new LiveMapUpdate(update);
    }

    public final void validate$liveobjects(@NotNull ObjectState state) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.liveMap.validateObjectId$liveobjects(state.getObjectId());
            ObjectsMap objectsMap = state.getMap();
            this.validateMapSemantics(objectsMap != null ? objectsMap.getSemantics() : null);
            ObjectOperation objectOperation = state.getCreateOp();
            if (objectOperation == null) break block0;
            ObjectOperation createOp = objectOperation;
            boolean bl = false;
            this.liveMap.validateObjectId$liveobjects(createOp.getObjectId());
            this.validateMapCreateAction(createOp.getAction());
            ObjectsMap objectsMap2 = createOp.getMap();
            this.validateMapSemantics(objectsMap2 != null ? objectsMap2.getSemantics() : null);
        }
    }

    private final void validateMapCreateAction(ObjectOperationAction action) {
        if (action != ObjectOperationAction.MapCreate) {
            throw UtilsKt.objectError$default("Invalid create operation action " + action + " for LiveMap objectId=" + this.objectId, null, 2, null);
        }
    }

    private final void validateMapSemantics(ObjectsMapSemantics semantics) {
        if (semantics != this.liveMap.getSemantics$liveobjects()) {
            throw UtilsKt.objectError$default("Invalid object: incoming object map semantics=" + semantics + "; current map semantics=" + ObjectsMapSemantics.LWW, null, 2, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ObjectOperationAction.values().length];
            try {
                nArray[ObjectOperationAction.MapCreate.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectOperationAction.MapSet.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectOperationAction.MapRemove.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectOperationAction.ObjectDelete.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

