/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.objects.type.livecounter;

import io.ably.lib.objects.ObjectOperation;
import io.ably.lib.objects.ObjectOperationAction;
import io.ably.lib.objects.ObjectState;
import io.ably.lib.objects.ObjectsCounter;
import io.ably.lib.objects.ObjectsCounterOp;
import io.ably.lib.objects.UtilsKt;
import io.ably.lib.objects.type.ObjectUpdate;
import io.ably.lib.objects.type.counter.LiveCounterUpdate;
import io.ably.lib.objects.type.livecounter.DefaultLiveCounter;
import io.ably.lib.objects.type.livecounter.LiveCounterChangeCoordinator;
import io.ably.lib.objects.type.livecounter.LiveCounterChangeCoordinatorKt;
import io.ably.lib.util.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J!\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001d\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0015\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b#J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/ably/lib/objects/type/livecounter/LiveCounterManager;", "Lio/ably/lib/objects/type/livecounter/LiveCounterChangeCoordinator;", "liveCounter", "Lio/ably/lib/objects/type/livecounter/DefaultLiveCounter;", "<init>", "(Lio/ably/lib/objects/type/livecounter/DefaultLiveCounter;)V", "objectId", "", "tag", "applyState", "Lio/ably/lib/objects/type/counter/LiveCounterUpdate;", "objectState", "Lio/ably/lib/objects/ObjectState;", "serialTimestamp", "", "applyState$liveobjects", "(Lio/ably/lib/objects/ObjectState;Ljava/lang/Long;)Lio/ably/lib/objects/type/counter/LiveCounterUpdate;", "applyOperation", "", "operation", "Lio/ably/lib/objects/ObjectOperation;", "applyOperation$liveobjects", "(Lio/ably/lib/objects/ObjectOperation;Ljava/lang/Long;)V", "applyCounterCreate", "applyCounterInc", "counterOp", "Lio/ably/lib/objects/ObjectsCounterOp;", "calculateUpdateFromDataDiff", "prevData", "", "newData", "calculateUpdateFromDataDiff$liveobjects", "mergeInitialDataFromCreateOperation", "validate", "state", "validate$liveobjects", "validateCounterCreateAction", "action", "Lio/ably/lib/objects/ObjectOperationAction;", "liveobjects"})
public final class LiveCounterManager
extends LiveCounterChangeCoordinator {
    @NotNull
    private final DefaultLiveCounter liveCounter;
    @NotNull
    private final String objectId;
    @NotNull
    private final String tag;

    public LiveCounterManager(@NotNull DefaultLiveCounter liveCounter) {
        Intrinsics.checkNotNullParameter((Object)liveCounter, (String)"liveCounter");
        this.liveCounter = liveCounter;
        this.objectId = this.liveCounter.getObjectId$liveobjects();
        this.tag = "LiveCounterManager";
    }

    @NotNull
    public final LiveCounterUpdate applyState$liveobjects(@NotNull ObjectState objectState, @Nullable Long serialTimestamp) {
        Intrinsics.checkNotNullParameter((Object)objectState, (String)"objectState");
        Double previousData = this.liveCounter.getData$liveobjects().get();
        if (objectState.getTombstone()) {
            v0 = this.liveCounter.tombstone$liveobjects(serialTimestamp);
        } else {
            LiveCounterUpdate liveCounterUpdate;
            Object object;
            this.liveCounter.setCreateOperationIsMerged$liveobjects(false);
            this.liveCounter.getData$liveobjects().set((object = objectState.getCounter()) != null && (object = ((ObjectsCounter)object).getCount()) != null ? (Double)object : 0.0);
            ObjectOperation objectOperation = objectState.getCreateOp();
            if (objectOperation != null) {
                ObjectOperation createOp = objectOperation;
                boolean bl = false;
                liveCounterUpdate = this.mergeInitialDataFromCreateOperation(createOp);
            } else {
                liveCounterUpdate = null;
            }
            v0 = (ObjectUpdate)liveCounterUpdate;
        }
        Intrinsics.checkNotNull((Object)previousData);
        double d = previousData;
        Double d2 = this.liveCounter.getData$liveobjects().get();
        Intrinsics.checkNotNullExpressionValue((Object)d2, (String)"get(...)");
        return this.calculateUpdateFromDataDiff$liveobjects(d, ((Number)d2).doubleValue());
    }

    public final void applyOperation$liveobjects(@NotNull ObjectOperation operation, @Nullable Long serialTimestamp) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        ObjectUpdate update = switch (WhenMappings.$EnumSwitchMapping$0[operation.getAction().ordinal()]) {
            case 1 -> (ObjectUpdate)this.applyCounterCreate(operation);
            case 2 -> {
                if (operation.getCounterOp() == null) {
                    throw UtilsKt.objectError$default("No payload found for " + operation.getAction() + " op for LiveCounter objectId=" + this.objectId, null, 2, null);
                }
                yield (ObjectUpdate)this.applyCounterInc(operation.getCounterOp());
            }
            case 3 -> this.liveCounter.tombstone$liveobjects(serialTimestamp);
            default -> throw UtilsKt.objectError$default("Invalid " + operation.getAction() + " op for LiveCounter objectId=" + this.objectId, null, 2, null);
        };
        this.liveCounter.notifyUpdated(update);
    }

    private final LiveCounterUpdate applyCounterCreate(ObjectOperation operation) {
        if (this.liveCounter.getCreateOperationIsMerged$liveobjects()) {
            Log.v((String)this.tag, (String)("Skipping applying COUNTER_CREATE op on a counter instance as it was already applied before; objectId=" + this.objectId));
            return LiveCounterChangeCoordinatorKt.getNoOpCounterUpdate();
        }
        return this.mergeInitialDataFromCreateOperation(operation);
    }

    private final LiveCounterUpdate applyCounterInc(ObjectsCounterOp counterOp) {
        Double d = counterOp.getAmount();
        double amount = d != null ? d : 0.0;
        Double previousValue = this.liveCounter.getData$liveobjects().get();
        this.liveCounter.getData$liveobjects().set(previousValue + amount);
        return new LiveCounterUpdate(Double.valueOf(amount));
    }

    @NotNull
    public final LiveCounterUpdate calculateUpdateFromDataDiff$liveobjects(double prevData, double newData) {
        return new LiveCounterUpdate(Double.valueOf(newData - prevData));
    }

    private final LiveCounterUpdate mergeInitialDataFromCreateOperation(ObjectOperation operation) {
        Object object = operation.getCounter();
        double count = object != null && (object = ((ObjectsCounter)object).getCount()) != null ? (Double)object : 0.0;
        Double previousValue = this.liveCounter.getData$liveobjects().get();
        this.liveCounter.getData$liveobjects().set(previousValue + count);
        this.liveCounter.setCreateOperationIsMerged$liveobjects(true);
        return new LiveCounterUpdate(Double.valueOf(count));
    }

    public final void validate$liveobjects(@NotNull ObjectState state) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.liveCounter.validateObjectId$liveobjects(state.getObjectId());
            ObjectOperation objectOperation = state.getCreateOp();
            if (objectOperation == null) break block0;
            ObjectOperation createOp = objectOperation;
            boolean bl = false;
            this.liveCounter.validateObjectId$liveobjects(createOp.getObjectId());
            this.validateCounterCreateAction(createOp.getAction());
        }
    }

    private final void validateCounterCreateAction(ObjectOperationAction action) {
        if (action != ObjectOperationAction.CounterCreate) {
            throw UtilsKt.objectError$default("Invalid create operation action " + action + " for LiveCounter objectId=" + this.objectId, null, 2, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ObjectOperationAction.values().length];
            try {
                nArray[ObjectOperationAction.CounterCreate.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectOperationAction.CounterInc.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectOperationAction.ObjectDelete.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

